/*
 * Decompiled with CFR 0.152.
 */
package dev.igorilic.redstonemanager.util;

import dev.igorilic.redstonemanager.component.ModDataComponents;
import dev.igorilic.redstonemanager.item.custom.RedstoneLinkerItem;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;

public class ChunkHandler {
    public static void tempLoadChunk(ServerLevel level, ItemStack stack, Consumer<ServerLevel> callback) {
        if (!(stack.getItem() instanceof RedstoneLinkerItem)) {
            return;
        }
        BlockPos cords = (BlockPos)stack.get(ModDataComponents.COORDINATES);
        if (cords == null) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(cords);
        if (level.isLoaded(cords)) {
            ChunkHandler.handler(level, cords, callback, chunkPos);
            return;
        }
        level.getChunkSource().addRegionTicket(TicketType.FORCED, chunkPos, 2, (Object)chunkPos);
        level.getServer().execute(() -> ChunkHandler.handler(level, cords, callback, chunkPos));
    }

    public static void tempLoadChunk(ServerLevel level, BlockPos pos, Consumer<ServerLevel> callback) {
        ChunkPos chunkPos = new ChunkPos(pos);
        if (level.isLoaded(pos)) {
            ChunkHandler.handler(level, pos, callback, chunkPos);
            return;
        }
        level.getChunkSource().addRegionTicket(TicketType.FORCED, chunkPos, 2, (Object)chunkPos);
        ChunkHandler.handler(level, pos, callback, chunkPos);
    }

    private static void handler(ServerLevel level, BlockPos pos, Consumer<ServerLevel> callback, ChunkPos chunkPos) {
        level.getServer().tell((Runnable)new TickTask(level.getServer().getTickCount() + 2, () -> {
            if (level.isLoaded(pos) && level.getChunkSource().hasChunk(chunkPos.x, chunkPos.z)) {
                callback.accept(level);
            }
            level.getChunkSource().removeRegionTicket(TicketType.FORCED, chunkPos, 2, (Object)chunkPos);
        }));
    }
}

