/*
 * Decompiled with CFR 0.152.
 */
package dev.igorilic.redstonemanager.util;

import dev.igorilic.redstonemanager.network.PacketHandler;
import dev.igorilic.redstonemanager.network.PacketLeverStateRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class LeverStateCache {
    private static final Map<BlockPos, CachedLever> leverStates = new HashMap<BlockPos, CachedLever>();

    public static void update(BlockPos pos, boolean found, boolean powered) {
        leverStates.put(pos, new CachedLever(found, powered, System.currentTimeMillis()));
    }

    public static Optional<CachedLever> get(BlockPos pos) {
        if (leverStates.isEmpty()) {
            return Optional.empty();
        }
        CachedLever cached = leverStates.get(pos);
        if (cached == null || System.currentTimeMillis() - cached.timestamp > 60000L) {
            return Optional.empty();
        }
        return Optional.of(cached);
    }

    public static void requestIfNeeded(BlockPos pos, Optional<ResourceLocation> dim) {
        if (leverStates.isEmpty() || LeverStateCache.get(pos).isEmpty()) {
            PacketHandler.sendToServer(new PacketLeverStateRequest(pos, dim));
        }
    }

    public static void refreshAll() {
        leverStates.clear();
    }

    public record CachedLever(boolean found, boolean powered, long timestamp) {
    }
}

