/*
 * Decompiled with CFR 0.152.
 */
package dev.igorilic.redstonemanager.util;

import dev.igorilic.redstonemanager.component.ModDataComponents;
import dev.igorilic.redstonemanager.util.ModTags;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class LinkerGroup {
    private String groupName;
    private boolean isPowered = false;
    private List<ItemStack> items = new ArrayList<ItemStack>();

    public LinkerGroup(String groupName) {
        this.groupName = groupName;
    }

    public LinkerGroup(String groupName, boolean isPowered) {
        this.groupName = groupName;
        this.isPowered = isPowered;
    }

    public LinkerGroup(String groupName, boolean isPowered, List<ItemStack> stacks) {
        this.groupName = groupName;
        this.isPowered = isPowered;
        this.items = stacks;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean powered) {
        this.isPowered = powered;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinkerGroup)) {
            return false;
        }
        LinkerGroup that = (LinkerGroup)o;
        return this.groupName.equals(that.groupName) && this.isPowered == that.isPowered && this.items.size() == that.items.size();
    }

    public int hashCode() {
        return this.groupName.hashCode();
    }

    public String toString() {
        return this.groupName;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(List<ItemStack> items) {
        this.items = items;
    }

    public void addItem(ItemStack stack) {
        this.items.add(stack);
    }

    public void removeItem(ItemStack stack) {
        int index = this.findLinkerIndex(stack);
        if (index != -1) {
            this.items.remove(index);
        }
    }

    public int findLinkerIndex(ItemStack target) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack linker = this.items.get(i).copy();
            if (linker.has(ModDataComponents.COORDINATES) && target.has(ModDataComponents.COORDINATES)) {
                BlockPos linkPos = (BlockPos)linker.get(ModDataComponents.COORDINATES);
                BlockPos targetPos = (BlockPos)target.get(ModDataComponents.COORDINATES);
                assert (linkPos != null);
                if (!linkPos.equals((Object)targetPos)) continue;
                return i;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)this.items.get(i), (ItemStack)target)) continue;
            return i;
        }
        return -1;
    }

    public static boolean canLink(BlockState state) {
        boolean hasMatch = false;
        for (TagKey tag : state.getTags().toList()) {
            if (!tag.equals(ModTags.Blocks.LINKABLE_ITEMS)) continue;
            hasMatch = true;
            break;
        }
        return hasMatch;
    }
}

