/*
 * Decompiled with CFR 0.152.
 */
package dev.igorilic.redstonemanager.network;

import dev.igorilic.redstonemanager.network.PacketCreateGroup;
import dev.igorilic.redstonemanager.network.PacketDeleteGroup;
import dev.igorilic.redstonemanager.network.PacketLeverStateRequest;
import dev.igorilic.redstonemanager.network.PacketLeverStateResponse;
import dev.igorilic.redstonemanager.network.PacketMoveItemBetweenInventories;
import dev.igorilic.redstonemanager.network.PacketPlaySound;
import dev.igorilic.redstonemanager.network.PacketRefreshGroupPoweredState;
import dev.igorilic.redstonemanager.network.PacketRenameGroup;
import dev.igorilic.redstonemanager.network.PacketToggleAllLevers;
import dev.igorilic.redstonemanager.network.PacketToggleLever;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class PacketHandler {
    private static PayloadRegistrar registrar;

    public static void register(IEventBus modEventBus) {
        modEventBus.addListener(PacketHandler::onRegisterPayloadHandlers);
    }

    private static void onRegisterPayloadHandlers(RegisterPayloadHandlersEvent event) {
        registrar = event.registrar("redstonemanager").versioned("1.0");
        registrar.playToServer(PacketToggleLever.TYPE, PacketToggleLever.STREAM_CODEC, PacketToggleLever.HANDLER);
        registrar.playToServer(PacketCreateGroup.TYPE, PacketCreateGroup.STREAM_CODEC, PacketCreateGroup.HANDLER);
        registrar.playToServer(PacketToggleAllLevers.TYPE, PacketToggleAllLevers.STREAM_CODEC, PacketToggleAllLevers.HANDLER);
        registrar.playToServer(PacketRenameGroup.TYPE, PacketRenameGroup.STREAM_CODEC, PacketRenameGroup.HANDLER);
        registrar.playToServer(PacketDeleteGroup.TYPE, PacketDeleteGroup.STREAM_CODEC, PacketDeleteGroup.HANDLER);
        registrar.playToServer(PacketMoveItemBetweenInventories.TYPE, PacketMoveItemBetweenInventories.STREAM_CODEC, PacketMoveItemBetweenInventories.HANDLER);
        registrar.playToServer(PacketPlaySound.TYPE, PacketPlaySound.STREAM_CODEC, PacketPlaySound.HANDLER);
        registrar.playToServer(PacketLeverStateRequest.TYPE, PacketLeverStateRequest.STREAM_CODEC, PacketLeverStateRequest.HANDLER);
        registrar.playToServer(PacketRefreshGroupPoweredState.TYPE, PacketRefreshGroupPoweredState.STREAM_CODEC, PacketRefreshGroupPoweredState.HANDLER);
        registrar.playToClient(PacketLeverStateResponse.TYPE, PacketLeverStateResponse.STREAM_CODEC, PacketLeverStateResponse.HANDLER);
    }

    public static void sendToClient(ServerPlayer player, PacketLeverStateResponse packet) {
        if (registrar != null) {
            player.connection.send((CustomPacketPayload)packet);
        }
    }

    public static void sendToServer(PacketLeverStateRequest packet) {
        Objects.requireNonNull(Minecraft.getInstance().getConnection()).send((CustomPacketPayload)packet);
    }
}

