/*
 * Decompiled with CFR 0.152.
 */
package dev.igorilic.redstonemanager.screen.custom;

import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ColorPickerScreen
extends Screen {
    private final Consumer<Integer> onColorSelected;
    private float hue = 0.0f;
    private float saturation = 1.0f;
    private float brightness = 1.0f;
    private int selectedColor;
    private int hueX;
    private int hueY;
    private int hueWidth;
    private int hueHeight;
    private int sbX;
    private int sbY;
    private int sbSize;
    private boolean draggingHue = false;
    private boolean draggingSB = false;

    public ColorPickerScreen(Consumer<Integer> onColorSelected) {
        super((Component)Component.literal((String)"Color Picker"));
        this.onColorSelected = onColorSelected;
    }

    protected void init() {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        this.hueX = centerX - 75;
        this.hueY = centerY - 80;
        this.hueWidth = 150;
        this.hueHeight = 15;
        this.sbX = centerX - 75;
        this.sbY = centerY - 60;
        this.sbSize = 150;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Confirm"), btn -> {
            this.onColorSelected.accept(this.selectedColor);
            Minecraft.getInstance().setScreen(null);
        }).bounds(centerX - 40, this.sbY + this.sbSize + 10, 80, 20).build());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.inHueBar(mouseX, mouseY)) {
            this.draggingHue = true;
            this.updateHue(mouseX);
            return true;
        }
        if (this.inSBBox(mouseX, mouseY)) {
            this.draggingSB = true;
            this.updateSB(mouseX, mouseY);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void updateColor() {
        int rgb = Color.HSBtoRGB(this.hue, this.saturation, this.brightness);
        this.selectedColor = rgb & 0xFFFFFF;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.drawHueBar(guiGraphics);
        this.drawSaturationBrightnessSquare(guiGraphics);
        this.drawColorPreview(guiGraphics);
    }

    private void drawHueBar(GuiGraphics guiGraphics) {
        for (int x = 0; x < this.hueWidth; ++x) {
            float h = (float)x / (float)this.hueWidth;
            int color = Color.HSBtoRGB(h, 1.0f, 1.0f);
            guiGraphics.fill(this.hueX + x, this.hueY, this.hueX + x + 1, this.hueY + this.hueHeight, 0xFF000000 | color);
        }
        int hx = (int)(this.hue * (float)this.hueWidth);
        guiGraphics.fill(this.hueX + hx - 1, this.hueY - 2, this.hueX + hx + 2, this.hueY + this.hueHeight + 2, -1);
    }

    private void drawSaturationBrightnessSquare(GuiGraphics guiGraphics) {
        for (int y = 0; y < this.sbSize; ++y) {
            for (int x = 0; x < this.sbSize; ++x) {
                float s = (float)x / (float)this.sbSize;
                float b = 1.0f - (float)y / (float)this.sbSize;
                int color = Color.HSBtoRGB(this.hue, s, b);
                guiGraphics.fill(this.sbX + x, this.sbY + y, this.sbX + x + 1, this.sbY + y + 1, 0xFF000000 | color);
            }
        }
        int cx = (int)(this.saturation * (float)this.sbSize);
        int cy = (int)((1.0f - this.brightness) * (float)this.sbSize);
        int px = this.sbX + cx;
        int py = this.sbY + cy;
        guiGraphics.fill(px - 1, py - 5, px + 2, py + 6, -16777216);
        guiGraphics.fill(px - 5, py - 1, px + 6, py + 2, -16777216);
    }

    private void drawColorPreview(GuiGraphics guiGraphics) {
        int previewX = this.width / 2 + 80;
        int previewY = this.sbY;
        guiGraphics.fill(previewX, previewY, previewX + 40, previewY + 40, 0xFF000000 | this.selectedColor);
        guiGraphics.drawString(this.font, "#" + Integer.toHexString(this.selectedColor).toUpperCase(), previewX, previewY + 45, 0xFFFFFF);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingHue = false;
        this.draggingSB = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.draggingHue) {
            this.updateHue(mouseX);
            return true;
        }
        if (this.draggingSB) {
            this.updateSB(mouseX, mouseY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dx, dy);
    }

    private boolean inHueBar(double x, double y) {
        return x >= (double)this.hueX && x < (double)(this.hueX + this.hueWidth) && y >= (double)this.hueY && y < (double)(this.hueY + this.hueHeight);
    }

    private boolean inSBBox(double x, double y) {
        return x >= (double)this.sbX && x < (double)(this.sbX + this.sbSize) && y >= (double)this.sbY && y < (double)(this.sbY + this.sbSize);
    }

    private void updateHue(double x) {
        this.hue = (float)((x - (double)this.hueX) / (double)this.hueWidth);
        this.hue = Mth.clamp((float)this.hue, (float)0.0f, (float)1.0f);
        this.updateColor();
    }

    private void updateSB(double x, double y) {
        this.saturation = Mth.clamp((float)((float)((x - (double)this.sbX) / (double)this.sbSize)), (float)0.0f, (float)1.0f);
        this.brightness = Mth.clamp((float)(1.0f - (float)((y - (double)this.sbY) / (double)this.sbSize)), (float)0.0f, (float)1.0f);
        this.updateColor();
    }
}

