/*
 * Decompiled with CFR 0.152.
 */
package dev.igorilic.redstonemanager.screen.custom;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.igorilic.redstonemanager.block.entity.RedstoneManagerBlockEntity;
import dev.igorilic.redstonemanager.component.ModDataComponents;
import dev.igorilic.redstonemanager.item.custom.RedstoneLinkerItem;
import dev.igorilic.redstonemanager.network.PacketCreateGroup;
import dev.igorilic.redstonemanager.network.PacketDeleteGroup;
import dev.igorilic.redstonemanager.network.PacketMoveItemBetweenInventories;
import dev.igorilic.redstonemanager.network.PacketPlaySound;
import dev.igorilic.redstonemanager.network.PacketRefreshGroupPoweredState;
import dev.igorilic.redstonemanager.network.PacketRenameGroup;
import dev.igorilic.redstonemanager.network.PacketToggleAllLevers;
import dev.igorilic.redstonemanager.network.PacketToggleLever;
import dev.igorilic.redstonemanager.screen.custom.ConfirmActionScreen;
import dev.igorilic.redstonemanager.screen.custom.CreateEditGroupScreen;
import dev.igorilic.redstonemanager.screen.custom.ManagerMenu;
import dev.igorilic.redstonemanager.util.ClickAction;
import dev.igorilic.redstonemanager.util.IUpdatable;
import dev.igorilic.redstonemanager.util.LeverStateCache;
import dev.igorilic.redstonemanager.util.LinkerGroup;
import dev.igorilic.redstonemanager.util.MousePositionManagerUtil;
import dev.igorilic.redstonemanager.util.MouseUtil;
import dev.igorilic.redstonemanager.util.entries.DisplayEntry;
import dev.igorilic.redstonemanager.util.entries.HeaderEntry;
import dev.igorilic.redstonemanager.util.entries.ItemEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ManagerScreen
extends AbstractContainerScreen<ManagerMenu>
implements IUpdatable {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"redstonemanager", (String)"textures/gui/gui_no_slots_large.png");
    private static final ResourceLocation GUI_NO_SCROLL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"redstonemanager", (String)"textures/gui/gui_no_slots_no_scroll_large.png");
    private static final ResourceLocation GUI_SCROLL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"redstonemanager", (String)"textures/gui/gui_scroll.png");
    private static final ResourceLocation GUI_ROW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"redstonemanager", (String)"textures/gui/gui_row.png");
    private static final ResourceLocation GUI_TOGGLE_BUTTONS = ResourceLocation.fromNamespaceAndPath((String)"redstonemanager", (String)"textures/gui/gui_toggle_buttons.png");
    private static final ResourceLocation GUI_BUTTONS = ResourceLocation.fromNamespaceAndPath((String)"redstonemanager", (String)"textures/gui/gui_buttons.png");
    private static final int SCROLLBAR_WIDTH = 12;
    private static final int SCROLLBAR_X_OFFSET = 174;
    private static final int SCROLLBAR_Y_OFFSET = 18;
    private static final int COLUMNS = 9;
    private final RedstoneManagerBlockEntity blockEntity;
    private int scrollIndex = 0;
    public static int visibleRows = 7;
    private boolean isDraggingScrollbar = false;
    private int dragOffsetY = 0;
    private final List<DisplayEntry> flattenedEntries = new ArrayList<DisplayEntry>();
    private Map<String, LinkerGroup> items;
    private boolean isEditingGroup = false;
    private String oldGroupName = "";

    private void regenerateFlattenedEntries() {
        this.flattenedEntries.clear();
        this.items.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            this.flattenedEntries.add(new HeaderEntry((String)entry.getKey()));
            List<ItemStack> stacks = ((LinkerGroup)entry.getValue()).getItems();
            for (ItemStack stack : stacks) {
                this.flattenedEntries.add(new ItemEntry(stack, (String)entry.getKey()));
            }
            int remainder = stacks.size() % 9;
            boolean lastIsEmpty = !stacks.isEmpty() && stacks.getLast().isEmpty();
            int toAdd = 9;
            if (remainder != 0) {
                toAdd = 9 - remainder;
            }
            if (lastIsEmpty) {
                toAdd = 0;
            }
            for (int i = 0; i < toAdd; ++i) {
                this.flattenedEntries.add(new ItemEntry(ItemStack.EMPTY, (String)entry.getKey()));
            }
        });
    }

    public ManagerScreen(ManagerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        MousePositionManagerUtil.setLastKnownPosition();
        this.blockEntity = menu.blockEntity;
        this.items = this.blockEntity.getItems();
        this.imageHeight = 243;
        this.imageWidth = 193;
        this.inventoryLabelY = this.imageHeight - 93;
        this.titleLabelY -= 2;
        LeverStateCache.refreshAll();
        this.regenerateFlattenedEntries();
        assert (Minecraft.getInstance().player != null);
        Minecraft.getInstance().player.connection.send((CustomPacketPayload)new PacketRefreshGroupPoweredState(this.blockEntity.getBlockPos()));
    }

    protected void init() {
        super.init();
        this.clearWidgets();
    }

    public void onClose() {
        super.onClose();
    }

    protected void containerTick() {
        super.containerTick();
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int baseX = (this.width - this.imageWidth) / 2;
        int baseY = (this.height - this.imageHeight) / 2;
        if (this.canScroll()) {
            guiGraphics.blit(GUI_TEXTURE, baseX, baseY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
            this.drawScrollbar(guiGraphics);
        } else {
            this.scrollIndex = 0;
            guiGraphics.blit(GUI_NO_SCROLL_TEXTURE, baseX, baseY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderItems(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        int newButtonX = this.leftPos + this.imageWidth - 36;
        int newButtonY = this.topPos + 3;
        guiGraphics.blit(GUI_BUTTONS, newButtonX, newButtonY, 0.0f, 0.0f, 11, 11, 33, 11);
        if (mouseX >= newButtonX && mouseX < newButtonX + 11 && mouseY >= newButtonY && mouseY < newButtonY + 11) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"tooltip.redstonemanager.manager.create_group"), mouseX, mouseY);
        }
    }

    private void drawScrollbar(GuiGraphics guiGraphics) {
        int scrollbarX = this.leftPos + 174;
        int scrollbarY = this.topPos + 18;
        int handleHeight = 15;
        float maxScroll = this.getTotalRows() - visibleRows;
        float scrollFraction = (float)this.scrollIndex / (maxScroll * 9.0f);
        int handleY = Math.max(scrollbarY + (int)((float)(this.getScrollbarHeight() - handleHeight) * scrollFraction), scrollbarY);
        guiGraphics.blit(GUI_SCROLL_TEXTURE, scrollbarX, handleY, 168.0f, 0.0f, 12, 15, 12, 15);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renderItems(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int startX = this.leftPos + 7;
        int rowY = this.topPos + 19;
        int renderedRows = 0;
        int flattenedIndex = 0;
        int virtualRow = 0;
        while (flattenedIndex < this.flattenedEntries.size()) {
            DisplayEntry entry;
            block18: {
                DisplayEntry subEntry;
                int maxVisibleWidth;
                String groupName;
                block17: {
                    block16: {
                        entry = this.flattenedEntries.get(flattenedIndex);
                        if (virtualRow >= this.scrollIndex / 9) break block16;
                        if (entry instanceof HeaderEntry) {
                            ++virtualRow;
                            ++flattenedIndex;
                            continue;
                        }
                        if (!(entry instanceof ItemEntry)) continue;
                        break block17;
                    }
                    if (renderedRows >= visibleRows) {
                        return;
                    }
                    if (entry instanceof HeaderEntry) {
                        HeaderEntry headerEntry = (HeaderEntry)entry;
                        try {
                            String string;
                            groupName = string = headerEntry.groupName();
                            maxVisibleWidth = 65;
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                    }
                    break block18;
                }
                for (int itemCount = 0; flattenedIndex < this.flattenedEntries.size() && itemCount < 9 && (subEntry = this.flattenedEntries.get(flattenedIndex)) instanceof ItemEntry; ++itemCount, ++flattenedIndex) {
                }
                ++virtualRow;
                continue;
                int fullTextWidth = this.font.width(groupName);
                if (fullTextWidth > maxVisibleWidth) {
                    int loopGap = 24;
                    int loopWidth = fullTextWidth + loopGap;
                    long time = System.currentTimeMillis();
                    int pixelOffset = (int)(time / 20L % (long)loopWidth);
                    int baseX = startX + 3;
                    int baseY = rowY + 5;
                    double scale = Minecraft.getInstance().getWindow().getGuiScale();
                    int scissorX = (int)((double)baseX * scale);
                    Objects.requireNonNull(this.font);
                    int scissorY = (int)((double)(this.height - baseY - 9) * scale);
                    int scissorW = (int)((double)maxVisibleWidth * scale);
                    Objects.requireNonNull(this.font);
                    int scissorH = (int)(9.0 * scale);
                    RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
                    String visible1 = ManagerScreen.getVisibleSubstring(this.font, groupName, pixelOffset, maxVisibleWidth);
                    guiGraphics.drawString(this.font, visible1, baseX, baseY, 8454118, false);
                    int secondX = baseX + fullTextWidth + loopGap - pixelOffset;
                    if (secondX < baseX + maxVisibleWidth) {
                        String visible2 = ManagerScreen.getVisibleSubstring(this.font, groupName, 0, maxVisibleWidth);
                        guiGraphics.drawString(this.font, visible2, secondX, baseY, 8454118, false);
                    }
                    RenderSystem.disableScissor();
                } else {
                    guiGraphics.drawString(this.font, groupName, startX + 3, rowY + 5, 8454118, false);
                }
                this.renderToggleButtons(guiGraphics, startX + 3, rowY + 4, groupName, mouseX, mouseY, partialTick);
                this.renderGroupActionButtons(guiGraphics, startX + 3, rowY + 3, groupName, mouseX, mouseY);
                rowY += 18;
                ++renderedRows;
                ++flattenedIndex;
                ++virtualRow;
                continue;
            }
            if (entry instanceof ItemEntry) {
                DisplayEntry subEntry;
                int rowStartIndex = flattenedIndex;
                for (int itemCount = 0; itemCount < 9 && flattenedIndex < this.flattenedEntries.size() && (subEntry = this.flattenedEntries.get(flattenedIndex)) instanceof ItemEntry; ++itemCount, ++flattenedIndex) {
                    int x;
                    ItemStack stack;
                    block15: {
                        ItemEntry itemEntry = (ItemEntry)subEntry;
                        {
                            Object pixelOffset;
                            stack = pixelOffset = itemEntry.stack();
                            Object group = pixelOffset = itemEntry.group();
                            int col = itemCount;
                            x = startX + col * 18;
                            if (col != 0) break block15;
                        }
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_ROW_TEXTURE);
                        guiGraphics.blit(GUI_ROW_TEXTURE, startX, rowY - 2, 0.0f, 0.0f, 162, 18, 162, 18);
                    }
                    if (!(stack.getItem() instanceof RedstoneLinkerItem)) continue;
                    guiGraphics.renderItem(stack, x + 1, rowY - 1);
                    this.renderLinkerItemBackground(stack, guiGraphics, x + 1, rowY - 1);
                    if (mouseX < x || mouseX >= x + 16 || mouseY < rowY - 1 || mouseY >= rowY - 1 + 16) continue;
                    BlockPos leverPos = (BlockPos)stack.get(ModDataComponents.COORDINATES);
                    if (leverPos != null) {
                        LeverStateCache.requestIfNeeded(leverPos);
                        LeverStateCache.get(leverPos).ifPresentOrElse(cached -> {
                            MutableComponent extraLabel = !cached.found() ? Component.translatable((String)"errors.redstonemanager.manager.invalid_link") : (cached.powered() ? Component.translatable((String)"tooltip.redstonemanager.manager.turn_off") : Component.translatable((String)"tooltip.redstonemanager.manager.turn_on"));
                            guiGraphics.renderTooltip(this.font, (Component)extraLabel, mouseX, mouseY - 12);
                        }, () -> {
                            MutableComponent extraLabel = Component.translatable((String)"tooltip.redstonemanager.manager.loading");
                            guiGraphics.renderTooltip(this.font, (Component)extraLabel, mouseX, mouseY - 12);
                        });
                    }
                    guiGraphics.renderTooltip(this.font, stack, mouseX, mouseY);
                }
                if (flattenedIndex > rowStartIndex) {
                    rowY += 18;
                    ++renderedRows;
                    ++virtualRow;
                    continue;
                }
                ++flattenedIndex;
                continue;
            }
            ++flattenedIndex;
        }
    }

    private static String getVisibleSubstring(Font font, String text, int pixelOffset, int maxWidth) {
        int start;
        if (pixelOffset <= 0) {
            return font.plainSubstrByWidth(text, maxWidth);
        }
        int skipped = 0;
        for (start = 0; start < text.length() && skipped < pixelOffset; skipped += font.width(String.valueOf(text.charAt(start))), ++start) {
        }
        String trimmed = text.substring(start);
        return font.plainSubstrByWidth(trimmed, maxWidth);
    }

    private void renderToggleButtons(@NotNull GuiGraphics guiGraphics, int startX, int startY, String groupName, int mouseX, int mouseY, float partialTick) {
        LinkerGroup linker = this.items.get(groupName);
        boolean allOn = linker.isPowered();
        if (allOn) {
            guiGraphics.blit(GUI_TOGGLE_BUTTONS, startX + 136, startY - 1, 0.0f, 0.0f, 20, 11, 41, 11);
        } else {
            guiGraphics.blit(GUI_TOGGLE_BUTTONS, startX + 136, startY - 1, 19.5f, 0.0f, 21, 11, 41, 11);
        }
        int toggleX = startX + 139;
        int toggleY = startY + 2;
        if (mouseX >= toggleX && mouseX < toggleX + 20 && mouseY >= toggleY && mouseY < toggleY + 11) {
            MutableComponent toggleTooltip = this.items.get(groupName).isPowered() ? Component.translatable((String)"tooltip.redstonemanager.manager.toggle_group_off", (Object[])new Object[]{groupName}) : Component.translatable((String)"tooltip.redstonemanager.manager.toggle_group_on", (Object[])new Object[]{groupName});
            guiGraphics.renderTooltip(this.font, (Component)toggleTooltip, mouseX, mouseY);
        }
    }

    private void renderGroupActionButtons(@NotNull GuiGraphics guiGraphics, int startX, int rowY, String groupName, int mouseX, int mouseY) {
        guiGraphics.blit(GUI_BUTTONS, startX + 70, rowY, 11.0f, 0.0f, 11, 11, 33, 11);
        if (mouseX >= startX + 70 && mouseX < startX + 81 && mouseY >= rowY && mouseY < rowY + 11) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"tooltip.redstonemanager.manager.rename_group", (Object[])new Object[]{groupName}), startX + 70, rowY + 2);
        }
        guiGraphics.blit(GUI_BUTTONS, startX + 70 + 11 + 4, rowY, 22.0f, 0.0f, 11, 11, 33, 11);
        if (mouseX >= startX + 70 + 11 + 4 && mouseX < startX + 70 + 11 + 4 + 11 && mouseY >= rowY && mouseY < rowY + 11) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"tooltip.redstonemanager.manager.delete_group", (Object[])new Object[]{groupName}), startX + 70, rowY + 2);
        }
    }

    private void renderLinkerItemBackground(ItemStack linkerItem, GuiGraphics guiGraphics, int slotX, int slotY) {
        int color;
        BlockPos leverPos = (BlockPos)linkerItem.get(ModDataComponents.COORDINATES);
        int slotSize = 16;
        if (leverPos != null) {
            LeverStateCache.requestIfNeeded(leverPos);
            Optional<LeverStateCache.CachedLever> cached = LeverStateCache.get(leverPos);
            color = cached.map(cachedLever -> cachedLever.powered() ? 0x7700FF00 : 0x77FF0000).orElse(0x77444444);
        } else {
            color = 0x77000000;
        }
        guiGraphics.fill(slotX, slotY, slotX + slotSize, slotY + slotSize, color);
    }

    private int getScrollbarHeight() {
        return 54;
    }

    private int getTotalRows() {
        int totalHeaders = (int)this.flattenedEntries.stream().filter(e -> e instanceof HeaderEntry).count();
        int totalItems = (int)this.flattenedEntries.stream().filter(e -> e instanceof ItemEntry).count();
        int itemRows = (totalItems + 9 - 1) / 9;
        return totalHeaders + itemRows;
    }

    private boolean canScroll() {
        return this.getTotalRows() > visibleRows;
    }

    private boolean isShiftDown() {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)344);
    }

    private void handleCreateEditGroup(String newName) {
        if (newName.isEmpty()) {
            return;
        }
        assert (Minecraft.getInstance().player != null);
        if (this.isEditingGroup && !newName.equals(this.oldGroupName)) {
            Minecraft.getInstance().player.connection.send((CustomPacketPayload)new PacketRenameGroup(this.blockEntity.getBlockPos(), this.oldGroupName, newName));
        } else {
            Minecraft.getInstance().player.connection.send((CustomPacketPayload)new PacketCreateGroup(this.blockEntity.getBlockPos(), newName));
        }
        this.isEditingGroup = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        MousePositionManagerUtil.getLastKnownPosition();
        int newButtonX = this.leftPos + this.imageWidth - 36;
        int newButtonY = this.topPos + 4;
        if (mouseX >= (double)newButtonX && mouseX < (double)(newButtonX + 11) && mouseY >= (double)newButtonY && mouseY < (double)(newButtonY + 11)) {
            assert (Minecraft.getInstance().player != null);
            Minecraft.getInstance().player.connection.send((CustomPacketPayload)new PacketPlaySound(this.blockEntity.getBlockPos(), (Holder<SoundEvent>)Holder.direct((Object)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value())), 0.3f, 1.0f));
            Minecraft.getInstance().setScreen((Screen)new CreateEditGroupScreen(this::handleCreateEditGroup, "", Minecraft.getInstance().screen));
            return true;
        }
        int startX = this.leftPos + 9;
        int startY = this.topPos + 20;
        int slotSize = 18;
        ItemStack carried = ((ManagerMenu)this.menu).getCarried();
        int rowY = startY;
        int flattenedIndex = 0;
        int virtualRow = 0;
        int renderedRows = 0;
        int currentSlotIndex = 0;
        while (flattenedIndex < this.flattenedEntries.size()) {
            block26: {
                DisplayEntry subEntry;
                DisplayEntry entry;
                block25: {
                    int rowX;
                    String groupName;
                    block24: {
                        String string;
                        block23: {
                            entry = this.flattenedEntries.get(flattenedIndex);
                            if (virtualRow >= this.scrollIndex / 9) break block23;
                            if (entry instanceof HeaderEntry) {
                                ++virtualRow;
                                ++flattenedIndex;
                                continue;
                            }
                            if (!(entry instanceof ItemEntry)) continue;
                            break block24;
                        }
                        if (renderedRows >= visibleRows) break;
                        if (!(entry instanceof HeaderEntry)) break block25;
                        HeaderEntry itemCount = (HeaderEntry)entry;
                        groupName = string = itemCount.groupName();
                        rowX = startX + 137;
                    }
                    for (int itemCount = 0; itemCount < 9 && flattenedIndex < this.flattenedEntries.size() && this.flattenedEntries.get(flattenedIndex) instanceof ItemEntry; ++itemCount, ++flattenedIndex) {
                    }
                    ++virtualRow;
                    continue;
                    if (mouseX >= (double)rowX && mouseX < (double)(rowX + 20) && mouseY >= (double)rowY && mouseY < (double)(rowY + 11)) {
                        assert (Minecraft.getInstance().player != null);
                        Minecraft.getInstance().player.connection.send((CustomPacketPayload)new PacketToggleAllLevers(this.blockEntity.getBlockPos(), groupName));
                        return true;
                    }
                    if (mouseX >= (double)(startX + 70) && mouseX < (double)(startX + 81) && mouseY >= (double)(rowY + 2) && mouseY < (double)(rowY + 13)) {
                        this.isEditingGroup = true;
                        this.oldGroupName = groupName;
                        assert (Minecraft.getInstance().player != null);
                        Minecraft.getInstance().player.connection.send((CustomPacketPayload)new PacketPlaySound(this.blockEntity.getBlockPos(), (Holder<SoundEvent>)Holder.direct((Object)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value())), 0.3f, 1.0f));
                        Minecraft.getInstance().setScreen((Screen)new CreateEditGroupScreen(this::handleCreateEditGroup, groupName, Minecraft.getInstance().screen));
                        return true;
                    }
                    if (mouseX >= (double)(startX + 70 + 11 + 4) && mouseX < (double)(startX + 70 + 11 + 4 + 11) && mouseY >= (double)(rowY + 2) && mouseY < (double)(rowY + 13)) {
                        assert (Minecraft.getInstance().player != null);
                        MutableComponent text = Component.translatable((String)"confirm.redstonemanager.manager.delete_group", (Object[])new Object[]{groupName}).plainCopy().withStyle(ChatFormatting.RED);
                        MutableComponent desc = Component.translatable((String)"confirm.redstonemanager.manager.delete_group_desc").plainCopy().withStyle(ChatFormatting.AQUA);
                        MutableComponent action = Component.translatable((String)"label.redstonemanager.manager.confirm").plainCopy().withStyle(ChatFormatting.RED);
                        Minecraft.getInstance().setScreen((Screen)new ConfirmActionScreen((Component)text, (Component)desc, (Component)action, confirmed -> {
                            if (confirmed.booleanValue()) {
                                Minecraft.getInstance().player.connection.send((CustomPacketPayload)new PacketDeleteGroup(this.blockEntity.getBlockPos(), groupName));
                            }
                        }, Minecraft.getInstance().screen));
                        return true;
                    }
                    rowY += 18;
                    ++flattenedIndex;
                    ++virtualRow;
                    ++renderedRows;
                    continue;
                }
                if (!(entry instanceof ItemEntry)) break block26;
                int rowStartIndex = flattenedIndex;
                for (int itemCount = 0; itemCount < 9 && flattenedIndex < this.flattenedEntries.size() && (subEntry = this.flattenedEntries.get(flattenedIndex)) instanceof ItemEntry; ++itemCount, ++flattenedIndex, ++currentSlotIndex) {
                    int x;
                    Object group;
                    ItemStack stack;
                    ItemEntry itemEntry = (ItemEntry)subEntry;
                    try {
                        Object object;
                        stack = object = itemEntry.stack();
                        group = object = itemEntry.group();
                        x = startX + itemCount * slotSize;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 16)) || !(mouseY >= (double)(rowY - 2)) || !(mouseY < (double)(rowY - 2 + 16))) continue;
                    LocalPlayer player = Minecraft.getInstance().player;
                    if (!stack.isEmpty()) {
                        int clickType;
                        if (button == 1) {
                            assert (player != null);
                            player.connection.send((CustomPacketPayload)new PacketToggleLever(this.blockEntity.getBlockPos(), stack, (String)group));
                            return true;
                        }
                        if (button != 0) return true;
                        assert (player != null);
                        int n = clickType = carried.isEmpty() ? ClickAction.PICKUP.ordinal() : ClickAction.SWAP.ordinal();
                        if (this.isShiftDown()) {
                            clickType = ClickAction.QUICK_MOVE.ordinal();
                        }
                        player.connection.send((CustomPacketPayload)new PacketMoveItemBetweenInventories(stack, clickType, 0, this.blockEntity.getBlockPos(), (String)group));
                        return true;
                    }
                    if (carried.isEmpty()) return true;
                    assert (player != null);
                    CompoundTag extraData = new CompoundTag();
                    extraData.putInt("index", currentSlotIndex);
                    extraData.putInt("row", virtualRow);
                    player.connection.send((CustomPacketPayload)new PacketMoveItemBetweenInventories(ItemStack.EMPTY, extraData, ClickAction.PUT_INTO_MANAGER.ordinal(), 0, this.blockEntity.getBlockPos(), (String)group));
                    return true;
                }
                if (flattenedIndex > rowStartIndex) {
                    rowY += 18;
                    ++renderedRows;
                    ++virtualRow;
                    currentSlotIndex = 0;
                    continue;
                }
                ++flattenedIndex;
                continue;
            }
            ++flattenedIndex;
        }
        int scrollbarX = this.leftPos + 174 + 1;
        int scrollbarY = this.topPos + 18;
        int handleHeight = 15;
        float maxScrollRows = Math.max(0, this.getTotalRows() - visibleRows);
        if (!(maxScrollRows > 0.0f)) return super.mouseClicked(mouseX, mouseY, button);
        float scrollFraction = (float)(this.scrollIndex / 9) / maxScrollRows;
        int handleY = Math.max(scrollbarY + (int)((float)(this.getScrollbarHeight() - handleHeight) * scrollFraction), scrollbarY + 1);
        if (MouseUtil.isMouseOver(mouseX, mouseY, scrollbarX, handleY, 12, handleHeight)) {
            this.isDraggingScrollbar = true;
            this.dragOffsetY = (int)mouseY - handleY;
            return true;
        }
        this.isDraggingScrollbar = false;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingScrollbar) {
            int scrollbarY = this.topPos + 18;
            int handleHeight = 15;
            int maxScroll = Math.max(0, (this.getTotalRows() - visibleRows) * 9);
            int relativeY = (int)mouseY - scrollbarY - this.dragOffsetY;
            float percent = Mth.clamp((float)((float)relativeY / (float)(this.getScrollbarHeight() - handleHeight)), (float)0.0f, (float)1.0f);
            int rawIndex = (int)(percent * (float)maxScroll);
            this.scrollIndex = Mth.clamp((int)(rawIndex / 9 * 9), (int)0, (int)maxScroll);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.canScroll()) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        int totalRows = this.getTotalRows();
        int maxScrollRows = totalRows - visibleRows;
        int newRow = this.scrollIndex / 9 - (int)Math.signum(scrollY);
        newRow = Mth.clamp((int)newRow, (int)0, (int)maxScrollRows);
        this.scrollIndex = newRow * 9;
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void update() {
        this.items = this.blockEntity.getItems();
        this.regenerateFlattenedEntries();
    }
}

