/*
 * Decompiled with CFR 0.152.
 */
package dev.igorilic.redstonemanager.network;

import dev.igorilic.redstonemanager.network.PacketHandler;
import dev.igorilic.redstonemanager.network.PacketLeverStateResponse;
import dev.igorilic.redstonemanager.util.LinkerGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import org.jetbrains.annotations.NotNull;

public record PacketLeverStateRequest(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketLeverStateRequest> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"redstonemanager", (String)"lever_state_request"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketLeverStateRequest> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketLeverStateRequest::pos, PacketLeverStateRequest::new);
    public static final IPayloadHandler<PacketLeverStateRequest> HANDLER = (payload, context) -> {
        Player patt0$temp = context.player();
        if (patt0$temp instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ServerLevel level = player.serverLevel();
            BlockState state = level.getBlockState(payload.pos);
            boolean found = LinkerGroup.canLink(state);
            boolean powered = found && (Boolean)state.getValue((Property)LeverBlock.POWERED) != false;
            PacketHandler.sendToClient(player, new PacketLeverStateResponse(payload.pos, found, powered));
        }
    };

    @NotNull
    public CustomPacketPayload.Type<PacketLeverStateRequest> type() {
        return TYPE;
    }
}

