/*
 * Decompiled with CFR 0.152.
 */
package xyz.quazaros.data.meta;

import java.util.ArrayList;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;
import xyz.quazaros.data.items.item;
import xyz.quazaros.data.main.file;
import xyz.quazaros.data.meta.enchantments;
import xyz.quazaros.data.meta.potions;
import xyz.quazaros.main;

public class metaList {
    file File;
    public ArrayList<item> items;
    public ArrayList<item> mobs;
    public ArrayList<enchantments> enchantment_list;
    public ArrayList<ArrayList<enchantments>> main_enchantment_list;
    public ArrayList<potions> potion_list;
    ArrayList<String> items_init;
    ArrayList<String> mobs_init;

    public metaList(ArrayList<String> items_init_p, ArrayList<String> mobs_init_p) {
        this.File = main.getPlugin().file;
        this.items = new ArrayList();
        this.mobs = new ArrayList();
        this.enchantment_list = new ArrayList();
        this.main_enchantment_list = new ArrayList();
        this.potion_list = new ArrayList();
        this.items_init = items_init_p;
        this.mobs_init = mobs_init_p;
        this.initialize_enchantedBooks();
        this.initialize_potions();
        this.initialize_items();
        this.initialize_mobs();
    }

    private void initialize_items() {
        for (String s : this.items_init) {
            this.items.add(new item(s));
        }
        this.null_remove();
        this.metaList_initialize();
    }

    private void initialize_mobs() {
        for (String s : this.mobs_init) {
            this.mobs.add(new item(s + "_spawn_egg"));
        }
        this.null_remove_mobs();
        this.rename_mobs();
    }

    private void initialize_enchantedBooks() {
        for (Enchantment e : Enchantment.values()) {
            this.set_enchants(e.getKey().getKey(), e.getMaxLevel());
        }
    }

    private void initialize_potions() {
        for (PotionType p : PotionType.values()) {
            this.potion_list.add(new potions(p.name().toLowerCase()));
        }
        this.null_remove_potions();
        for (potions p : this.potion_list) {
            p.name = this.change_potion_names(p.name);
        }
    }

    private String change_potion_names(String name) {
        if (name.equalsIgnoreCase("jump")) {
            name = "leaping";
        }
        if (name.equalsIgnoreCase("instant_heal")) {
            name = "healing";
        }
        if (name.equalsIgnoreCase("instant_damage")) {
            name = "harming";
        }
        if (name.equalsIgnoreCase("regen")) {
            name = "regeneration";
        }
        if (name.equalsIgnoreCase("speed")) {
            name = "swiftness";
        }
        return name;
    }

    private void set_enchants(String enchant, int lvl) {
        for (Enchantment e : Enchantment.values()) {
            String key = e.getKey().getKey();
            if (!enchant.equalsIgnoreCase(key)) continue;
            if (lvl == 1) {
                this.enchantment_list.add(new enchantments(enchant, e, 1));
                continue;
            }
            for (int i = 1; i <= lvl; ++i) {
                this.enchantment_list.add(new enchantments(enchant + "_" + i, e, i));
            }
            this.enchantment_list.add(new enchantments(enchant, e, -1));
        }
    }

    private void metaList_initialize() {
        item temp;
        for (enchantments i : this.enchantment_list) {
            temp = new item("enchanted_book");
            temp.set_name(i.name);
            EnchantmentStorageMeta book_meta = (EnchantmentStorageMeta)temp.item_meta;
            book_meta.addStoredEnchant(i.enchant, i.level, true);
            temp.item_stack.setItemMeta((ItemMeta)book_meta);
            temp.item_meta = book_meta;
            this.items.add(temp);
        }
        for (potions i : this.potion_list) {
            temp = new item("potion");
            temp.set_name("potion_of_" + i.name);
            PotionMeta potion_meta = (PotionMeta)temp.item_meta;
            main.getPlugin().version.setPotionMeta(potion_meta, i.effect.get(0));
            temp.item_stack.setItemMeta((ItemMeta)potion_meta);
            temp.item_meta = potion_meta;
            this.items.add(temp);
            temp = new item("splash_potion");
            temp.set_name("splash_potion_of_" + i.name);
            potion_meta = (PotionMeta)temp.item_meta;
            main.getPlugin().version.setPotionMeta(potion_meta, i.effect.get(0));
            temp.item_stack.setItemMeta((ItemMeta)potion_meta);
            temp.item_meta = potion_meta;
            this.items.add(temp);
            temp = new item("lingering_potion");
            temp.set_name("lingering_potion_of_" + i.name);
            potion_meta = (PotionMeta)temp.item_meta;
            main.getPlugin().version.setPotionMeta(potion_meta, i.effect.get(0));
            temp.item_stack.setItemMeta((ItemMeta)potion_meta);
            temp.item_meta = potion_meta;
            this.items.add(temp);
            temp = new item("tipped_arrow");
            temp.set_name("tipped_arrow_of_" + i.name);
            potion_meta = (PotionMeta)temp.item_meta;
            main.getPlugin().version.setPotionMeta(potion_meta, i.effect.get(0));
            temp.item_stack.setItemMeta((ItemMeta)potion_meta);
            temp.item_meta = potion_meta;
            this.items.add(temp);
        }
        main.getPlugin().version.initializeHorns(this.items);
    }

    private void null_remove() {
        int i = 0;
        while (i < this.items.size()) {
            if (this.items.get((int)i).item_type.isAir()) {
                this.items.remove(i);
                continue;
            }
            ++i;
        }
    }

    private void null_remove_mobs() {
        int i = 0;
        while (i < this.mobs.size()) {
            if (this.mobs.get((int)i).item_type.isAir()) {
                this.mobs.remove(i);
                continue;
            }
            ++i;
        }
    }

    private void null_remove_potions() {
        int i = 0;
        while (i < this.potion_list.size()) {
            if (this.potion_list.get((int)i).effect.size() == 0) {
                this.potion_list.remove(i);
                continue;
            }
            ++i;
        }
    }

    private void rename_mobs() {
        for (int i = 0; i < this.mobs.size(); ++i) {
            this.mobs.get(i).set_name(this.mobs.get((int)i).item_name.substring(0, this.mobs.get((int)i).item_name.length() - 10));
        }
    }
}

