/*
 * Decompiled with CFR 0.152.
 */
package xyz.quazaros.structures.items;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;
import xyz.quazaros.main;
import xyz.quazaros.structures.items.item;
import xyz.quazaros.util.files.config.lang;
import xyz.quazaros.util.meta.itemMeta.enchantments;
import xyz.quazaros.util.meta.itemMeta.potions;
import xyz.quazaros.util.meta.metaList;

public class itemList {
    public ArrayList<item> items;
    public ArrayList<Integer> indexes;
    public List<String> item_names;
    public boolean mob;
    public boolean personal;
    public boolean completed;
    private int enchantedBook_index;
    private int potion_index;
    private int splashPotion_index;
    private int lingeringPotion_index;
    private int tippedArrow_index;
    private int goatHorn_index;
    metaList meta_list;

    public itemList() {
        this.initialize();
    }

    public itemList(boolean mob_p, ArrayList<String> str_list) {
        this.mob = mob_p;
        this.personal = false;
        this.completed = false;
        this.initialize();
        if (!this.mob) {
            this.total();
        } else {
            this.total_mobs();
        }
        this.setIndexes(str_list);
    }

    public itemList(itemList item_list, boolean personal_p) {
        this.mob = item_list.mob;
        this.personal = personal_p;
        this.completed = false;
        this.items = new ArrayList();
        for (item i : item_list.items) {
            this.items.add(new item(i));
        }
        this.indexes = new ArrayList<Integer>(item_list.indexes);
        this.item_names = new ArrayList<String>(item_list.item_names);
        this.meta_list = main.getPlugin().meta_list;
        this.enchantedBook_index = item_list.enchantedBook_index;
        this.potion_index = item_list.potion_index;
        this.splashPotion_index = item_list.splashPotion_index;
        this.lingeringPotion_index = item_list.lingeringPotion_index;
        this.tippedArrow_index = item_list.tippedArrow_index;
        this.goatHorn_index = item_list.goatHorn_index;
    }

    private void initialize() {
        this.items = new ArrayList();
        this.indexes = new ArrayList();
        this.item_names = new ArrayList<String>();
        this.meta_list = main.getPlugin().meta_list;
    }

    public void total() {
        for (item i : this.meta_list.items) {
            this.items.add(i);
        }
        this.specialIndex_initialize();
        this.update_item_names();
    }

    public void total_mobs() {
        for (item i : this.meta_list.mobs) {
            this.items.add(i);
        }
        this.update_item_names();
    }

    public void setIndexes(ArrayList<String> str_list) {
        this.indexes = this.string_to_index(str_list);
    }

    private ArrayList<Integer> string_to_index(ArrayList<String> str_list) {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        block0: for (String s : str_list) {
            for (int i = 0; i < this.items.size(); ++i) {
                if (!this.items.get((int)i).item_name.equalsIgnoreCase(s.replace("\n", ""))) continue;
                temp.add(i);
                continue block0;
            }
        }
        return temp;
    }

    public ArrayList<item> get_sub_items() {
        ArrayList<item> temp = new ArrayList<item>();
        for (int i = 0; i < this.indexes.size(); ++i) {
            temp.add(this.items.get(this.indexes.get(i)));
        }
        return temp;
    }

    private void specialIndex_initialize() {
        this.enchantedBook_index = -1;
        this.potion_index = -1;
        this.splashPotion_index = -1;
        this.lingeringPotion_index = -1;
        this.tippedArrow_index = -1;
        this.goatHorn_index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get((int)i).item_name.equals("enchanted_book")) {
                this.enchantedBook_index = i;
                continue;
            }
            if (this.items.get((int)i).item_name.equals("potion")) {
                this.potion_index = i;
                continue;
            }
            if (this.items.get((int)i).item_name.equals("splash_potion")) {
                this.splashPotion_index = i;
                continue;
            }
            if (this.items.get((int)i).item_name.equals("lingering_potion")) {
                this.lingeringPotion_index = i;
                continue;
            }
            if (this.items.get((int)i).item_name.equals("tipped_arrow")) {
                this.tippedArrow_index = i;
                continue;
            }
            if (!this.items.get((int)i).item_name.equals("goat_horn")) continue;
            this.goatHorn_index = i;
        }
    }

    private ArrayList<Integer> get_index(ItemStack current_item) {
        ArrayList<Integer> Index_List = new ArrayList<Integer>();
        if (current_item.getType().equals((Object)Material.ENCHANTED_BOOK)) {
            Index_List.add(this.enchantedBook_index);
        } else if (current_item.getType().equals((Object)Material.POTION)) {
            if (!this.items.get((int)this.potion_index).isFound) {
                Index_List.add(this.potion_index);
            }
        } else if (current_item.getType().equals((Object)Material.SPLASH_POTION)) {
            if (!this.items.get((int)this.splashPotion_index).isFound) {
                Index_List.add(this.splashPotion_index);
            }
        } else if (current_item.getType().equals((Object)Material.LINGERING_POTION)) {
            if (!this.items.get((int)this.lingeringPotion_index).isFound) {
                Index_List.add(this.lingeringPotion_index);
            }
        } else if (current_item.getType().equals((Object)Material.TIPPED_ARROW)) {
            if (!this.items.get((int)this.tippedArrow_index).isFound) {
                Index_List.add(this.tippedArrow_index);
            }
        } else if (main.getPlugin().version.checkItem(current_item.getType(), "goat_horn") && !this.items.get((int)this.goatHorn_index).isFound) {
            Index_List.add(this.goatHorn_index);
        }
        if (current_item.getType().equals((Object)Material.AIR)) {
            Index_List.add(-1);
        } else if (current_item.getType().equals((Object)Material.ENCHANTED_BOOK)) {
            EnchantmentStorageMeta currentItemMeta = (EnchantmentStorageMeta)current_item.getItemMeta();
            ItemStack bookItem = new ItemStack(Material.ENCHANTED_BOOK);
            for (int i = 0; i < this.items.size(); ++i) {
                if (currentItemMeta.getStoredEnchants().size() != 1) continue;
                for (enchantments e : this.meta_list.enchantment_list) {
                    EnchantmentStorageMeta tempMeta = (EnchantmentStorageMeta)bookItem.getItemMeta();
                    tempMeta.addStoredEnchant(e.enchant, e.level, true);
                    if (!tempMeta.getStoredEnchants().equals(currentItemMeta.getStoredEnchants()) || !e.name.equals(this.items.get((int)i).item_name)) continue;
                    for (enchantments general_e : this.meta_list.enchantment_list) {
                        if (!general_e.name.equals(e.name.substring(0, e.name.length() - 2))) continue;
                        Index_List.add(this.get_item_index(general_e.name));
                    }
                    Index_List.add(i);
                }
            }
        } else if (this.check_potion(current_item.getType())) {
            PotionMeta currentItemMeta = (PotionMeta)current_item.getItemMeta();
            if (current_item.getType().equals((Object)Material.POTION)) {
                Index_List.add(this.potion_index);
            } else if (current_item.getType().equals((Object)Material.SPLASH_POTION)) {
                Index_List.add(this.splashPotion_index);
            } else if (current_item.getType().equals((Object)Material.LINGERING_POTION)) {
                Index_List.add(this.lingeringPotion_index);
            } else if (current_item.getType().equals((Object)Material.TIPPED_ARROW)) {
                Index_List.add(this.tippedArrow_index);
            }
            for (int i = 0; i < this.items.size(); ++i) {
                for (potions e : this.meta_list.potion_list) {
                    for (PotionType effect : e.effect) {
                        if (!main.getPlugin().version.getPotionMeta(currentItemMeta).equals((Object)effect) || !this.items.get((int)i).item_name.contains(e.name) || !this.items.get((int)i).item_type.equals((Object)current_item.getType())) continue;
                        Index_List.add(i);
                    }
                }
            }
        } else if (main.getPlugin().version.checkItem(current_item.getType(), "goat_horn")) {
            Index_List.add(this.goatHorn_index);
            main.getPlugin().version.getHorn(current_item, this.items, Index_List);
        } else {
            for (int i = 0; i < this.items.size(); ++i) {
                if (!this.items.get((int)i).item_type.equals((Object)current_item.getType())) continue;
                Index_List.add(i);
            }
        }
        return Index_List;
    }

    public String check_items(ItemStack current_item, String p, boolean non_specific) {
        ArrayList<Integer> Index_List = this.get_index(current_item);
        if (Index_List.size() == 0) {
            return main.getPlugin().lang.colorBad + main.getPlugin().lang.noItemsFound;
        }
        if (Index_List.get(0) == -1) {
            return main.getPlugin().lang.colorBad + main.getPlugin().lang.enterItem;
        }
        String temp = "";
        boolean item_found = false;
        for (int i : Index_List) {
            if (this.items.get((int)i).isFound || non_specific && !this.is_in_indexes(i)) continue;
            item_found = true;
        }
        if (!item_found) {
            return this.generate_string(Index_List.get(Index_List.size() - 1));
        }
        for (int i : Index_List) {
            if (!this.is_in_indexes(i) || this.items.get((int)i).isFound) continue;
            temp = this.generate_string(i);
        }
        if (temp.equals("")) {
            for (int i : Index_List) {
                if (this.items.get((int)i).isFound) continue;
                temp = this.generate_string(i);
            }
        }
        if (item_found) {
            for (int i : Index_List) {
                if (this.items.get((int)i).isFound) continue;
                if (!this.personal) {
                    this.items.get(i).submit(p, this.date());
                    continue;
                }
                this.items.get(i).submit(this.date());
            }
        }
        return temp;
    }

    public String generate_string(int temp) {
        lang Lang = main.getPlugin().lang;
        if (!this.items.get((int)temp).isFound) {
            if (this.is_in_indexes(temp)) {
                return Lang.colorGood + this.items.get((int)temp).item_display_name + " " + Lang.itemSubmitted;
            }
            return Lang.colorGood + Lang.itemSubNotInList;
        }
        if (this.personal) {
            return Lang.colorBad + Lang.alreadyFound;
        }
        return Lang.colorBad + Lang.alreadyFoundBy + " " + this.items.get((int)temp).item_founder;
    }

    public int get_item_index(String item_name) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get((int)i).item_name.equalsIgnoreCase(item_name)) continue;
            return i;
        }
        return -1;
    }

    public item get_item(String item_name) {
        for (item i : this.items) {
            if (!item_name.equals(i.item_name)) continue;
            return i;
        }
        return null;
    }

    public boolean is_in_indexes(int index) {
        for (int i : this.indexes) {
            if (i != index) continue;
            return true;
        }
        return false;
    }

    public boolean item_exists(String item_name) {
        for (item i : this.items) {
            if (!i.item_name.equalsIgnoreCase(item_name)) continue;
            return true;
        }
        return false;
    }

    public int get_progress() {
        int cnt = 0;
        for (int i : this.indexes) {
            if (!this.items.get((int)i).isFound) continue;
            ++cnt;
        }
        return cnt;
    }

    public String progPer() {
        String s1 = Integer.toString(this.get_progress());
        String s2 = Integer.toString(this.indexes.size());
        return s1 + "/" + s2;
    }

    public boolean complete() {
        int total;
        if (this.completed) {
            return false;
        }
        int prog2 = this.get_progress();
        int temp = prog2 / (total = this.indexes.size());
        if (temp == 1) {
            this.completed = true;
            return true;
        }
        return false;
    }

    public String date() {
        LocalDateTime d = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("M/d h:mm a");
        return d.format(formatter);
    }

    private void update_item_names() {
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = 0; i < this.items.size(); ++i) {
            temp.add(this.items.get((int)i).item_name);
        }
        this.item_names = temp;
    }

    public boolean check_potion(Material item_type) {
        return item_type.equals((Object)Material.POTION) || item_type.equals((Object)Material.SPLASH_POTION) || item_type.equals((Object)Material.LINGERING_POTION) || item_type.equals((Object)Material.TIPPED_ARROW);
    }
}

