/*
 * Decompiled with CFR 0.152.
 */
package xyz.quazaros.util.commands;

import java.util.Arrays;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import xyz.quazaros.main;
import xyz.quazaros.util.commands.helpCommands.help;
import xyz.quazaros.util.commands.helpCommands.mainHelp;
import xyz.quazaros.util.commands.helpCommands.placeholderHelp;
import xyz.quazaros.util.commands.helpCommands.settings;
import xyz.quazaros.util.commands.helpCommands.timerHelp;
import xyz.quazaros.util.commands.itemCommands.check;
import xyz.quazaros.util.commands.itemCommands.list;
import xyz.quazaros.util.commands.itemCommands.player;
import xyz.quazaros.util.commands.itemCommands.prog;
import xyz.quazaros.util.commands.itemCommands.reset;
import xyz.quazaros.util.commands.itemCommands.send;
import xyz.quazaros.util.commands.itemCommands.submit;
import xyz.quazaros.util.commands.timeCommands.timeCommands;
import xyz.quazaros.util.files.config.config;
import xyz.quazaros.util.files.config.lang;

public class commands
implements CommandExecutor {
    main Main = main.getPlugin();
    lang Lang;
    help Help;
    settings Settings;
    mainHelp MainHelp;
    placeholderHelp PlaceholderHelp;
    timerHelp TimerHelp;
    boolean list_priority_public;

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        return this.sendCommand(sender, cmd, label, args);
    }

    public commands() {
        this.Lang = this.Main.lang;
        this.Help = new help();
        this.Settings = new settings();
        this.MainHelp = new mainHelp();
        this.PlaceholderHelp = new placeholderHelp();
        this.TimerHelp = new timerHelp();
    }

    public void initialize() {
        this.Help.initialize();
        this.Settings.initialize();
        this.MainHelp.initialize();
        this.PlaceholderHelp.initialize();
        this.TimerHelp.initialize();
        config Config = this.Main.data;
        this.list_priority_public = Config.general_global && !Config.general_others ? true : (Config.general_others && !Config.general_global ? false : !Config.general_listPriority);
    }

    public boolean sendCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player p = (Player)sender;
        xyz.quazaros.structures.player.player pl = this.Main.player_list.get_player_from_string(p.getName());
        String command_name = command.getName();
        if (!this.Main.commandNames.contains(command_name)) {
            return false;
        }
        switch (command_name) {
            case "ahelp": {
                this.aHelp(p);
                break;
            }
            case "atime": {
                this.aTime(p, args);
                break;
            }
            case "areset": {
                this.aReset(p);
                break;
            }
            case "aitem": 
            case "amob": {
                this.aItemMob(p, pl, command_name, args);
                break;
            }
            default: {
                p.sendMessage(this.Main.lang.colorBad + this.Lang.enterCommand);
            }
        }
        return true;
    }

    private void aHelp(Player p) {
        this.MainHelp.handle_help(p);
    }

    private void aReset(Player p) {
        if (!p.isOp()) {
            p.sendMessage(this.Main.lang.colorBad + this.Lang.noPermission);
        }
        this.Main.reset_plugin();
        p.sendMessage(this.Main.lang.colorGood + this.Lang.pluginReset);
    }

    private void aTime(Player p, String[] args) {
        if (args.length == 0) {
            p.sendMessage(this.Main.lang.colorBad + this.Lang.enterCommand);
            return;
        }
        String command_name = args[0].toLowerCase();
        args = Arrays.copyOfRange(args, 1, args.length);
        switch (command_name) {
            case "start": {
                timeCommands.timeStart(p);
                break;
            }
            case "pause": {
                timeCommands.timePause(p);
                break;
            }
            case "stop": {
                timeCommands.timeStop(p);
                break;
            }
            case "reset": {
                timeCommands.timeReset(p);
                break;
            }
            case "set": {
                timeCommands.timeSet(p, args);
                break;
            }
            case "placeholders": {
                this.PlaceholderHelp.handle_timer(p);
                break;
            }
            case "get": {
                timeCommands.timeGet(p);
                break;
            }
            case "active": {
                timeCommands.timeActive(p);
                break;
            }
            case "help": {
                this.TimerHelp.handle_help(p);
                break;
            }
            default: {
                p.sendMessage(this.Main.lang.colorBad + this.Lang.enterCommand);
            }
        }
    }

    private void aItemMob(Player p, xyz.quazaros.structures.player.player pl, String command_name, String[] args) {
        if (args.length == 0) {
            p.sendMessage(this.Main.lang.colorBad + this.Lang.enterCommand);
            return;
        }
        boolean com_isMob = command_name.equalsIgnoreCase("amob");
        if (!com_isMob && !this.Main.data.item_toggle) {
            p.sendMessage(this.Lang.colorBad + this.Lang.itemDisabled);
            return;
        }
        if (com_isMob && !this.Main.data.mob_toggle) {
            p.sendMessage(this.Lang.colorBad + this.Lang.mobDisabled);
            return;
        }
        command_name = args[0].toLowerCase();
        args = Arrays.copyOfRange(args, 1, args.length);
        switch (command_name) {
            case "send": {
                if (com_isMob) break;
                send.handle_send(p, args);
                break;
            }
            case "list": {
                list.handle_list(com_isMob, false, p, pl, args);
                break;
            }
            case "self": {
                list.handle_list(com_isMob, true, p, pl, args);
                break;
            }
            case "prog": {
                prog.handle_prog(p, args, com_isMob);
                break;
            }
            case "player": {
                player.handle_player(p, args, com_isMob, this.list_priority_public);
                break;
            }
            case "check": {
                check.handle_check(p, args, com_isMob);
                break;
            }
            case "settings": {
                this.Settings.handle_settings(p, com_isMob);
                break;
            }
            case "help": {
                this.Help.handle_help(p, com_isMob);
                break;
            }
            case "reset": {
                reset.handle_reset(p, com_isMob);
                break;
            }
            case "submit": {
                submit.handle_submit(p, args, com_isMob, false);
                break;
            }
            case "unsubmit": {
                submit.handle_submit(p, args, com_isMob, true);
                break;
            }
            case "placeholders": {
                this.PlaceholderHelp.handle_placeholder(p, com_isMob);
                break;
            }
            default: {
                p.sendMessage(this.Main.lang.colorBad + this.Lang.enterCommand);
            }
        }
    }
}

