/*
 * Decompiled with CFR 0.152.
 */
package xyz.quazaros.util.files;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.bukkit.configuration.file.YamlConfiguration;
import xyz.quazaros.main;
import xyz.quazaros.structures.items.item;
import xyz.quazaros.structures.items.itemData;
import xyz.quazaros.structures.items.itemList;
import xyz.quazaros.structures.player.player;
import xyz.quazaros.structures.player.playerList;

public class file {
    public List<String> file_list;
    public List<String> mob_file_list;
    private final File file_data;
    private final File file_items;
    private final File file_mobs;
    private final File file_player;
    private final File file_lists;
    private final File file_mob_lists;
    private final File file_normal;
    private final File file_alphabetical;
    private final File file_all;
    private final File file_normal_mobs;
    private final File file_personal_items;
    private final File file_personal_mobs;
    private final File file_timer;
    private final File configFile;
    private final File langFile;
    private final String path_pre = main.getPlugin().getDataFolder().getAbsolutePath();
    ArrayList<String> item_string_list;
    ArrayList<String> mob_string_list;
    public boolean reset = false;
    public boolean mob_reset = false;
    ArrayList<String> normal;
    ArrayList<String> alphabetical;
    ArrayList<String> all;
    ArrayList<String> normal_mobs;
    public ArrayList<String> items_init;
    public ArrayList<String> mobs_init;
    public ArrayList<String> all_items_init;
    public ArrayList<String> all_mobs_init;

    public file() {
        this.file_data = new File(this.path_pre + "/Data");
        this.file_items = new File(this.path_pre + "/Data/items.json");
        this.file_mobs = new File(this.path_pre + "/Data/mobs.json");
        this.file_player = new File(this.path_pre + "/Data/players.txt");
        this.file_lists = new File(this.path_pre + "/ItemLists");
        this.file_mob_lists = new File(this.path_pre + "/MobLists");
        this.file_normal = new File(this.path_pre + "/ItemLists/normal.txt");
        this.file_alphabetical = new File(this.path_pre + "/ItemLists/alphabetical.txt");
        this.file_all = new File(this.path_pre + "/ItemLists/all.txt");
        this.file_normal_mobs = new File(this.path_pre + "/MobLists/normal.txt");
        this.file_personal_items = new File(this.path_pre + "/Data/PersonalItems");
        this.file_personal_mobs = new File(this.path_pre + "/Data/PersonalMobs");
        this.file_timer = new File(this.path_pre + "/Data/timer.txt");
        this.configFile = new File(this.path_pre + "/config.yml");
        this.langFile = new File(this.path_pre + "/lang.yml");
        this.items_init = new ArrayList();
        this.mobs_init = new ArrayList();
        this.all_items_init = new ArrayList();
        this.all_mobs_init = new ArrayList();
        this.items_init.addAll(this.get_from_file("items.txt"));
        this.mobs_init.addAll(this.get_from_file("mobs.txt"));
        this.all_items_init.addAll(this.get_from_file("total_items.txt"));
        this.all_mobs_init.addAll(this.get_from_file("total_mobs.txt"));
        this.item_string_list = new ArrayList();
        this.normal = new ArrayList();
        this.alphabetical = new ArrayList();
        this.all = new ArrayList();
        this.normal_mobs = new ArrayList();
        this.normal.addAll(this.items_init);
        this.alphabetical.addAll(this.normal);
        Collections.sort(this.alphabetical);
        this.all.addAll(this.all_items_init);
        this.normal_mobs.addAll(this.mobs_init);
    }

    public void get_data() {
        try {
            this.setup_files();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.get_config();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.string_list_setup();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        main.getPlugin().emptyItemList = new itemList(false, this.item_string_list);
        main.getPlugin().emptyMobList = new itemList(true, this.mob_string_list);
        try {
            this.get_players();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.get_items();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.get_timer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void send_data(boolean remove) {
        try {
            this.send_items(remove);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.send_timer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void get_players() throws IOException {
        playerList player_list = main.getPlugin().player_list;
        if (this.file_player.exists()) {
            Scanner myScanner = new Scanner(this.file_player);
            while (myScanner.hasNextLine()) {
                player_list.players.add(new player(myScanner.nextLine()));
            }
        }
    }

    private void setup_files() throws IOException {
        this.file_data.mkdirs();
        this.file_personal_items.mkdirs();
        this.file_personal_mobs.mkdirs();
    }

    private void get_config() throws IOException {
        if (!this.configFile.exists()) {
            main.getPlugin().saveResource("config.yml", false);
        }
        YamlConfiguration config2 = YamlConfiguration.loadConfiguration((File)this.configFile);
        main.getPlugin().data.initialize(config2);
        if (!this.langFile.exists()) {
            main.getPlugin().saveResource("lang.yml", false);
        }
        YamlConfiguration langConfig = YamlConfiguration.loadConfiguration((File)this.langFile);
        main.getPlugin().lang.initialize(langConfig);
    }

    private void get_timer() throws IOException {
        if (!this.file_timer.exists()) {
            this.file_timer.createNewFile();
        } else {
            List<String> results = Files.readAllLines(this.file_timer.toPath());
            if (results.size() >= 2) {
                main.getPlugin().timer.timerActive = Boolean.parseBoolean(results.get(0));
                main.getPlugin().timer.timerTime = Integer.parseInt(results.get(1));
            }
        }
    }

    private void send_timer() throws IOException {
        FileWriter myWriter = new FileWriter(this.file_timer, false);
        myWriter.write(main.getPlugin().timer.timerActive + "\n");
        myWriter.write(Integer.toString(main.getPlugin().timer.timerTime));
        ((Writer)myWriter).close();
    }

    private void string_list_setup() throws IOException {
        FileWriter myWriter;
        this.file_normal.getParentFile().mkdirs();
        if (!this.file_normal.exists()) {
            this.file_normal.createNewFile();
            myWriter = new FileWriter(this.file_normal, false);
            for (int i = 0; i < this.normal.size(); ++i) {
                myWriter.write(this.normal.get(i) + "\n");
            }
            ((Writer)myWriter).close();
        }
        if (!this.file_alphabetical.exists()) {
            this.file_alphabetical.createNewFile();
            myWriter = new FileWriter(this.file_alphabetical, false);
            for (String i : this.alphabetical) {
                myWriter.write(i + "\n");
            }
            ((Writer)myWriter).close();
        }
        if (!this.file_all.exists()) {
            this.file_all.createNewFile();
            myWriter = new FileWriter(this.file_all, false);
            for (String i : this.all) {
                myWriter.write(i + "\n");
            }
            ((Writer)myWriter).close();
        }
        this.file_normal_mobs.getParentFile().mkdirs();
        if (!this.file_normal_mobs.exists()) {
            this.file_normal_mobs.createNewFile();
            myWriter = new FileWriter(this.file_normal_mobs, false);
            for (String i : this.normal_mobs) {
                myWriter.write(i + "\n");
            }
            ((Writer)myWriter).close();
        }
        this.item_string_list = this.get_item_from_list(main.getPlugin().data.item_file, false);
        this.mob_string_list = this.get_item_from_list(main.getPlugin().data.mob_file, true);
    }

    private void get_items() throws IOException {
        int j;
        int i;
        itemData[] temp;
        FileReader myReader;
        main.getPlugin().all_items = new itemList(main.getPlugin().emptyItemList, false);
        main.getPlugin().all_mobs = new itemList(main.getPlugin().emptyMobList, false);
        itemList all_items = main.getPlugin().all_items;
        itemList all_mobs = main.getPlugin().all_mobs;
        Gson gson = new GsonBuilder().setLenient().create();
        if (this.file_items.exists()) {
            myReader = new FileReader(this.file_items);
            temp = gson.fromJson((Reader)myReader, itemData[].class);
            for (i = 0; i < all_items.items.size(); ++i) {
                if (temp[i] != null && all_items.items.get((int)i).item_name != null && temp[i].name.equals(all_items.items.get((int)i).item_name)) {
                    all_items.items.get((int)i).item_data = temp[i];
                    if (!all_items.items.get((int)i).item_data.is_found.booleanValue()) continue;
                    all_items.items.get(i).submit(temp[i].player, temp[i].date);
                    continue;
                }
                for (j = 0; j < all_items.items.size(); ++j) {
                    if (temp[i] == null || all_items.items.get((int)i).item_name == null || !temp[i].name.equals(all_items.items.get((int)j).item_name)) continue;
                    all_items.items.get((int)j).item_data = temp[i];
                    if (!all_items.items.get((int)j).item_data.is_found.booleanValue()) continue;
                    all_items.items.get(j).submit(temp[i].player, temp[i].date);
                }
            }
            ((Reader)myReader).close();
        }
        if (this.file_mobs.exists()) {
            myReader = new FileReader(this.file_mobs);
            temp = gson.fromJson((Reader)myReader, itemData[].class);
            for (i = 0; i < all_mobs.items.size(); ++i) {
                if (temp[i].name.equals(all_mobs.items.get((int)i).item_name)) {
                    all_mobs.items.get((int)i).item_data = temp[i];
                    if (!all_mobs.items.get((int)i).item_data.is_found.booleanValue()) continue;
                    all_mobs.items.get(i).submit(temp[i].player, temp[i].date);
                    continue;
                }
                for (j = 0; j < all_mobs.items.size(); ++j) {
                    if (!temp[i].name.equals(all_mobs.items.get((int)j).item_name)) continue;
                    all_mobs.items.get((int)j).item_data = temp[i];
                    if (!all_mobs.items.get((int)j).item_data.is_found.booleanValue()) continue;
                    all_mobs.items.get(j).submit(temp[i].player, temp[i].date);
                }
            }
            ((Reader)myReader).close();
        }
        for (player pl : main.getPlugin().player_list.players) {
            int j2;
            int i2;
            itemData[] temp2;
            File tempFile = new File(this.path_pre + "/Data/PersonalItems/" + pl.name + ".json");
            if (tempFile.exists()) {
                myReader = new FileReader(tempFile);
                temp2 = gson.fromJson((Reader)myReader, itemData[].class);
                for (i2 = 0; i2 < pl.item_list.items.size(); ++i2) {
                    if (temp2[i2] != null && pl.item_list.items.get((int)i2).item_name != null && temp2[i2].name.equals(pl.item_list.items.get((int)i2).item_name)) {
                        pl.item_list.items.get((int)i2).item_data = temp2[i2];
                        if (!pl.item_list.items.get((int)i2).item_data.is_found.booleanValue()) continue;
                        if (temp2[i2].player.isEmpty()) {
                            pl.item_list.items.get(i2).submit(temp2[i2].date);
                            continue;
                        }
                        pl.item_list.items.get(i2).submit(temp2[i2].player, temp2[i2].date);
                        continue;
                    }
                    for (j2 = 0; j2 < pl.item_list.items.size(); ++j2) {
                        if (temp2[i2] == null || pl.item_list.items.get((int)i2).item_name == null || !temp2[i2].name.equals(pl.item_list.items.get((int)j2).item_name)) continue;
                        pl.item_list.items.get((int)j2).item_data = temp2[i2];
                        if (!pl.item_list.items.get((int)j2).item_data.is_found.booleanValue()) continue;
                        if (temp2[i2].player.isEmpty()) {
                            pl.item_list.items.get(i2).submit(temp2[i2].date);
                            continue;
                        }
                        pl.item_list.items.get(i2).submit(temp2[i2].player, temp2[i2].date);
                    }
                }
                ((Reader)myReader).close();
            }
            if (!(tempFile = new File(this.path_pre + "/Data/PersonalMobs/" + pl.name + ".json")).exists()) continue;
            myReader = new FileReader(tempFile);
            temp2 = gson.fromJson((Reader)myReader, itemData[].class);
            for (i2 = 0; i2 < pl.mob_list.items.size(); ++i2) {
                if (temp2[i2].name.equals(pl.mob_list.items.get((int)i2).item_name)) {
                    pl.mob_list.items.get((int)i2).item_data = temp2[i2];
                    if (!pl.mob_list.items.get((int)i2).item_data.is_found.booleanValue()) continue;
                    if (temp2[i2].player.isEmpty()) {
                        pl.mob_list.items.get(i2).submit(temp2[i2].date);
                        continue;
                    }
                    pl.mob_list.items.get(i2).submit(temp2[i2].player, temp2[i2].date);
                    continue;
                }
                for (j2 = 0; j2 < pl.mob_list.items.size(); ++j2) {
                    if (!temp2[i2].name.equals(pl.mob_list.items.get((int)j2).item_name)) continue;
                    pl.mob_list.items.get((int)j2).item_data = temp2[i2];
                    if (!pl.mob_list.items.get((int)j2).item_data.is_found.booleanValue()) continue;
                    if (temp2[i2].player.isEmpty()) {
                        pl.mob_list.items.get(i2).submit(temp2[i2].date);
                        continue;
                    }
                    pl.mob_list.items.get(i2).submit(temp2[i2].player, temp2[i2].date);
                }
            }
            ((Reader)myReader).close();
        }
        this.file_list = this.remove_txt(Arrays.asList(this.file_lists.list()));
        this.mob_file_list = this.remove_txt(Arrays.asList(this.file_mob_lists.list()));
    }

    private void send_items(boolean remove) throws IOException {
        FileWriter myWriter;
        boolean item_delete = remove && this.reset;
        boolean mob_delete = remove && this.mob_reset;
        itemList items = main.getPlugin().all_items;
        itemList mobs = main.getPlugin().all_mobs;
        playerList players = main.getPlugin().player_list;
        ArrayList<itemData> item_data_list = new ArrayList<itemData>();
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        if (!item_delete) {
            this.file_items.createNewFile();
            myWriter = new FileWriter(this.file_items, false);
            for (item i : items.items) {
                item_data_list.add(i.item_data);
            }
            gson.toJson(item_data_list, item_data_list.getClass(), myWriter);
            ((Writer)myWriter).flush();
            ((Writer)myWriter).close();
        } else {
            for (int i = 0; i < players.players.size(); ++i) {
                players.players.get((int)i).score = 0;
            }
            if (this.file_items.exists()) {
                this.file_items.delete();
            }
            if (this.file_personal_items.exists()) {
                this.file_personal_items.delete();
            }
        }
        item_data_list.clear();
        if (!mob_delete) {
            this.file_mobs.createNewFile();
            myWriter = new FileWriter(this.file_mobs, false);
            for (item i : mobs.items) {
                item_data_list.add(i.item_data);
            }
            gson.toJson(item_data_list, item_data_list.getClass(), myWriter);
            ((Writer)myWriter).flush();
            ((Writer)myWriter).close();
        } else {
            for (int i = 0; i < players.players.size(); ++i) {
                players.players.get((int)i).mobScore = 0;
            }
            if (this.file_mobs.exists()) {
                this.file_mobs.delete();
            }
        }
        for (player p : players.players) {
            item_data_list.clear();
            File tempFile = new File(this.file_personal_items + "/" + p.name + ".json");
            if (!item_delete) {
                tempFile.createNewFile();
                myWriter = new FileWriter(tempFile, false);
                for (item i : p.item_list.items) {
                    item_data_list.add(i.item_data);
                }
                gson.toJson(item_data_list, item_data_list.getClass(), myWriter);
                ((Writer)myWriter).flush();
                ((Writer)myWriter).close();
            } else {
                p.itemPerScore = 0;
                if (tempFile.exists()) {
                    tempFile.delete();
                }
            }
            item_data_list.clear();
            tempFile = new File(this.file_personal_mobs + "/" + p.name + ".json");
            if (!mob_delete) {
                tempFile.createNewFile();
                myWriter = new FileWriter(tempFile, false);
                for (item i : p.mob_list.items) {
                    item_data_list.add(i.item_data);
                }
                gson.toJson(item_data_list, item_data_list.getClass(), myWriter);
                ((Writer)myWriter).flush();
                ((Writer)myWriter).close();
                continue;
            }
            p.mobPerScore = 0;
            if (!tempFile.exists()) continue;
            tempFile.delete();
        }
        this.file_player.createNewFile();
        myWriter = new FileWriter(this.file_player, false);
        for (player p : players.players) {
            myWriter.write(p.name + "\n");
        }
        ((Writer)myWriter).close();
    }

    private ArrayList<String> get_item_from_list(String str, boolean is_mob) throws IOException {
        File file_itemlist = !is_mob ? new File(this.path_pre + "/ItemLists/" + str + ".txt") : new File(this.path_pre + "/MobLists/" + str + ".txt");
        ArrayList<String> temp = new ArrayList();
        if (file_itemlist.exists()) {
            Scanner myReader = new Scanner(file_itemlist);
            while (myReader.hasNextLine()) {
                temp.add(myReader.nextLine());
            }
        } else {
            temp = !is_mob ? this.normal : this.normal_mobs;
        }
        return temp;
    }

    private ArrayList<String> get_from_file(String path) {
        ArrayList<String> temp = new ArrayList<String>();
        try (InputStream inputStream = main.class.getClassLoader().getResourceAsStream("Data/" + path);){
            if (inputStream != null) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    temp.add(line);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return temp;
    }

    private List<String> remove_txt(List<String> list2) {
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = 0; i < list2.size(); ++i) {
            temp.add(list2.get(i).substring(0, list2.get(i).length() - 4));
        }
        return temp;
    }
}

