/*
 * Decompiled with CFR 0.152.
 */
package xyz.quazaros.structures.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import xyz.quazaros.main;
import xyz.quazaros.structures.items.item;
import xyz.quazaros.structures.items.itemList;
import xyz.quazaros.structures.player.playerList;
import xyz.quazaros.structures.player.playerSort;
import xyz.quazaros.util.files.config.lang;

public class inventory {
    public ArrayList<Inventory> inventory_list = new ArrayList();
    public ArrayList<Inventory> sorted_list = new ArrayList();
    public int size;
    ItemStack forward;
    ItemStack back;
    ItemStack leaderboard;
    ItemStack players;
    ItemStack sort;
    ItemStack flip;
    private final Material item_arrow = Material.ARROW;
    private final Material item_leaderboard;
    private final Material item_progress;
    private final Material item_sort;
    private final Material item_flip;
    public boolean is_mob;
    public boolean is_public;
    public boolean is_playerList;
    public boolean is_sorted;
    public boolean add_flip;

    public inventory() {
        this.item_leaderboard = main.getPlugin().version.tryMaterials("oak_hanging_sign", "oak_sign");
        this.item_progress = Material.DIAMOND;
        this.item_sort = Material.HOPPER;
        this.item_flip = Material.OAK_DOOR;
    }

    public void set_inventory(itemList itemList2, String text) {
        this.is_mob = itemList2.mob;
        this.is_public = !itemList2.personal;
        this.is_playerList = false;
        this.add_flip = true;
        ArrayList<item> item_list = itemList2.get_sub_items();
        ArrayList<item> sorted_items = this.sort(item_list);
        this.size = (item_list.size() - 1) / 45 + 1;
        this.menuButtons(itemList2.progPer());
        this.inventory_list.clear();
        this.sorted_list.clear();
        for (int i = 0; i < this.size; ++i) {
            this.inventory_list.add(Bukkit.createInventory(null, (int)54, (String)(ChatColor.DARK_GREEN + text + " " + (i + 1))));
            this.sorted_list.add(Bukkit.createInventory(null, (int)54, (String)(ChatColor.DARK_GREEN + text + " " + (i + 1))));
            for (int j = 0; j < 45; ++j) {
                if (j + 45 * i >= item_list.size()) continue;
                this.inventory_list.get(i).setItem(j, item_list.get((int)(j + 45 * i)).item_stack);
                this.sorted_list.get(i).setItem(j, sorted_items.get((int)(j + 45 * i)).item_stack);
            }
            this.inventory_list.get(i).setItem(49, this.leaderboard);
            this.sorted_list.get(i).setItem(49, this.leaderboard);
            this.inventory_list.get(i).setItem(51, this.players);
            this.sorted_list.get(i).setItem(51, this.players);
            this.inventory_list.get(i).setItem(47, this.sort);
            this.sorted_list.get(i).setItem(47, this.sort);
            if (this.size <= 1) continue;
            this.inventory_list.get(i).setItem(53, this.forward);
            this.sorted_list.get(i).setItem(53, this.forward);
            this.inventory_list.get(i).setItem(45, this.back);
            this.sorted_list.get(i).setItem(45, this.back);
        }
    }

    public void set_players(boolean mob, boolean public_p) {
        playerList player_list = main.getPlugin().player_list;
        ArrayList<playerSort> plSort = player_list.sort_players(mob, !public_p);
        this.is_mob = mob;
        this.is_public = public_p;
        this.is_playerList = true;
        this.is_sorted = false;
        lang Lang = main.getPlugin().lang;
        String text = !this.is_mob ? (this.is_public ? Lang.playerList : Lang.personalPlayerList) : (this.is_public ? Lang.mobPlayerList : Lang.mobPersonalPlayerList);
        this.size = player_list.players.size() / 45 + 1;
        this.menuButtons();
        this.inventory_list.clear();
        this.sorted_list.clear();
        this.add_flip = !this.is_public && main.getPlugin().data.general_global || this.is_public && main.getPlugin().data.general_others;
        for (int i = 0; i < this.size; ++i) {
            this.inventory_list.add(Bukkit.createInventory(null, (int)54, (String)(ChatColor.DARK_GREEN + text + " " + (i + 1))));
            this.sorted_list.add(Bukkit.createInventory(null, (int)54, (String)(ChatColor.DARK_GREEN + text + " " + (i + 1))));
            for (int j = 0; j < 45; ++j) {
                if (j + 45 * i >= plSort.size()) continue;
                this.inventory_list.get(i).setItem(j, this.getPlayerHead(plSort.get(j + 45 * i)));
            }
            if (this.add_flip) {
                this.inventory_list.get(i).setItem(49, this.flip);
            }
            if (this.size <= 1) continue;
            this.inventory_list.get(i).setItem(53, this.forward);
            this.inventory_list.get(i).setItem(45, this.back);
        }
    }

    public void menuButtons(String progPercent) {
        lang Lang = main.getPlugin().lang;
        this.forward = new ItemStack(this.item_arrow);
        this.back = new ItemStack(this.item_arrow);
        this.leaderboard = new ItemStack(this.item_progress);
        this.players = new ItemStack(this.item_leaderboard);
        this.sort = new ItemStack(this.item_sort);
        ItemMeta forwardM = this.forward.getItemMeta();
        forwardM.setDisplayName(Lang.colorHigh + Lang.nextPage);
        this.forward.setItemMeta(forwardM);
        ItemMeta backM = this.back.getItemMeta();
        backM.setDisplayName(Lang.colorHigh + Lang.lastPage);
        this.back.setItemMeta(backM);
        ItemMeta sortM = this.sort.getItemMeta();
        sortM.setDisplayName(Lang.colorSec + Lang.filterItems);
        this.sort.setItemMeta(sortM);
        ItemMeta leaderboardM = this.leaderboard.getItemMeta();
        leaderboardM.setDisplayName(Lang.colorSec + Lang.progress);
        leaderboardM.setLore(Arrays.asList(Lang.colorDom + progPercent));
        main.getPlugin().version.setGlint(leaderboardM, true);
        this.leaderboard.setItemMeta(leaderboardM);
        ItemMeta playersM = this.players.getItemMeta();
        playersM.setDisplayName(Lang.colorSec + Lang.leaderboard);
        if (!this.is_mob) {
            if (this.is_public) {
                playersM.setLore(main.getPlugin().player_list.leaderboard(false, false));
            } else {
                playersM.setLore(main.getPlugin().player_list.leaderboard(false, true));
            }
        } else if (this.is_public) {
            playersM.setLore(main.getPlugin().player_list.leaderboard(true, false));
        } else {
            playersM.setLore(main.getPlugin().player_list.leaderboard(true, true));
        }
        this.players.setItemMeta(playersM);
    }

    private void menuButtons() {
        lang Lang = main.getPlugin().lang;
        this.forward = new ItemStack(this.item_arrow);
        this.back = new ItemStack(this.item_arrow);
        this.flip = new ItemStack(this.item_flip);
        ItemMeta forwardM = this.forward.getItemMeta();
        forwardM.setDisplayName(Lang.colorHigh + Lang.nextPage);
        this.forward.setItemMeta(forwardM);
        ItemMeta backM = this.back.getItemMeta();
        backM.setDisplayName(Lang.colorHigh + Lang.lastPage);
        this.back.setItemMeta(backM);
        ItemMeta flipM = this.flip.getItemMeta();
        flipM.setDisplayName(Lang.colorSec + (!this.is_public ? Lang.mainButton : Lang.personalButton));
        this.flip.setItemMeta(flipM);
    }

    private ArrayList<item> sort(ArrayList<item> items) {
        ArrayList<item> temp = new ArrayList<item>();
        for (item i : items) {
            if (i.isFound) continue;
            temp.add(i);
        }
        for (item i : items) {
            if (!i.isFound) continue;
            temp.add(i);
        }
        return temp;
    }

    private ItemStack getPlayerHead(playerSort pl) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        OfflinePlayer player2 = this.getPlayerSafe(pl.name);
        if (player2 != null && player2.hasPlayedBefore()) {
            meta.setOwningPlayer(player2);
        }
        meta.setDisplayName(main.getPlugin().lang.colorDom + pl.name);
        meta.setLore(Arrays.asList(main.getPlugin().lang.colorSec + "Score: " + pl.score));
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private OfflinePlayer getPlayerSafe(String name) {
        for (OfflinePlayer offline : Bukkit.getOfflinePlayers()) {
            if (offline.getName() == null || !offline.getName().equalsIgnoreCase(name)) continue;
            return offline;
        }
        return null;
    }
}

