/*
 * Decompiled with CFR 0.152.
 */
package com.liba.dependency;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldGuardDep {
    boolean enabled;
    Plugin pl = Bukkit.getServer().getPluginManager().getPlugin("WorldGuard");

    public WorldGuardDep() {
        if (this.pl != null) {
            Bukkit.getLogger().info("[" + this.pl.getName() + "] WorldGuard connected");
            this.enabled = true;
        }
    }

    public boolean checkLocation(Location location, UUID playerUUID) {
        if (!this.isEnabled()) {
            return true;
        }
        Player bukkitPlayer = Bukkit.getPlayer((UUID)playerUUID);
        if (bukkitPlayer == null) {
            return false;
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(BukkitAdapter.adapt((World)location.getWorld()));
        com.sk89q.worldedit.util.Location wgLoc = BukkitAdapter.adapt((Location)location);
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(bukkitPlayer);
        RegionQuery query = container.createQuery();
        boolean passthrough = query.testState(wgLoc, localPlayer, new StateFlag[]{Flags.PASSTHROUGH});
        if (passthrough) {
            return true;
        }
        if (manager != null) {
            ApplicableRegionSet regions = manager.getApplicableRegions(BukkitAdapter.asBlockVector((Location)location));
            if (regions.size() == 0) {
                return true;
            }
            for (ProtectedRegion region : regions) {
                if (region.getOwners().contains(playerUUID)) {
                    return true;
                }
                if (region.getMembers().contains(playerUUID)) {
                    return true;
                }
                if (!bukkitPlayer.isOp()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getRadiusRegion(Location location, int radius, UUID player) {
        if (this.isEnabled()) {
            for (int x = location.getBlockX() - radius; x < location.getBlockX() + radius; ++x) {
                for (int y = location.getBlockY() - radius; y < location.getBlockY() + radius; ++y) {
                    for (int z = location.getBlockZ() - radius; z < location.getBlockZ() + radius; ++z) {
                        if (this.checkLocation(new Location(location.getWorld(), (double)x, (double)y, (double)z), player)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

