/*
 * Decompiled with CFR 0.152.
 */
package com.liba.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Color;

public class MinecraftColor {
    private static final Pattern HEX_PATTERN = Pattern.compile("#[a-fA-F0-9]{6}");
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("<gradient:((?:#[0-9a-fA-F]{6}:?)+)>(.*?)</gradient>");

    public static Color getColorByName(String name) {
        switch (name.toLowerCase()) {
            case "white": {
                return Color.WHITE;
            }
            case "silver": {
                return Color.SILVER;
            }
            case "gray": {
                return Color.GRAY;
            }
            case "black": {
                return Color.BLACK;
            }
            case "red": {
                return Color.RED;
            }
            case "maroon": {
                return Color.MAROON;
            }
            case "yellow": {
                return Color.YELLOW;
            }
            case "olive": {
                return Color.OLIVE;
            }
            case "lime": {
                return Color.LIME;
            }
            case "green": {
                return Color.GREEN;
            }
            case "aqua": {
                return Color.AQUA;
            }
            case "teal": {
                return Color.TEAL;
            }
            case "blue": {
                return Color.BLUE;
            }
            case "navy": {
                return Color.NAVY;
            }
            case "fuchsia": {
                return Color.FUCHSIA;
            }
            case "purple": {
                return Color.PURPLE;
            }
            case "orange": {
                return Color.ORANGE;
            }
        }
        return Color.WHITE;
    }

    public static String format(String str) {
        return MinecraftColor.translate(MinecraftColor.parseGradient(str));
    }

    private static String translate(String message) {
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hexColor = matcher.group();
            matcher.appendReplacement(buffer, ChatColor.of((String)hexColor).toString());
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }

    private static String parseGradient(String input) {
        if (input == null) {
            return "";
        }
        Matcher matcher = GRADIENT_PATTERN.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String colorsGroup = matcher.group(1);
            String text = matcher.group(2);
            String[] hexColors = colorsGroup.split(":");
            String gradientText = MinecraftColor.generateMultiGradient(text, hexColors);
            matcher.appendReplacement(result, Matcher.quoteReplacement(gradientText));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String generateMultiGradient(String text, String[] colors) {
        if (colors.length < 2 || text.isEmpty()) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        int parts = colors.length - 1;
        int length = text.length();
        int baseSegment = length / parts;
        int remainder = length % parts;
        int charIndex = 0;
        for (int i = 0; i < parts; ++i) {
            int segmentLength = baseSegment + (i < remainder ? 1 : 0);
            int[] startRGB = MinecraftColor.hexToRgb(colors[i].substring(1));
            int[] endRGB = MinecraftColor.hexToRgb(colors[i + 1].substring(1));
            for (int j = 0; j < segmentLength; ++j) {
                float ratio = (float)j / (float)Math.max(segmentLength - 1, 1);
                int red = (int)((float)startRGB[0] + ratio * (float)(endRGB[0] - startRGB[0]));
                int green = (int)((float)startRGB[1] + ratio * (float)(endRGB[1] - startRGB[1]));
                int blue = (int)((float)startRGB[2] + ratio * (float)(endRGB[2] - startRGB[2]));
                String hex = String.format("#%02x%02x%02x", red, green, blue);
                builder.append(ChatColor.of((String)hex)).append(text.charAt(charIndex++));
            }
        }
        return builder.toString();
    }

    private static int[] hexToRgb(String hex) {
        return new int[]{Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4, 6), 16)};
    }
}

