/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.events;

import com.liba.utils.ItemUtil;
import com.liba.utils.player.PlayerUtils;
import com.modencore.CodeLock;
import com.modencore.GuiManager;
import com.modencore.LockItemManager;
import com.modencore.lock.LockItem;
import com.modencore.utils.CodeLockUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class LockItemEvent
implements Listener {
    @EventHandler
    public void playerPlaceBlock(BlockPlaceEvent e) {
        if (!CodeLockUtils.isWorkItem(e.getBlock())) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)CodeLock.getPlugin(), () -> {
            Block block = e.getBlock();
            BlockState patt0$temp = block.getState();
            if (!(patt0$temp instanceof Chest)) {
                ArrayList<Location> locationList = new ArrayList<Location>(CodeLockUtils.getLocation(block));
                LockItem lockItem = new LockItem(locationList, e.getPlayer().getUniqueId(), UUID.randomUUID());
                LockItemManager.addLockItem(lockItem);
                PlayerUtils.sendMessage(e.getPlayer().getUniqueId(), CodeLock.getPlugin().getLang().prefix("message.canplace").replace("{material}", ItemUtil.getMaterialName(block.getType().name())));
                return;
            }
            Chest chestState = (Chest)patt0$temp;
            InventoryHolder holder = chestState.getInventory().getHolder();
            if (holder instanceof DoubleChest) {
                DoubleChest doubleChest = (DoubleChest)holder;
                Chest left = (Chest)doubleChest.getLeftSide();
                Chest right = (Chest)doubleChest.getRightSide();
                Location leftLoc = left.getLocation().getBlock().getLocation();
                Location rightLoc = right.getLocation().getBlock().getLocation();
                LockItem leftLock = LockItemManager.getLockItem(leftLoc);
                LockItem rightLock = LockItemManager.getLockItem(rightLoc);
                if (leftLock != null && rightLock == null) {
                    leftLock.addLocation(rightLoc);
                } else if (rightLock != null && leftLock == null) {
                    rightLock.addLocation(leftLoc);
                } else if (leftLock == null && rightLock == null) {
                    List<Location> locations = List.of(leftLoc, rightLoc);
                    LockItem lockItem = new LockItem(new ArrayList<Location>(locations), e.getPlayer().getUniqueId(), UUID.randomUUID());
                    LockItemManager.addLockItem(lockItem);
                }
            } else {
                Location loc = block.getLocation().getBlock().getLocation();
                LockItem lockItem = new LockItem(new ArrayList<Location>(List.of(loc)), e.getPlayer().getUniqueId(), UUID.randomUUID());
                PlayerUtils.sendMessage(e.getPlayer().getUniqueId(), CodeLock.getPlugin().getLang().prefix("message.canplace").replace("{material}", ItemUtil.getMaterialName(block.getType().name())));
                LockItemManager.addLockItem(lockItem);
            }
        }, 1L);
    }

    @EventHandler
    public void playerBreak(BlockBreakEvent e) {
        LockItem lockItem = LockItemManager.getLockItem(e.getBlock().getLocation());
        if (lockItem != null) {
            Chest chest;
            InventoryHolder inventoryHolder;
            BlockState blockState = e.getBlock().getState();
            if (blockState instanceof Chest && (inventoryHolder = (chest = (Chest)blockState).getInventory().getHolder()) instanceof DoubleChest) {
                LockItem lockitem = LockItemManager.getLockItem(e.getBlock().getLocation());
                lockitem.removeLocation(e.getBlock().getLocation());
                CodeLock.getPlugin().getLockItemStorage().save(lockItem);
                return;
            }
            LockItemManager.removeLockItem(lockItem);
        }
    }

    @EventHandler
    public void interactEvent(PlayerInteractEvent e) {
        if (e.getClickedBlock() != null) {
            Location location = e.getClickedBlock().getLocation();
            LockItem lockItem = LockItemManager.getLockItem(location);
            if (lockItem == null) {
                return;
            }
            Player p = e.getPlayer();
            if (p.isSneaking() && lockItem.getOwner().equals(p.getUniqueId())) {
                GuiManager.open(p, lockItem);
                e.setCancelled(true);
            }
            if (!lockItem.isAuthorized(p.getUniqueId())) {
                GuiManager.open(e.getPlayer(), lockItem);
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void redstoneEvent(BlockRedstoneEvent e) {
    }

    @EventHandler
    public void playerClick(PlayerInteractEvent e) {
    }
}

