/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.lock;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;

public class LockItem {
    List<Location> location;
    UUID owner;
    List<UUID> authedPlayers = new ArrayList<UUID>();
    int password;
    UUID key;

    public LockItem(List<Location> location, UUID owner, UUID key) {
        this.key = key;
        this.location = location;
        this.owner = owner;
    }

    public void authorize(UUID player) {
        this.authedPlayers.add(player);
    }

    public void removeAuthedPlayer(UUID player) {
        this.authedPlayers.remove(player);
    }

    public void removeAllAuthedPlayers() {
        for (UUID uuid : this.authedPlayers) {
            this.removeAuthedPlayer(uuid);
        }
    }

    public boolean isAuthorized(UUID player) {
        return this.authedPlayers.contains(player) || player.equals(this.owner) || this.password == 0;
    }

    public List<Location> getLocation() {
        return this.location;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public List<UUID> getAuthedPlayers() {
        return this.authedPlayers;
    }

    public void setPassword(int password) {
        this.password = password;
    }

    public int getPassword() {
        return this.password;
    }

    public UUID getKey() {
        return this.key;
    }

    public void setAuthedPlayers(List<UUID> authedPlayers) {
        this.authedPlayers = authedPlayers;
    }

    public void addLocation(Location location) {
        this.getLocation().add(location);
    }

    public void removeLocation(Location location) {
        this.getLocation().remove(location);
    }
}

