/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.storage;

import com.modencore.CodeLock;
import com.modencore.LockItemManager;
import com.modencore.lock.LockItem;
import com.modencore.utils.CodeLockUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;

public class LockItemStorage {
    File dir = new File(String.valueOf(CodeLock.getPlugin().getDataFolder()) + File.separator + "keys");

    public LockItemStorage() {
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
    }

    public void remove(LockItem lockItem) {
        File file = new File(this.dir, String.valueOf(lockItem.getKey()) + ".yml");
        if (file.exists()) {
            file.delete();
        }
    }

    public void save(LockItem lockItem) {
        File f = new File(this.dir, lockItem.getKey().toString() + ".yml");
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)f);
        Location location = lockItem.getLocation().getFirst();
        config.set("location.x", (Object)location.getBlockX());
        config.set("location.y", (Object)location.getBlockY());
        config.set("location.z", (Object)location.getBlockZ());
        config.set("location.world", (Object)location.getWorld().getName());
        config.set("owner", (Object)lockItem.getOwner().toString());
        config.set("password", (Object)lockItem.getPassword());
        config.set("authedplayers", lockItem.getAuthedPlayers().stream().map(UUID::toString).toList());
        try {
            config.save(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadall() {
        File[] files;
        for (File file : files = this.dir.listFiles((dir1, name) -> name.toLowerCase().endsWith(".yml"))) {
            this.load(file);
        }
    }

    public void load(File file) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        int x = config.getInt("location.x");
        int y = config.getInt("location.y");
        int z = config.getInt("location.z");
        World world = Bukkit.getWorld((String)config.getString("location.world"));
        if (world == null) {
            throw new RuntimeException("World not found!");
        }
        UUID owner = UUID.fromString(config.getString("owner"));
        int password = config.getInt("password");
        ArrayList<UUID> uuids = new ArrayList<UUID>(config.getList("authedplayers").stream().map(o -> UUID.fromString((String)o)).toList());
        Location location = new Location(world, (double)x, (double)y, (double)z);
        ArrayList<Location> locationList = new ArrayList<Location>(CodeLockUtils.getLocation(location.getBlock()));
        LockItem lockItem = new LockItem(locationList, owner, UUID.fromString(file.getName().split("\\.")[0]));
        lockItem.setAuthedPlayers(uuids);
        lockItem.setPassword(password);
        LockItemManager.addLockItem(lockItem);
    }
}

