/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.multipart.api.MultipartType;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import mrtjp.projectred.integration.IntegrationNetwork;
import mrtjp.projectred.integration.data.IntegrationItemModelProvider;
import mrtjp.projectred.integration.data.IntegrationLanguageProvider;
import mrtjp.projectred.integration.data.IntegrationRecipeProvider;
import mrtjp.projectred.integration.init.IntegrationClientInit;
import mrtjp.projectred.integration.init.IntegrationCreativeModeTabs;
import mrtjp.projectred.integration.init.IntegrationParts;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="projectred_integration")
public class ProjectRedIntegration {
    public static final String MOD_ID = "projectred_integration";
    public static final Logger LOGGER = LogManager.getLogger((String)"projectred_integration");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"projectred_integration");
    public static final DeferredRegister<MultipartType<?>> PART_TYPES = DeferredRegister.create((ResourceKey)MultipartType.MULTIPART_TYPES, (String)"projectred_integration");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"projectred_integration");
    @Nullable
    private static ModContainer container;

    public ProjectRedIntegration(ModContainer container, IEventBus modEventBus) {
        ProjectRedIntegration.container = container;
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        if (FMLEnvironment.dist.isClient()) {
            IntegrationClientInit.init(modEventBus);
        }
        IntegrationNetwork.init(modEventBus);
        ITEMS.register(modEventBus);
        PART_TYPES.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
    }

    public static ModContainer getContainer() {
        return Objects.requireNonNull(container);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture registries = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new IntegrationItemModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new IntegrationLanguageProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new IntegrationRecipeProvider(registries, output));
    }

    static {
        IntegrationParts.register();
        IntegrationCreativeModeTabs.register();
    }
}

