/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration.gui.screen;

import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.multipart.api.part.MultiPart;
import java.util.Objects;
import mrtjp.projectred.integration.IntegrationNetwork;
import mrtjp.projectred.integration.part.ComplexGatePart;
import mrtjp.projectred.integration.part.GatePart;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.ButtonNode;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.RedUIScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TimerScreen
extends RedUIScreen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"textures/gui/timer_gate.png");
    private final GatePart gate;
    private final ComplexGatePart.ITimerGuiLogic timerGate;

    public TimerScreen(GatePart gate) {
        super(256, 55, (Component)Component.literal((String)Objects.requireNonNull(gate.getType().getRegistryName()).toString()));
        this.gate = gate;
        this.timerGate = (ComplexGatePart.ITimerGuiLogic)((Object)gate);
        this.createButton(5, 25, 40, 20, "-10s", -200);
        this.createButton(46, 25, 40, 20, "-1s", -20);
        this.createButton(87, 25, 40, 20, "-50ms", -1);
        this.createButton(129, 25, 40, 20, "+50ms", 1);
        this.createButton(170, 25, 40, 20, "+1s", 20);
        this.createButton(211, 25, 40, 20, "+10s", 200);
    }

    private void createButton(int x, int y, int w, int h, String text, int delta) {
        ButtonNode b = new ButtonNode();
        b.setPosition(x, y);
        b.setSize(w, h);
        b.setButtonText(text);
        b.setClickFunction(() -> {
            PacketCustom packet = new PacketCustom(IntegrationNetwork.NET_CHANNEL, 3, Minecraft.getInstance().level.registryAccess());
            IntegrationNetwork.writePartIndex((MCDataOutput)packet, (MultiPart)this.gate);
            packet.writeShort(delta);
            packet.sendToServer();
        });
        this.addChild((RedUINode)b);
    }

    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        super.drawBack(graphics, mouse, partialFrame);
        int x = this.getFrame().x();
        int y = this.getFrame().y();
        graphics.blit(BACKGROUND, x, y, 0, 0, this.getFrame().width(), this.getFrame().height());
        String s = String.format("Timer interval: %.2fs", (double)this.timerGate.getTimerMax() * 0.05);
        int sw = this.getFontRenderer().width(s);
        graphics.drawString(this.getFontRenderer(), s, (float)x + (float)(this.getFrame().width() - sw) / 2.0f, (float)y + 8.0f, 0x404040, false);
    }

    public void update() {
        if (!this.gate.hasTile()) {
            Objects.requireNonNull(this.getMinecraft().player).closeContainer();
        }
    }
}

