/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.packet.PacketCustomChannel;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.BlockMultipart;
import java.util.Objects;
import mrtjp.projectred.integration.ProjectRedIntegration;
import mrtjp.projectred.integration.gui.screen.CounterScreen;
import mrtjp.projectred.integration.gui.screen.TimerScreen;
import mrtjp.projectred.integration.part.ComplexGatePart;
import mrtjp.projectred.integration.part.GatePart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;

public class IntegrationNetwork {
    public static final ResourceLocation NET_CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"network");
    public static final int OPEN_TIMER_GUI_FROM_SERVER = 1;
    public static final int OPEN_COUNTER_GUI_FROM_SERVER = 2;
    public static final int INCR_TIMER_FROM_CLIENT = 3;
    public static final int INCR_COUNTER_FROM_CLIENT = 4;
    private static final PacketCustomChannel channel = new PacketCustomChannel(NET_CHANNEL).versioned(ProjectRedIntegration.getContainer().getModInfo().getVersion().toString()).client(() -> ClientHandler::new).server(() -> ServerHandler::new);

    public static void init(IEventBus modBus) {
        channel.init(modBus);
    }

    public static MCDataOutput writePartIndex(MCDataOutput out, MultiPart part) {
        out.writePos(part.pos()).writeByte(part.tile().getPartList().indexOf(part));
        return out;
    }

    public static MultiPart readPartIndex(Level world, MCDataInput in) {
        BlockPos pos = in.readPos();
        short index = in.readUByte();
        return (MultiPart)Objects.requireNonNull(BlockMultipart.getTile((BlockGetter)world, (BlockPos)pos)).getPartList().get(index);
    }

    private static class ServerHandler
    implements ICustomPacketHandler.IServerPacketHandler {
        private ServerHandler() {
        }

        public void handlePacket(PacketCustom packet, ServerPlayer sender) {
            switch (packet.getType()) {
                case 3: {
                    this.handleIncrTimerMessage(sender.level(), packet);
                    break;
                }
                case 4: {
                    this.handleIncrCounterMessage(sender.level(), packet);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid key received from client: " + packet.getType());
                }
            }
        }

        private void handleIncrTimerMessage(Level world, PacketCustom packet) {
            MultiPart part = IntegrationNetwork.readPartIndex(world, (MCDataInput)packet);
            if (part instanceof ComplexGatePart.ITimerGuiLogic) {
                ComplexGatePart.ITimerGuiLogic gate = (ComplexGatePart.ITimerGuiLogic)part;
                gate.setTimerMax(gate.getTimerMax() + packet.readShort());
            }
        }

        private void handleIncrCounterMessage(Level world, PacketCustom packet) {
            MultiPart part = IntegrationNetwork.readPartIndex(world, (MCDataInput)packet);
            if (part instanceof ComplexGatePart.ICounterGuiLogic) {
                ComplexGatePart.ICounterGuiLogic gate = (ComplexGatePart.ICounterGuiLogic)part;
                byte actionId = packet.readByte();
                switch (actionId) {
                    case 0: {
                        gate.setCounterMax(gate.getCounterMax() + packet.readShort());
                        break;
                    }
                    case 1: {
                        gate.setCounterIncr(gate.getCounterIncr() + packet.readShort());
                        break;
                    }
                    case 2: {
                        gate.setCounterDecr(gate.getCounterDecr() + packet.readShort());
                        break;
                    }
                    default: {
                        ProjectRedIntegration.LOGGER.error("Unknown counter action id: " + actionId);
                    }
                }
            }
        }
    }

    private static class ClientHandler
    implements ICustomPacketHandler.IClientPacketHandler {
        private ClientHandler() {
        }

        public void handlePacket(PacketCustom packet, Minecraft mc) {
            switch (packet.getType()) {
                case 1: {
                    this.handleOpenTimerGuiMessage(mc, (MCDataInput)packet);
                    break;
                }
                case 2: {
                    this.handleOpenCounterGuiMessage(mc, (MCDataInput)packet);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid key received from server: " + packet.getType());
                }
            }
        }

        private void handleOpenTimerGuiMessage(Minecraft mc, MCDataInput data) {
            MultiPart part = IntegrationNetwork.readPartIndex((Level)Objects.requireNonNull(mc.level), data);
            if (part instanceof ComplexGatePart.ITimerGuiLogic) {
                mc.setScreen((Screen)new TimerScreen((GatePart)part));
            }
        }

        private void handleOpenCounterGuiMessage(Minecraft mc, MCDataInput data) {
            MultiPart part = IntegrationNetwork.readPartIndex((Level)Objects.requireNonNull(mc.level), data);
            if (part instanceof ComplexGatePart.ICounterGuiLogic) {
                mc.setScreen((Screen)new CounterScreen((GatePart)part));
            }
        }
    }
}

