/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration.client;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.lighting.LightModel;
import codechicken.lib.render.lighting.PlanarLightModel;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rectangle4i;
import codechicken.lib.vec.RedundantTransformation;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.IconTransformation;
import codechicken.lib.vec.uv.MultiIconTransformation;
import codechicken.lib.vec.uv.UV;
import codechicken.lib.vec.uv.UVRotation;
import codechicken.lib.vec.uv.UVScale;
import codechicken.lib.vec.uv.UVTransformation;
import codechicken.lib.vec.uv.UVTranslation;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import mrtjp.projectred.core.BundledSignalsLib;
import mrtjp.projectred.core.client.HaloRenderer;
import mrtjp.projectred.lib.VecLib;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;

public class GateComponentModels {
    public static final CCModel base = GateComponentModels.loadBaseModel("base");
    public static final CCModel lightChip = GateComponentModels.loadModel("chip");
    public static final CCModel leverOn = GateComponentModels.loadModel("leveron").apply((Transformation)new Translation(0.0, 0.125, 0.0));
    public static final CCModel leverOff = GateComponentModels.loadModel("leveroff").apply((Transformation)new Translation(0.0, 0.125, 0.0));
    public static final CCModel solarArray = GateComponentModels.loadModel("solar");
    public static final CCModel rainSensor = GateComponentModels.loadModel("rainsensor");
    public static final CCModel pointer = GateComponentModels.loadModel("pointer");
    public static final CCModel busXcvr = GateComponentModels.loadModel("array/busxcvr");
    public static final CCModel lightPanel1 = GateComponentModels.loadModel("array/lightpanel1");
    public static final CCModel lightPanel2 = GateComponentModels.loadModel("array/lightpanel2");
    public static final CCModel busRand = GateComponentModels.loadModel("array/busrand");
    public static final CCModel busConv = GateComponentModels.loadModel("array/busconv");
    public static final CCModel signalPanel = GateComponentModels.loadModel("array/signalpanel");
    public static final CCModel busInput = GateComponentModels.loadModel("array/businput");
    public static final CCModel icBundled = GateComponentModels.loadModel("array/icbundled");
    public static final Map<String, CCModel> nullCell = GateComponentModels.loadModels("array/null_cell", (k, v) -> v.apply((Transformation)new Translation(0.5, 0.0, 0.5)));
    public static final Map<String, CCModel> logicCell = GateComponentModels.loadModels("array/logic_cell", (k, v) -> v.apply((Transformation)new Translation(0.5, 0.0, 0.5)));
    public static final Map<String, CCModel> andCell = GateComponentModels.loadModels("array/and_cell", (k, v) -> v.apply((Transformation)new Translation(0.5, 0.0, 0.5)));
    public static final Map<String, CCModel> transparentLatchCell = GateComponentModels.loadModels("array/transparent_latch_cell", (k, v) -> v.apply((Transformation)new Translation(0.5, 0.0, 0.5)));
    public static final Map<String, CCModel> sevenSeg = GateComponentModels.loadModels("array/7seg");
    public static final Map<String, CCModel> sixteenSeg = GateComponentModels.loadModels("array/16seg");
    public static final CCModel segbus = GateComponentModels.loadModel("array/segbus");
    public static final Map<String, CCModel> fabIC = GateComponentModels.loadModels("fab_ic", (k, v) -> v.apply((Transformation)new Translation(0.5, 0.0, 0.5)));
    public static final Map<String, CCModel> ioRedstoneConnector = GateComponentModels.loadModels("io_redstone_connector");
    public static final Map<String, CCModel> ioBundledConnector = GateComponentModels.loadModels("io_bundled_connector");
    public static final Map<String, CCModel> ioBuffer = GateComponentModels.loadModels("io_buffer");
    public static final Map<String, CCModel> ioBundledBuffer = GateComponentModels.loadModels("io_bundled_buffer");
    public static final Map<String, CCModel> ioBundledBus = GateComponentModels.loadModels("io_bundled_bus");
    public static final Map<String, CCModel> ioPotentiometer = GateComponentModels.loadModels("io_potentiometer");
    public static IconTransformation baseIcon;
    public static IconTransformation wireBorderIcon;
    public static IconTransformation wireOffIcon;
    public static IconTransformation wireOnIcon;
    public static IconTransformation redstoneTorchOffIcon;
    public static IconTransformation redstoneTorchOnIcon;
    public static IconTransformation yellowChipOffIcon;
    public static IconTransformation yellowChipOnIcon;
    public static IconTransformation redChipOffIcon;
    public static IconTransformation redChipOnIcon;
    public static IconTransformation minusChipOffIcon;
    public static IconTransformation minusChipOnIcon;
    public static IconTransformation plusChipOffIcon;
    public static IconTransformation plusChipOnIcon;
    public static IconTransformation leverIcon;
    public static IconTransformation solarDualMode;
    public static IconTransformation solarSkyMode;
    public static IconTransformation solarBlockMode;
    public static IconTransformation rainSensorIcon;
    public static IconTransformation pointerIcon;
    public static IconTransformation busXcvrIcon;
    public static IconTransformation nullCellIcon;
    public static IconTransformation logicCellIcon;
    public static IconTransformation andCellIcon;
    public static IconTransformation transparentLatchCellIcon;
    public static IconTransformation busRandIcon;
    public static IconTransformation busConvIcon;
    public static IconTransformation busInputIcon;
    public static IconTransformation segment;
    public static IconTransformation segmentDisp;
    public static IconTransformation icChipIcon;
    public static IconTransformation icChipIconOff;
    public static IconTransformation icHousingIcon;
    public static IconTransformation ioRedstoneConnectorIcon;
    public static IconTransformation ioBundledConnectorIcon;
    public static IconTransformation ioBufferIcon;
    public static IconTransformation ioBundledBufferIcon;
    public static IconTransformation ioBundledBusIcon;
    public static IconTransformation ioPotentiometerIcon;

    public static void onTextureStitchEvent(TextureAtlasStitchedEvent event) {
        baseIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/base")));
        wireBorderIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/wire_material_border")));
        wireOffIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/wire_material_off")));
        wireOnIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/wire_material_on")));
        redstoneTorchOffIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/redstone_torch_off")));
        redstoneTorchOnIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/redstone_torch")));
        yellowChipOffIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/yellow_chip_off")));
        yellowChipOnIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/yellow_chip_on")));
        redChipOffIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/red_chip_off")));
        redChipOnIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/red_chip_on")));
        minusChipOffIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/minus_chip_off")));
        minusChipOnIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/minus_chip_on")));
        plusChipOffIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/plus_chip_off")));
        plusChipOnIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/plus_chip_on")));
        solarDualMode = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/solar_dual_mode")));
        solarSkyMode = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/solar_sky_mode")));
        solarBlockMode = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/solar_block_mode")));
        rainSensorIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/rain_sensor")));
        leverIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/lever")));
        pointerIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/pointer")));
        busXcvrIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/bus_xcvr")));
        nullCellIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/null_cell")));
        logicCellIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/logic_cell")));
        andCellIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/and_cell")));
        transparentLatchCellIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/transparent_latch_cell")));
        busRandIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/bus_randomizer")));
        busConvIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/bus_converter")));
        busInputIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/bus_input_panel")));
        segment = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/segment_display")));
        segmentDisp = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/segment_display_digit")));
        icChipIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/ic_active")));
        icChipIconOff = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/ic_inert")));
        icHousingIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/ic_housing")));
        ioRedstoneConnectorIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/io_redstone_connector")));
        ioBundledConnectorIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/io_bundled_connector")));
        ioBufferIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/io_buffer")));
        ioBundledBufferIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/io_bundled_buffer")));
        ioBundledBusIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/io_bundled_bus")));
        ioPotentiometerIcon = new IconTransformation(event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)"block/io_potentiometer")));
    }

    public static Map<String, CCModel> loadModels(String path) {
        return GateComponentModels.loadModels(path, (k, v) -> {});
    }

    public static Map<String, CCModel> loadModels(String path, BiConsumer<String, CCModel> operation) {
        Map models = new OBJParser(ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)("obj/" + path + ".obj"))).ignoreMtl().quads().parse();
        models.replaceAll((k, v) -> v.backfacedCopy());
        for (Map.Entry m : models.entrySet()) {
            operation.accept((String)m.getKey(), (CCModel)m.getValue());
            ((CCModel)m.getValue()).computeNormals();
            ((CCModel)m.getValue()).shrinkUVs(5.0E-4);
        }
        return models;
    }

    public static CCModel loadModel(String path) {
        return Objects.requireNonNull(CCModel.combine(GateComponentModels.loadModels(path).values()));
    }

    public static CCModel loadBaseModel(String path) {
        CCModel model = GateComponentModels.loadModel(path);
        model.apply((Transformation)new Translation(0.5, 0.0, 0.5));
        for (int i = 0; i < model.verts.length; ++i) {
            model.verts[i].vec.subtract(model.normals()[i].copy().multiply(2.0E-4));
        }
        return model;
    }

    public static Transformation orientT(int orient) {
        Transformation t = Rotation.sideOrientation((int)(orient % 24 >> 2), (int)(orient & 3));
        if (orient >= 24) {
            t = new Scale(-1.0, 1.0, 1.0).with(t);
        }
        return t.at(Vector3.CENTER);
    }

    public static Transformation dynamicT(int orient) {
        return orient == 0 ? RedundantTransformation.INSTANCE : new Scale(-1.0, 1.0, 1.0).at(Vector3.CENTER);
    }

    public static CCModel bakeCopy(CCModel base, int orient) {
        CCModel m = base.copy();
        if (orient >= 24) {
            GateComponentModels.reverseFacing(m);
        }
        m.apply(GateComponentModels.orientT(orient)).computeLighting(LightModel.standardLightModel);
        return m;
    }

    public static CCModel[] bakeOrients(CCModel base) {
        CCModel[] models = new CCModel[48];
        for (int i = 0; i < 48; ++i) {
            models[i] = GateComponentModels.bakeCopy(base, i);
        }
        return models;
    }

    public static CCModel[] bakeDynamic(CCModel base) {
        return new CCModel[]{base.copy(), GateComponentModels.reverseFacing(base.copy())};
    }

    public static CCModel reverseFacing(CCModel m) {
        for (int i = 0; i < m.verts.length; i += 4) {
            Vertex5 vtmp = m.verts[i + 1];
            Vector3 ntmp = m.normals()[i + 1];
            m.verts[i + 1] = m.verts[i + 3];
            m.normals()[i + 1] = m.normals()[i + 3];
            m.verts[i + 3] = vtmp;
            m.normals()[i + 3] = ntmp;
        }
        return m;
    }

    public static WireModel[] generateWireModels(String name, int count) {
        WireModel[] models = new WireModel[count];
        for (int i = 0; i < count; ++i) {
            String fullName = name + "-" + i;
            models[i] = new WireModel3D(fullName);
        }
        return models;
    }

    public static abstract class WireModel
    extends ComponentModel {
        public boolean on = false;
        public boolean disabled = false;

        public static List<Rectangle4i> rectangulate(Colour[] data) {
            boolean[] wireCorners = new boolean[1024];
            for (int y = 0; y < 30; ++y) {
                for (int x = 0; x < 31; ++x) {
                    if (data[y * 32 + x].rgba() != -1 || WireModel.overlap(wireCorners, x, y)) continue;
                    if (!WireModel.segment2by2(data, x, y)) {
                        throw new RuntimeException("Wire segment is not 2x2 at " + x + ", " + y);
                    }
                    wireCorners[y * 32 + x] = true;
                }
            }
            LinkedList<Rectangle4i> rects = new LinkedList<Rectangle4i>();
            for (int i = 0; i < wireCorners.length; ++i) {
                int dx;
                int y;
                int x;
                if (!wireCorners[i]) continue;
                Rectangle4i rect = new Rectangle4i(i % 32, i / 32, 0, 0);
                for (x = rect.x + 2; x < 30 && wireCorners[rect.y * 32 + x]; x += 2) {
                }
                rect.w = x - rect.x;
                for (y = rect.y + 2; y < 30; y += 2) {
                    boolean advance = true;
                    for (dx = rect.x; dx < rect.x + rect.w && advance; dx += 2) {
                        if (wireCorners[y * 32 + dx]) continue;
                        advance = false;
                    }
                    if (!advance) break;
                }
                rect.h = y - rect.y;
                for (int dy = rect.y; dy < rect.y + rect.h; dy += 2) {
                    for (dx = rect.x; dx < rect.x + rect.w; dx += 2) {
                        wireCorners[dy * 32 + dx] = false;
                    }
                }
                rects.add(rect);
            }
            return rects;
        }

        private static boolean overlap(boolean[] wireCorners, int x, int y) {
            return wireCorners[y * 32 + x - 1] || y > 0 && wireCorners[(y - 1) * 32 + x] || y > 0 && wireCorners[(y - 1) * 32 + x - 1];
        }

        private static boolean segment2by2(Colour[] data, int x, int y) {
            return data[y * 32 + x + 1].rgba() == -1 && data[(y + 1) * 32 + x].rgba() == -1 && data[(y + 1) * 32 + x + 1].rgba() == -1;
        }

        public static Rectangle4i border(Rectangle4i wire) {
            Rectangle4i border = new Rectangle4i(wire.x - 2, wire.y - 2, wire.w + 4, wire.h + 4);
            if (border.x < 0) {
                border.w += border.x;
                border.x = 0;
            }
            if (border.y < 0) {
                border.h += border.y;
                border.y = 0;
            }
            if (border.x + border.w >= 32) {
                border.w -= border.x + border.w - 32;
            }
            if (border.y + border.h >= 32) {
                border.h -= border.y + border.h - 32;
            }
            return border;
        }
    }

    public static class WireModel3D
    extends WireModel {
        private static final ConcurrentHashMap<String, CCModel[]> cache = new ConcurrentHashMap();
        private final String textureName;
        @Nullable
        private MultiIconTransformation wireOnIcons;
        @Nullable
        private MultiIconTransformation wireOffIcons;

        public WireModel3D(String textureName) {
            this.textureName = textureName;
        }

        protected CCModel[] models() {
            return WireModel3D.getOrGenerateModels(this.textureName);
        }

        protected UVTransformation getUVT() {
            if (this.wireOnIcons == null || this.wireOffIcons == null || this.wireOnIcons.icons[0] != GateComponentModels.wireBorderIcon.icon) {
                this.wireOnIcons = new MultiIconTransformation(new TextureAtlasSprite[]{GateComponentModels.wireBorderIcon.icon, GateComponentModels.wireOnIcon.icon});
                this.wireOffIcons = new MultiIconTransformation(new TextureAtlasSprite[]{GateComponentModels.wireBorderIcon.icon, GateComponentModels.wireOffIcon.icon});
            }
            return this.disabled ? wireBorderIcon : (this.on ? this.wireOnIcons : this.wireOffIcons);
        }

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            this.models()[orient].render(ccrs, new IVertexOperation[]{t, this.getUVT()});
        }

        public static void regenerateModels() {
            HashSet textures = new HashSet(cache.keySet());
            cache.clear();
            for (String k : textures) {
                WireModel3D.getOrGenerateModels(k);
            }
        }

        private static CCModel[] getOrGenerateModels(String textureName) {
            return cache.computeIfAbsent(textureName, WireModel3D::generateModels);
        }

        private static CCModel[] generateModels(String textureName) {
            Colour[] data = TextureUtils.loadTextureColours((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"projectred_integration", (String)("textures/block/surface/" + textureName + ".png")));
            List<Rectangle4i> rects = WireModel3D.rectangulate(data);
            CCModel model = CCModel.quadModel((int)(rects.size() * 40));
            int i = 0;
            for (Rectangle4i rect : rects) {
                WireModel3D.generateWireSegment(model, i, WireModel3D.border(rect), 0.01, 0);
                WireModel3D.generateWireSegment(model, i + 20, rect, 0.02, 1);
                i += 40;
            }
            model.computeNormals();
            model.shrinkUVs(5.0E-4);
            return GateComponentModels.bakeOrients(model);
        }

        private static void generateWireSegment(CCModel model, int i, Rectangle4i rect, double h, int icon) {
            double x1 = (double)rect.x / 32.0;
            double x2 = (double)(rect.x + rect.w) / 32.0;
            double z1 = (double)rect.y / 32.0;
            double z2 = (double)(rect.y + rect.h) / 32.0;
            double d = 4.0E-4 - h / 50.0;
            model.generateBlock(i, x1 + d, 0.125, z1 + d, x2 - d, 0.125 + h, z2 - d, 1);
            for (int v = 0; v < 20; ++v) {
                model.verts[i + v].uv.tex = icon;
            }
        }
    }

    private static class RedundantUVTransformation
    extends UVTransformation {
        public static final RedundantUVTransformation INSTANCE = new RedundantUVTransformation();

        private RedundantUVTransformation() {
        }

        public void apply(UV vec) {
        }

        public UVTransformation at(UV point) {
            return this;
        }

        public UVTransformation inverse() {
            return this;
        }

        public UVTransformation merge(UVTransformation next) {
            return next;
        }

        public boolean isRedundant() {
            return true;
        }

        public String toString() {
            return "Nothing()";
        }

        public UVTransformation copy() {
            return this;
        }
    }

    public static class IOPotentiometerModel
    extends ComponentModel {
        public int signal = 0;
        private final CCModel[] boxModels;
        private final CCModel[][] arrowModels;

        public IOPotentiometerModel(double x, double z) {
            CCModel m = ioPotentiometer.get("box").copy().apply((Transformation)new Translation(x / 16.0, 0.125, z / 16.0));
            this.boxModels = GateComponentModels.bakeOrients(m);
            this.arrowModels = new CCModel[16][];
            for (int i = 0; i < 16; ++i) {
                double angleDeg = 120.0 - (double)i * 16.0;
                m = ioPotentiometer.get("pot").copy().apply((Transformation)new Rotation(angleDeg * 0.017453292519943, 0.0, 1.0, 0.0)).apply((Transformation)new Translation(x / 16.0, 0.125, z / 16.0));
                this.arrowModels[i] = GateComponentModels.bakeOrients(m);
            }
        }

        protected UVTransformation getUVT() {
            return ioBundledBusIcon;
        }

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            this.boxModels[orient].render(ccrs, new IVertexOperation[]{t, ioPotentiometerIcon});
            this.arrowModels[this.signal][orient].render(ccrs, new IVertexOperation[]{t, ioPotentiometerIcon});
        }
    }

    public static class IOBundledBusCableModel
    extends BundledCableModel {
        public static final IOBundledBusCableModel INSTANCE = new IOBundledBusCableModel();
        private final CCModel[] boxModels;

        private IOBundledBusCableModel() {
            super(ioBundledBus.get("cable"), new Vector3(8.0, 0.0, 8.0), 0.21875, 0.375);
            Translation t = new Translation(0.5, 0.0, 0.5);
            CCModel m = ioBundledBus.get("box").copy().apply((Transformation)t);
            this.boxModels = GateComponentModels.bakeOrients(m);
        }

        @Override
        protected UVTransformation getUVT() {
            return ioBundledBusIcon;
        }

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            super.renderModel(t, orient, ccrs);
            this.boxModels[orient].render(ccrs, new IVertexOperation[]{t, this.getUVT()});
        }
    }

    public static class IOBundledBufferModel
    extends ComponentModel {
        public int colour = EnumColour.WHITE.ordinal();
        public boolean isInput = true;
        public boolean showInsulated = true;
        private final CCModel[] boxModels;
        private final CCModel[] insulatedWireModels;
        private final CCModel[] inputArrowModels;
        private final CCModel[] outputArrowModels;
        private final CCModel[][] selectorModels;

        public IOBundledBufferModel(double x, double z) {
            Translation t = new Translation(x / 16.0, 0.125, z / 16.0);
            CCModel m = ioBundledBuffer.get("box").copy().apply((Transformation)t);
            this.boxModels = GateComponentModels.bakeOrients(m);
            m = ioBundledBuffer.get("insulated_wire").copy().apply((Transformation)t);
            this.insulatedWireModels = GateComponentModels.bakeOrients(m);
            m = ioBundledBuffer.get("arrow").copy().apply((Transformation)t);
            this.inputArrowModels = GateComponentModels.bakeOrients(m);
            m = ioBundledBuffer.get("arrow").copy().apply((Transformation)new Rotation(3.1415926535897403, 0.0, 1.0, 0.0)).apply((Transformation)t);
            this.outputArrowModels = GateComponentModels.bakeOrients(m);
            this.selectorModels = new CCModel[16][];
            for (int i = 0; i < 16; ++i) {
                double xPos = -3.75 + (double)i * 0.5;
                m = ioBundledBuffer.get("selector").copy().apply((Transformation)new Translation(xPos / 16.0, 0.0, 0.0)).apply((Transformation)t);
                this.selectorModels[i] = GateComponentModels.bakeOrients(m);
            }
        }

        private UVTransformation getColourUVT() {
            return new UVTranslation((double)(this.colour % 2 * 4) / 32.0, (double)(this.colour / 2 * 4) / 32.0).with((UVTransformation)ioBundledBufferIcon);
        }

        private UVTransformation getBoxUVT() {
            return ioBundledBufferIcon;
        }

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            this.boxModels[orient].render(ccrs, new IVertexOperation[]{t, this.getBoxUVT()});
            this.selectorModels[this.colour][orient].render(ccrs, new IVertexOperation[]{t, this.getBoxUVT()});
            (this.isInput ? this.inputArrowModels : this.outputArrowModels)[orient].render(ccrs, new IVertexOperation[]{t, this.getColourUVT()});
            if (this.showInsulated) {
                this.insulatedWireModels[orient].render(ccrs, new IVertexOperation[]{t, this.getColourUVT()});
            }
        }
    }

    public static class IOBundledConnectorModel
    extends StaticComponentModel {
        public static final IOBundledConnectorModel INSTANCE = new IOBundledConnectorModel();

        private IOBundledConnectorModel() {
            super(Objects.requireNonNull(CCModel.combine(ioBundledConnector.values())).copy().apply((Transformation)new Translation(0.5, 0.125, 0.5)));
        }

        @Override
        protected UVTransformation getUVT() {
            return ioBundledConnectorIcon;
        }
    }

    public static class IOBufferModel
    extends ComponentModel {
        public int colour = EnumColour.WHITE.ordinal();
        public boolean isInput = true;
        private final CCModel[] boxModels;
        private final CCModel[] inputArrowModels;
        private final CCModel[] outputArrowModels;

        public IOBufferModel(double x, double z) {
            Translation t = new Translation(x / 16.0, 0.125, z / 16.0);
            CCModel m = ioBuffer.get("box").copy().apply((Transformation)t);
            this.boxModels = GateComponentModels.bakeOrients(m);
            m = ioBuffer.get("arrow").copy().apply((Transformation)t);
            this.inputArrowModels = GateComponentModels.bakeOrients(m);
            m = ioBuffer.get("arrow").copy().apply((Transformation)new Rotation(3.1415926535897403, 0.0, 1.0, 0.0)).apply((Transformation)t);
            this.outputArrowModels = GateComponentModels.bakeOrients(m);
        }

        private UVTransformation getColourUVT() {
            return new UVTranslation((double)(this.colour % 2 * 4) / 32.0, (double)(this.colour / 2 * 4) / 32.0).with((UVTransformation)ioBufferIcon);
        }

        private UVTransformation getBoxUVT() {
            return ioBufferIcon;
        }

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            this.boxModels[orient].render(ccrs, new IVertexOperation[]{t, this.getBoxUVT()});
            (this.isInput ? this.inputArrowModels : this.outputArrowModels)[orient].render(ccrs, new IVertexOperation[]{t, this.getColourUVT()});
        }
    }

    public static class IORedstoneConnectorWireModel
    extends CellWireModel {
        private static final CCModel[] models = GateComponentModels.bakeOrients(ioRedstoneConnector.get("redalloy").copy().apply((Transformation)new Translation(0.5, 0.125, 0.5)));

        private IconTransformation getUVT() {
            return ioRedstoneConnectorIcon;
        }

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            models[orient].render(ccrs, new IVertexOperation[]{t, this.getUVT(), this.colourMult()});
        }
    }

    public static class IORedstoneConnectorModel
    extends StaticComponentModel {
        public static final IORedstoneConnectorModel INSTANCE = new IORedstoneConnectorModel();

        private IORedstoneConnectorModel() {
            super(ioRedstoneConnector.get("connector").copy().apply((Transformation)new Translation(0.5, 0.125, 0.5)));
        }

        @Override
        protected UVTransformation getUVT() {
            return ioRedstoneConnectorIcon;
        }
    }

    public static class FabricatedICModel
    extends ComponentModel {
        public static final FabricatedICModel INSTANCE = new FabricatedICModel();
        private static final Style UNIFORM = Style.EMPTY.withFont(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"uniform"));
        private static final CCModel[] platformModel = GateComponentModels.bakeOrients(fabIC.get("platform"));
        private static final CCModel[] icChipModel = GateComponentModels.bakeOrients(fabIC.get("ic"));

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            platformModel[orient].render(ccrs, new IVertexOperation[]{t, icHousingIcon});
            icChipModel[orient].render(ccrs, new IVertexOperation[]{t, icChipIcon});
        }

        public void renderName(String name, Transformation t1, PoseStack mStack, MultiBufferSource bufferSource, int argb, int packedLight) {
            MutableComponent nameComponent = Component.literal((String)name).withStyle(UNIFORM);
            Font fr = Minecraft.getInstance().font;
            int tw = fr.width((FormattedText)nameComponent);
            Objects.requireNonNull(fr);
            int th = 9;
            double wScale = 0.5 * (1.0 / (double)tw);
            double hScale = 0.125 * (1.0 / (double)th);
            double scale = Math.min(wScale, hScale);
            TransformationList t = new Rotation(1.5707963267948701, 1.0, 0.0, 0.0).with((Transformation)new Scale(scale, 1.0, scale)).with((Transformation)new Translation(0.5, 0.14063125, 0.71875)).with((Transformation)new Translation(-((double)tw / 2.0) * scale, 0.0, -((double)th / 2.0) * scale)).with(t1);
            Matrix4 m = new Matrix4();
            t.apply(m);
            mStack.pushPose();
            mStack.mulPose(m.toMatrix4f());
            fr.drawInBatch((Component)nameComponent, 0.0f, 0.0f, argb, false, mStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
            mStack.popPose();
        }

        public void renderGlass(Transformation t, CCRenderState ccrs) {
            fabIC.get("glass").render(ccrs, new IVertexOperation[]{t, icHousingIcon});
        }
    }

    public static class SidedWireModel
    extends ComponentModel {
        public int sidemask = 0;
        public final WireModel[] wires;

        public SidedWireModel(WireModel[] wires) {
            this.wires = wires;
        }

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            for (int r = 0; r < 4; ++r) {
                if ((this.sidemask & 1 << r) == 0) continue;
                this.wires[r].renderModel(t, orient, ccrs);
            }
        }
    }

    public static class SidedICBundledCableModel
    extends BundledCableModel {
        public int sidemask = 0;

        public SidedICBundledCableModel() {
            super(icBundled, new Vector3(8.0, 0.0, 8.0), 0.21875, 0.375);
        }

        @Override
        protected UVTransformation getUVT() {
            return busConvIcon;
        }

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            for (int r = 0; r < 4; ++r) {
                if ((this.sidemask & 1 << r) == 0) continue;
                super.renderModel(t, orient & 0xFC | ((orient & 3) + r) % 4, ccrs);
            }
        }
    }

    public static class SegmentDisplayBusCableModel
    extends BundledCableModel {
        public static final SegmentDisplayBusCableModel INSTANCE = new SegmentDisplayBusCableModel();

        private SegmentDisplayBusCableModel() {
            super(segbus, new Vector3(8.0, 0.0, 8.0), 0.28125, 0.515625);
        }

        @Override
        protected UVTransformation getUVT() {
            return segment;
        }
    }

    public static class SixteenSegmentDisplayModel
    extends SegmentDisplayModel {
        public SixteenSegmentDisplayModel(double x, double z) {
            super(x, z, sixteenSeg);
        }

        @Override
        protected UVTransformation getUVT() {
            return segment;
        }

        @Override
        protected UVTransformation getSegmentUVT() {
            return segmentDisp;
        }
    }

    public static class SevenSegmentDisplayModel
    extends SegmentDisplayModel {
        public SevenSegmentDisplayModel(double x, double z) {
            super(x, z, sevenSeg);
        }

        @Override
        protected UVTransformation getUVT() {
            return segment;
        }

        @Override
        protected UVTransformation getSegmentUVT() {
            return segmentDisp;
        }
    }

    public static abstract class SegmentDisplayModel
    extends SingleComponentModel {
        private final Transformation dPos;
        private final int segmentCount;
        private final CCModel[] models;
        private final CCModel[] segmentModels;
        public int signal = 0;
        public int onColour = EnumColour.RED.rgba();
        public final int offColour = EnumColour.BLACK.rgba();

        public SegmentDisplayModel(double x, double z, Map<String, CCModel> modelMap) {
            this.dPos = new Vector3(x, 0.0, z).multiply(0.0625).translation();
            this.segmentCount = modelMap.size() - 1;
            this.models = GateComponentModels.bakeOrients(modelMap.get("base").copy().apply(this.dPos));
            this.segmentModels = new CCModel[this.segmentCount];
            for (int i = 0; i < this.segmentCount; ++i) {
                this.segmentModels[i] = modelMap.get(String.valueOf(i));
            }
        }

        public void setColourByIndex(int index) {
            this.onColour = EnumColour.values()[index].rgba();
        }

        @Override
        protected CCModel[] models() {
            return this.models;
        }

        protected abstract UVTransformation getSegmentUVT();

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            super.renderModel(t, orient, ccrs);
            UVTransformation iconT = this.getSegmentUVT();
            TransformationList dispT = this.dPos.with(GateComponentModels.orientT(orient % 24)).with(t);
            for (int i = 0; i < this.segmentCount; ++i) {
                this.segmentModels[i].render(ccrs, new IVertexOperation[]{dispT, iconT, PlanarLightModel.standardLightModel, ColourMultiplier.instance((int)((this.signal & 1 << i) != 0 ? this.onColour : this.offColour))});
            }
        }
    }

    public static class TransparentLatchCellBaseModel
    extends StaticComponentModel {
        private static final CCModel transparentLatchCellBaseModel = Objects.requireNonNull(CCModel.combine((Collection)ImmutableSet.of((Object)transparentLatchCell.get("base"), (Object)transparentLatchCell.get("frame"))));
        public static final TransparentLatchCellBaseModel INSTANCE = new TransparentLatchCellBaseModel();

        private TransparentLatchCellBaseModel() {
            super(transparentLatchCellBaseModel);
        }

        @Override
        protected UVTransformation getUVT() {
            return transparentLatchCellIcon;
        }
    }

    public static class TransparentLatchCellTopWireModel
    extends CellTopWireModel {
        private static final CCModel[] leftModels;
        private static final CCModel[] rightModels;
        private static final CCModel[] topModels;

        public TransparentLatchCellTopWireModel() {
            super(leftModels, rightModels, topModels);
        }

        @Override
        protected UVTransformation getIconT() {
            return transparentLatchCellIcon;
        }

        static {
            topModels = GateComponentModels.bakeOrients(transparentLatchCell.get("top_wire"));
            leftModels = GateComponentModels.bakeOrients(transparentLatchCell.get("left_wire"));
            rightModels = GateComponentModels.bakeOrients(transparentLatchCell.get("right_wire"));
        }
    }

    public static class AndCellBaseModel
    extends StaticComponentModel {
        private static final CCModel andCellBaseModel = Objects.requireNonNull(CCModel.combine((Collection)ImmutableSet.of((Object)andCell.get("base"), (Object)andCell.get("frame"), (Object)andCell.get("plate"))));
        public static final AndCellBaseModel INSTANCE = new AndCellBaseModel();

        private AndCellBaseModel() {
            super(andCellBaseModel);
        }

        @Override
        protected UVTransformation getUVT() {
            return andCellIcon;
        }
    }

    public static class AndCellTopWireModel
    extends CellTopWireModel {
        private static final CCModel[] leftModels;
        private static final CCModel[] rightModels;
        private static final CCModel[] topModels;

        public AndCellTopWireModel() {
            super(leftModels, rightModels, topModels);
        }

        @Override
        protected UVTransformation getIconT() {
            return andCellIcon;
        }

        static {
            topModels = GateComponentModels.bakeOrients(andCell.get("top_wire"));
            leftModels = GateComponentModels.bakeOrients(andCell.get("left_wire"));
            rightModels = GateComponentModels.bakeOrients(andCell.get("right_wire"));
        }
    }

    public static class LogicCellBaseModel
    extends StaticComponentModel {
        private static final CCModel logicCellBaseModel = Objects.requireNonNull(CCModel.combine((Collection)ImmutableSet.of((Object)logicCell.get("base"), (Object)logicCell.get("frame"), (Object)logicCell.get("plate"))));
        public static final LogicCellBaseModel INSTANCE = new LogicCellBaseModel();

        private LogicCellBaseModel() {
            super(logicCellBaseModel);
        }

        @Override
        protected UVTransformation getUVT() {
            return logicCellIcon;
        }
    }

    public static class LogicCellBottomWireModel
    extends CellBottomWireModel {
        private static final CCModel[] bottomWireModels = GateComponentModels.bakeOrients(logicCell.get("bottom_wire"));

        public LogicCellBottomWireModel() {
            super(bottomWireModels);
        }

        @Override
        protected UVTransformation getIconT() {
            return logicCellIcon;
        }
    }

    public static class LogicCellTopWireModel
    extends CellTopWireModel {
        private static final CCModel[] leftModels;
        private static final CCModel[] rightModels;
        private static final CCModel[] topModels;

        public LogicCellTopWireModel() {
            super(leftModels, rightModels, topModels);
        }

        @Override
        protected UVTransformation getIconT() {
            return nullCellIcon;
        }

        static {
            topModels = GateComponentModels.bakeOrients(logicCell.get("top_wire"));
            leftModels = GateComponentModels.bakeOrients(logicCell.get("left_wire"));
            rightModels = GateComponentModels.bakeOrients(logicCell.get("right_wire"));
        }
    }

    public static class NullCellBaseModel
    extends StaticComponentModel {
        private static final CCModel nullCellBaseModel = Objects.requireNonNull(CCModel.combine((Collection)ImmutableSet.of((Object)nullCell.get("base"), (Object)nullCell.get("frame"))));
        public static final NullCellBaseModel INSTANCE = new NullCellBaseModel();

        private NullCellBaseModel() {
            super(nullCellBaseModel);
        }

        @Override
        protected UVTransformation getUVT() {
            return nullCellIcon;
        }
    }

    public static class NullCellBottomWireModel
    extends CellBottomWireModel {
        private static final CCModel[] bottomWireModels = GateComponentModels.bakeOrients(nullCell.get("bottom_wire"));

        public NullCellBottomWireModel() {
            super(bottomWireModels);
        }

        @Override
        protected UVTransformation getIconT() {
            return nullCellIcon;
        }
    }

    public static class NullCellTopWireModel
    extends CellTopWireModel {
        private static final CCModel[] leftModels;
        private static final CCModel[] rightModels;
        private static final CCModel[] topModels;

        public NullCellTopWireModel() {
            super(leftModels, rightModels, topModels);
        }

        @Override
        protected UVTransformation getIconT() {
            return nullCellIcon;
        }

        static {
            topModels = GateComponentModels.bakeOrients(nullCell.get("top_wire"));
            leftModels = GateComponentModels.bakeOrients(nullCell.get("left_wire"));
            rightModels = GateComponentModels.bakeOrients(nullCell.get("right_wire"));
        }
    }

    public static abstract class CellBottomWireModel
    extends CellWireModel {
        private final CCModel[] models;

        public CellBottomWireModel(CCModel[] models) {
            this.models = models;
        }

        protected abstract UVTransformation getIconT();

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            this.models[orient].render(ccrs, new IVertexOperation[]{t, this.getIconT(), this.colourMult()});
        }
    }

    public static abstract class CellTopWireModel
    extends CellWireModel {
        private final CCModel[] leftModels;
        private final CCModel[] rightModels;
        private final CCModel[] topModels;
        public int conn = 0;

        public CellTopWireModel(CCModel[] leftModels, CCModel[] rightModels, CCModel[] topModels) {
            this.leftModels = leftModels;
            this.rightModels = rightModels;
            this.topModels = topModels;
        }

        protected abstract UVTransformation getIconT();

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            this.topModels[orient].render(ccrs, new IVertexOperation[]{t, this.getIconT(), this.colourMult()});
            if ((this.conn & 2) == 0) {
                this.rightModels[orient].render(ccrs, new IVertexOperation[]{t, this.getIconT(), this.colourMult()});
            }
            if ((this.conn & 8) == 0) {
                this.leftModels[orient].render(ccrs, new IVertexOperation[]{t, this.getIconT(), this.colourMult()});
            }
        }
    }

    public static abstract class CellWireModel
    extends ComponentModel {
        public byte signal = 0;

        protected int signalColour(byte signal) {
            return (signal & 0xFF) / 2 + 60 << 24 | 0xFF;
        }

        protected IVertexOperation colourMult() {
            return ColourMultiplier.instance((int)this.signalColour(this.signal));
        }
    }

    public static class InputPanelButtonsModel
    extends ComponentModel {
        private static final Cuboid6[] UNPRESSED_BOXES = VecLib.buildCubeArray((int)4, (int)4, (Cuboid6)new Cuboid6(3.0, 1.0, 3.0, 13.0, 3.0, 13.0), (Vector3)new Vector3(-0.25, 0.0, -0.25));
        private static final Cuboid6[] PRESSED_BOXES = VecLib.buildCubeArray((int)4, (int)4, (Cuboid6)new Cuboid6(3.0, 1.0, 3.0, 13.0, 2.5, 13.0), (Vector3)new Vector3(-0.25, 0.0, -0.25));
        private static final Cuboid6[] LIGHT_BOXES = VecLib.buildCubeArray((int)4, (int)4, (Cuboid6)new Cuboid6(3.0, 1.0, 3.0, 13.0, 2.5, 13.0), (Vector3)new Vector3(-0.25, 0.0, -0.25).add(0.2));
        public int pressMask = 0;

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            IconTransformation iconT = baseIcon;
            for (int i = 0; i < 16; ++i) {
                ccrs.setPipeline(new IVertexOperation[]{PlanarLightModel.standardLightModel, GateComponentModels.orientT(orient).with(t), iconT, ColourMultiplier.instance((int)EnumColour.values()[i].rgba())});
                BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)((this.pressMask & 1 << i) != 0 ? PRESSED_BOXES : UNPRESSED_BOXES)[i], (int)1);
            }
        }

        public void renderLights(CCRenderState ccrs, BlockPos lightPos, PoseStack mStack, MultiBufferSource buffers, Transformation t) {
            TransformationList t2 = t.with((Transformation)new Translation((Vec3i)lightPos));
            for (int i = 0; i < 16; ++i) {
                if ((this.pressMask & 1 << i) == 0) continue;
                HaloRenderer.addLight((Transformation)t2, (Cuboid6)LIGHT_BOXES[i], (int)i);
            }
        }
    }

    public static class SignalBarModel
    extends ComponentModel {
        private final CCModel[] models;
        private final CCModel[] bars = new CCModel[16];
        private final CCModel[] barsInv = new CCModel[16];
        private final CCModel barsBg;
        private final CCModel barsBgInv;
        private final Vector3 pos;
        public int signal = 0;
        public boolean inverted = false;

        public SignalBarModel(double x, double z) {
            this.pos = new Vector3(x, 0.0, z).multiply(0.0625);
            for (int i = 0; i < 16; ++i) {
                CCModel bar = CCModel.quadModel((int)4);
                double y = 0.3751;
                bar.verts[0] = new Vertex5(0.0, y, 0.0, 0.0, 0.0);
                bar.verts[1] = new Vertex5(0.0, y, (double)(i + 1), 0.0, (double)(i + 1));
                bar.verts[2] = new Vertex5(1.0, y, (double)(i + 1), 2.0, (double)(i + 1));
                bar.verts[3] = new Vertex5(1.0, y, 0.0, 2.0, 0.0);
                bar.apply((UVTransformation)new UVTranslation(22.0, 0.0));
                bar.apply((UVTransformation)new UVScale(0.03125, 0.0078125));
                bar.shrinkUVs(5.0E-4);
                CCModel bar1 = bar.backfacedCopy();
                bar1.apply((Transformation)new Translation(-0.5, 0.0, -12.0));
                bar1.apply((Transformation)new Scale(0.0625, 1.0, -0.015625));
                bar1.computeNormals();
                CCModel bar2 = bar.copy();
                bar2.apply((Transformation)new Translation(-0.5, 0.0, -5.0));
                bar2.apply((Transformation)new Scale(0.0625, 1.0, 0.015625));
                bar2.computeNormals();
                this.bars[i] = bar1;
                this.barsInv[i] = bar2;
            }
            Scale t = new Scale(1.5, 0.9999, 1.125);
            this.barsBg = this.bars[15].copy().apply((Transformation)t);
            this.barsBgInv = this.barsInv[15].copy().apply((Transformation)t);
            CCModel base = signalPanel.copy().apply((Transformation)this.pos.translation());
            this.models = GateComponentModels.bakeOrients(base);
        }

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            IconTransformation iconT = busConvIcon;
            this.models[orient].render(ccrs, new IVertexOperation[]{t, iconT});
            TransformationList position = this.pos.translation().with(GateComponentModels.orientT(orient % 24)).with(t);
            CCModel bgModel = this.inverted ? this.barsBgInv : this.barsBg;
            CCModel barsModel = (this.inverted ? this.barsInv : this.bars)[this.signal];
            bgModel.render(ccrs, new IVertexOperation[]{position, iconT, PlanarLightModel.standardLightModel, ColourMultiplier.instance((int)0x535353FF)});
            barsModel.render(ccrs, new IVertexOperation[]{position, iconT, PlanarLightModel.standardLightModel, ColourMultiplier.instance((int)-335544065)});
        }
    }

    public static class SignalPanelModel
    extends ComponentModel {
        private final Vector3 pos;
        private final int r;
        private final CCModel[] displayModels;
        private final CCModel[] models;
        private final CCModel[] modelsSI;
        public final boolean sideIndicator = true;
        public int signal = 0;
        public int disableMask = 0;
        public int offColour = 1107296511;
        public int onColour = -335544065;
        public final int disableColour = EnumColour.GRAY.rgba();

        public SignalPanelModel(double x, double z, int r) {
            this(new Vector3(x, 0.0, z), r);
        }

        public SignalPanelModel(Vector3 pos, int r) {
            this.pos = pos.copy().multiply(0.0625);
            this.r = r;
            this.displayModels = new CCModel[16];
            for (int i = 0; i < 16; ++i) {
                CCModel m = CCModel.quadModel((int)4);
                int x = i % 4;
                int z = i / 4;
                double y = 0.3126;
                m.verts[0] = new Vertex5((double)x, y, (double)(z + 1), (double)x, (double)z);
                m.verts[1] = new Vertex5((double)(x + 1), y, (double)(z + 1), (double)(x + 1), (double)z);
                m.verts[2] = new Vertex5((double)(x + 1), y, (double)z, (double)(x + 1), (double)(z + 1));
                m.verts[3] = new Vertex5((double)x, y, (double)z, (double)x, (double)(z + 1));
                m.apply((Transformation)new Scale(0.0625, 1.0, 0.0625).with((Transformation)new Translation(-0.125, 0.0, -0.125)));
                m.apply((UVTransformation)new UVTranslation(22.0, 0.0));
                m.apply((UVTransformation)new UVScale(0.03125));
                m.computeNormals();
                m.shrinkUVs(5.0E-4);
                this.displayModels[i] = m;
            }
            CCModel base = lightPanel2.copy().apply(Rotation.quarterRotations[r]).apply((Transformation)this.pos.translation());
            CCModel baseSI = lightPanel1.copy().apply(Rotation.quarterRotations[r]).apply((Transformation)this.pos.translation());
            this.models = GateComponentModels.bakeOrients(base);
            this.modelsSI = GateComponentModels.bakeOrients(baseSI);
        }

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            IconTransformation iconT = busXcvrIcon;
            this.modelsSI[orient].render(ccrs, new IVertexOperation[]{t, iconT});
            Vector3 dPos = this.pos.copy();
            if (orient >= 24) {
                dPos.x = 1.0 - dPos.x;
            }
            TransformationList dispT = Rotation.quarterRotations[this.r].with((Transformation)dPos.translation()).with(GateComponentModels.orientT(orient % 24)).with(t);
            for (int i = 0; i < 16; ++i) {
                int colour = (this.signal & 1 << i) != 0 ? this.onColour : ((this.disableMask & 1 << i) != 0 ? this.disableColour : this.offColour);
                this.displayModels[i].render(ccrs, new IVertexOperation[]{dispT, iconT, PlanarLightModel.standardLightModel, ColourMultiplier.instance((int)colour)});
            }
        }
    }

    public static class BusInputPanelCableModel
    extends BundledCableModel {
        public static final BusInputPanelCableModel INSTANCE = new BusInputPanelCableModel();

        private BusInputPanelCableModel() {
            super(busInput, new Vector3(8.0, 0.0, 8.0), 0.5, 0.5);
        }

        @Override
        protected UVTransformation getUVT() {
            return busInputIcon;
        }
    }

    public static class BusConvCableModel
    extends BundledCableModel {
        public static final BusConvCableModel INSTANCE = new BusConvCableModel();

        private BusConvCableModel() {
            super(busConv, new Vector3(8.0, 0.0, 8.0), 0.21875, 0.375);
        }

        @Override
        protected UVTransformation getUVT() {
            return busConvIcon;
        }
    }

    public static class BusRandCableModel
    extends BundledCableModel {
        public static final BusRandCableModel INSTANCE = new BusRandCableModel();

        private BusRandCableModel() {
            super(busRand, new Vector3(8.0, 0.0, 8.0), 0.21875, 0.375);
        }

        @Override
        protected UVTransformation getUVT() {
            return busRandIcon;
        }
    }

    public static class BusXcvrCableModel
    extends BundledCableModel {
        public static final BusXcvrCableModel INSTANCE = new BusXcvrCableModel();

        private BusXcvrCableModel() {
            super(busXcvr, new Vector3(8.0, 0.0, 8.0), 0.3125, 0.4375);
        }

        @Override
        protected UVTransformation getUVT() {
            return busXcvrIcon;
        }
    }

    public static abstract class BundledCableModel
    extends SingleComponentModel {
        private final CCModel[] models = new CCModel[48];

        public BundledCableModel(CCModel model, Vector3 pos, double uCenter, double vCenter) {
            Translation p = pos.copy().multiply(0.0625).translation();
            CCModel translatedModel = model.copy().apply((Transformation)p);
            for (int orient = 0; orient < 48; ++orient) {
                this.models[orient] = GateComponentModels.bakeCopy(translatedModel, orient);
                int side = orient % 24 >> 2;
                int r = orient & 3;
                boolean reflect = orient >= 24;
                boolean rotate = (r + BundledSignalsLib.bundledCableBaseRotationMap[side]) % 4 >= 2;
                RedundantUVTransformation t = RedundantUVTransformation.INSTANCE;
                if (reflect) {
                    t = t.with((UVTransformation)new UVScale(-1.0, 1.0));
                }
                if (rotate) {
                    t = t.with((UVTransformation)new UVRotation(3.1415926535897403));
                }
                this.models[orient].apply(t.at(new UV(uCenter, vCenter)));
            }
        }

        @Override
        protected CCModel[] models() {
            return this.models;
        }
    }

    public static class PointerModel
    extends ComponentModel {
        private final CCModel[] models;
        private final Vector3 position;
        public double angle = 0.0;

        public PointerModel(double x, double y, double z, double scale) {
            this.models = GateComponentModels.bakeDynamic(pointer.copy().apply((Transformation)new Scale(scale, 1.0, scale)));
            this.position = new Vector3(x, y - 1.0, z).multiply(0.0625);
        }

        public PointerModel(double x, double y, double z) {
            this(x, y, z, 1.0);
        }

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            this.models[orient].render(ccrs, new IVertexOperation[]{new Rotation(-this.angle + Math.PI, 0.0, 1.0, 0.0).with((Transformation)this.position.translation()).with(GateComponentModels.dynamicT(orient)).with(t), pointerIcon, LightModel.standardLightModel});
        }
    }

    public static class RainSensorModel
    extends SingleComponentModel {
        private static final StaticModelComponentBakery bakery = new StaticModelComponentBakery(rainSensor);
        private final CCModel[] models;

        public RainSensorModel(double x, double z) {
            this.models = bakery.getOrCreateModel(x, z, 0);
        }

        @Override
        protected CCModel[] models() {
            return this.models;
        }

        @Override
        protected UVTransformation getUVT() {
            return rainSensorIcon;
        }
    }

    public static class SolarModel
    extends StateIconModel {
        private static final StaticModelComponentBakery bakery = new StaticModelComponentBakery(solarArray);
        private final CCModel[] models;

        public SolarModel(double x, double z) {
            this.models = bakery.getOrCreateModel(x, z, 0);
        }

        @Override
        protected CCModel[] models() {
            return this.models;
        }

        @Override
        protected UVTransformation getUVT() {
            return this.state == 0 ? solarDualMode : (this.state == 1 ? solarSkyMode : solarBlockMode);
        }
    }

    public static class PlusChipModel
    extends LightChipModel {
        public PlusChipModel(double x, double z) {
            super(x, z);
        }

        @Override
        protected UVTransformation getUVT() {
            return this.on ? plusChipOnIcon : plusChipOffIcon;
        }
    }

    public static class MinusChipModel
    extends LightChipModel {
        public MinusChipModel(double x, double z) {
            super(x, z);
        }

        @Override
        protected UVTransformation getUVT() {
            return this.on ? minusChipOnIcon : minusChipOffIcon;
        }
    }

    public static class RedChipModel
    extends LightChipModel {
        public RedChipModel(double x, double z) {
            super(x, z);
        }

        @Override
        protected UVTransformation getUVT() {
            return this.on ? redChipOnIcon : redChipOffIcon;
        }
    }

    public static class YellowChipModel
    extends LightChipModel {
        public YellowChipModel(double x, double z) {
            super(x, z);
        }

        @Override
        protected UVTransformation getUVT() {
            return this.on ? yellowChipOnIcon : yellowChipOffIcon;
        }
    }

    public static abstract class LightChipModel
    extends OnOffModel {
        private static final StaticModelComponentBakery bakery = new StaticModelComponentBakery(lightChip);
        private final CCModel[] models;

        public LightChipModel(double x, double z) {
            this.models = bakery.getOrCreateModel(x, z, 0);
        }

        @Override
        protected CCModel[] models() {
            return this.models;
        }
    }

    public static class LeverModel
    extends MultiComponentModel {
        private static final MultiModelComponentBakery bakery = new MultiModelComponentBakery(new CCModel[]{leverOn, leverOff});
        private final CCModel[][] models;

        public LeverModel(double x, double z) {
            this.models = new CCModel[][]{bakery.getOrCreateModel(x, z, 0), bakery.getOrCreateModel(x, z, 1)};
        }

        @Override
        protected CCModel[] models(int state) {
            return this.models[state];
        }

        @Override
        protected UVTransformation getUVT() {
            return leverIcon;
        }
    }

    public static class FlippedRedstoneTorchModel
    extends OnOffModel
    implements IRedstoneTorchComponentModel {
        private final CCModel[] models;
        private final Vector3 lightPos;

        public FlippedRedstoneTorchModel(double x, double y, double z, int h) {
            this.models = GateComponentModels.bakeOrients(RedstoneTorchComponentBakery.generateFlippedModel(x, y, z, h));
            this.lightPos = new Vector3(x, y - (double)h, z).multiply(0.0625);
        }

        @Override
        protected CCModel[] models() {
            return this.models;
        }

        @Override
        protected UVTransformation getUVT() {
            return this.on ? redstoneTorchOnIcon : redstoneTorchOffIcon;
        }

        @Override
        public boolean isLit() {
            return this.on;
        }

        @Override
        public Vector3 getLightPos() {
            return this.lightPos;
        }
    }

    public static class RedstoneTorchModel
    extends OnOffModel
    implements IRedstoneTorchComponentModel {
        private static final RedstoneTorchComponentBakery bakery = new RedstoneTorchComponentBakery();
        private final CCModel[] models;
        private final Vector3 lightPos;

        public RedstoneTorchModel(double x, double z, int h) {
            this.models = bakery.getOrCreateModel(x, z, h);
            this.lightPos = new Vector3(x, (double)(h - 1), z).multiply(0.0625);
        }

        @Override
        protected CCModel[] models() {
            return this.models;
        }

        @Override
        protected UVTransformation getUVT() {
            return this.on ? redstoneTorchOnIcon : redstoneTorchOffIcon;
        }

        @Override
        public boolean isLit() {
            return this.on;
        }

        @Override
        public Vector3 getLightPos() {
            return this.lightPos;
        }
    }

    public static interface IRedstoneTorchComponentModel {
        public boolean isLit();

        public Vector3 getLightPos();
    }

    public static class BaseComponentModel
    extends StaticComponentModel {
        public static final BaseComponentModel INSTANCE = new BaseComponentModel();

        private BaseComponentModel() {
            super(base);
        }

        @Override
        protected UVTransformation getUVT() {
            return baseIcon;
        }
    }

    public static abstract class StateIconModel
    extends SingleComponentModel {
        public int state = 0;
    }

    public static abstract class OnOffModel
    extends SingleComponentModel {
        public boolean on = false;
    }

    public static abstract class MultiComponentModel
    extends ComponentModel {
        public int state = 0;

        protected abstract CCModel[] models(int var1);

        protected abstract UVTransformation getUVT();

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            this.models(this.state)[orient].render(ccrs, new IVertexOperation[]{t, this.getUVT()});
        }
    }

    public static abstract class StaticComponentModel
    extends SingleComponentModel {
        private final CCModel[] models;

        public StaticComponentModel(CCModel base) {
            this.models = GateComponentModels.bakeOrients(base);
        }

        @Override
        protected CCModel[] models() {
            return this.models;
        }
    }

    public static abstract class SingleComponentModel
    extends ComponentModel {
        protected abstract CCModel[] models();

        protected abstract UVTransformation getUVT();

        @Override
        public void renderModel(Transformation t, int orient, CCRenderState ccrs) {
            this.models()[orient].render(ccrs, new IVertexOperation[]{t, this.getUVT()});
        }
    }

    public static abstract class ComponentModel {
        public abstract void renderModel(Transformation var1, int var2, CCRenderState var3);
    }

    public static class RedstoneTorchComponentBakery
    extends PositionalGateComponentModelBakery {
        public RedstoneTorchComponentBakery() {
            super(16);
        }

        @Override
        protected CCModel createBaseModel(double x, double z, int state) {
            return RedstoneTorchComponentBakery.generateModel(x, z, state);
        }

        private static CCModel generateModel(double x, double z, int h) {
            CCModel m = CCModel.quadModel((int)20);
            m.verts[0] = new Vertex5(0.4375, 0.625, 0.5625, 0.4375, 0.5);
            m.verts[1] = new Vertex5(0.5625, 0.625, 0.5625, 0.5625, 0.5);
            m.verts[2] = new Vertex5(0.5625, 0.625, 0.4375, 0.5625, 0.375);
            m.verts[3] = new Vertex5(0.4375, 0.625, 0.4375, 0.4375, 0.375);
            m.generateBlock(4, 0.375, (double)(10 - h) / 16.0, 0.4375, 0.625, 0.6875, 0.5625, 51);
            m.generateBlock(12, 0.4375, (double)(10 - h) / 16.0, 0.375, 0.5625, 0.6875, 0.625, 15);
            m.apply((Transformation)new Translation(-0.5 + x / 16.0, (double)(h - 10) / 16.0, -0.5 + z / 16.0));
            m.computeNormals();
            m.shrinkUVs(5.0E-4);
            m.apply((Transformation)new Scale(1.0005));
            return m;
        }

        private static CCModel generateFlippedModel(double x, double y, double z, int h) {
            return RedstoneTorchComponentBakery.generateModel(x, z, h).backfacedCopy().apply((Transformation)new Scale(1.0, -1.0, 1.0)).apply((Transformation)new Translation(0.0, y / 16.0, 0.0));
        }
    }

    public static class StaticModelComponentBakery
    extends PositionalGateComponentModelBakery {
        private final CCModel baseModel;

        public StaticModelComponentBakery(CCModel baseModel) {
            super(1);
            this.baseModel = baseModel;
        }

        public CCModel[] getOrCreateModel(double x, double z) {
            return super.getOrCreateModel(x, z, 0);
        }

        @Override
        protected CCModel createBaseModel(double x, double z, int state) {
            Translation t = new Translation(x / 16.0, 0.0, z / 16.0);
            return this.baseModel.copy().apply((Transformation)t);
        }
    }

    public static class MultiModelComponentBakery
    extends PositionalGateComponentModelBakery {
        private final CCModel[] baseModels;

        public MultiModelComponentBakery(CCModel[] baseModels) {
            super(baseModels.length);
            this.baseModels = baseModels;
        }

        @Override
        protected CCModel createBaseModel(double x, double z, int state) {
            Translation t = new Translation(x / 16.0, 0.0, z / 16.0);
            return this.baseModels[state].copy().apply((Transformation)t);
        }
    }

    public static abstract class PositionalGateComponentModelBakery {
        private final CCModel[][] cache;
        private final int numStates;

        public PositionalGateComponentModelBakery(int numStates) {
            this.cache = new CCModel[1024 * numStates][];
            this.numStates = numStates;
        }

        public void clearCache() {
            Arrays.fill((Object[])this.cache, null);
        }

        public CCModel[] getOrCreateModel(double x, double z, int state) {
            int key = this.modelKey(x, z, state);
            CCModel[] models = this.cache[key];
            if (models == null) {
                CCModel base = this.createBaseModel(x, z, state);
                models = GateComponentModels.bakeOrients(base);
                this.cache[key] = models;
            }
            return models;
        }

        private int modelKey(double x, double z, int state) {
            if (x / 0.5 % 1.0 != 0.0 || z / 0.5 % 1.0 != 0.0) {
                throw new IllegalArgumentException("Position (" + x + ", " + z + ") must be on a 0.5 grid");
            }
            if (x < 0.0 || x > 16.0 || z < 0.0 || z > 16.0) {
                throw new IllegalArgumentException("Position (" + x + ", " + z + ") must be in range [0, 16]");
            }
            if (state >= this.numStates) {
                throw new IllegalArgumentException("State " + state + " is out of range [0, " + this.numStates + ")");
            }
            int xi = (int)(x / 0.5);
            int zi = (int)(z / 0.5);
            return state << 10 | zi << 5 | xi;
        }

        protected abstract CCModel createBaseModel(double var1, double var3, int var5);
    }
}

