/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil;

import foundry.veil.Veil;
import foundry.veil.api.client.editor.EditorManager;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.registry.PostPipelineStageRegistry;
import foundry.veil.api.client.registry.RenderTypeLayerRegistry;
import foundry.veil.api.client.registry.RenderTypeShardRegistry;
import foundry.veil.api.client.registry.VeilResourceEditorRegistry;
import foundry.veil.api.client.registry.VeilShaderBufferRegistry;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.api.quasar.data.ParticleModuleTypeRegistry;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.quasar.registry.EmitterShapeRegistry;
import foundry.veil.api.quasar.registry.RenderStyleRegistry;
import foundry.veil.impl.client.editor.DemoInspector;
import foundry.veil.impl.client.editor.DeviceInfoViewer;
import foundry.veil.impl.client.editor.FramebufferInspector;
import foundry.veil.impl.client.editor.LightInspector;
import foundry.veil.impl.client.editor.PipelineStatisticsViewer;
import foundry.veil.impl.client.editor.PostInspector;
import foundry.veil.impl.client.editor.ResourceManagerInspector;
import foundry.veil.impl.client.editor.ShaderInspector;
import foundry.veil.impl.client.editor.TextureInspector;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManager;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferShard;
import foundry.veil.impl.quasar.QuasarParticleHandler;
import foundry.veil.impl.resource.VeilResourceManagerImpl;
import foundry.veil.platform.VeilClientPlatform;
import foundry.veil.platform.VeilEventPlatform;
import java.util.ServiceLoader;
import net.minecraft.class_1921;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_4668;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VeilClient {
    public static final class_304 EDITOR_KEY = new class_304("key.veil.editor", Veil.platform().isDevelopmentEnvironment() ? 295 : class_3675.field_16237.method_1444(), "key.categories.veil");
    private static final VeilClientPlatform PLATFORM = ServiceLoader.load(VeilClientPlatform.class).findFirst().orElseThrow(() -> new RuntimeException("Veil expected client platform implementation"));
    private static final VeilResourceManagerImpl RESOURCE_MANAGER = new VeilResourceManagerImpl();

    public static void init() {
        VeilRenderSystem.bootstrap();
        VeilImGuiImpl.setImGuiPath();
        QuasarParticleHandler.init();
        QuasarParticles.bootstrap();
        VeilEventPlatform.INSTANCE.onFreeNativeResources(() -> {
            VeilRenderSystem.close();
            RESOURCE_MANAGER.free();
        });
        VeilEventPlatform.INSTANCE.onVeilRendererAvailable(renderer -> {
            RESOURCE_MANAGER.addVeilLoaders(renderer);
            if (VeilRenderSystem.hasImGui()) {
                EditorManager editorManager = renderer.getEditorManager();
                if (Veil.platform().isDevelopmentEnvironment()) {
                    editorManager.add(new DemoInspector());
                }
                editorManager.add(new DeviceInfoViewer());
                editorManager.add(new PipelineStatisticsViewer());
                editorManager.add(new PostInspector());
                editorManager.add(new ShaderInspector());
                editorManager.add(new TextureInspector());
                editorManager.add(new LightInspector());
                editorManager.add(new FramebufferInspector());
                editorManager.add(new ResourceManagerInspector());
            }
        });
        VeilEventPlatform.INSTANCE.onVeilRegisterFixedBuffers(registry -> registry.registerFixedBuffer(VeilRenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS, class_1921.method_29380()));
        RenderTypeShardRegistry.addGenericShard(renderType -> "main_target".equals(VeilClient.getOutputName(renderType)), new DynamicBufferShard(DynamicBufferManager.MAIN_WRAPPER, () -> class_310.method_1551().method_1522()));
        RenderTypeShardRegistry.addGenericShard(renderType -> "translucent_target".equals(VeilClient.getOutputName(renderType)), new DynamicBufferShard("translucent", () -> class_310.method_1551().field_1769.method_29360()));
        RenderTypeShardRegistry.addGenericShard(renderType -> "particles_target".equals(VeilClient.getOutputName(renderType)), new DynamicBufferShard("particles", () -> class_310.method_1551().field_1769.method_29362()));
        RenderTypeShardRegistry.addGenericShard(renderType -> "weather_target".equals(VeilClient.getOutputName(renderType)), new DynamicBufferShard("weather", () -> class_310.method_1551().field_1769.method_29363()));
        RenderTypeShardRegistry.addGenericShard(renderType -> "clouds_target".equals(VeilClient.getOutputName(renderType)), new DynamicBufferShard("clouds", () -> class_310.method_1551().field_1769.method_29364()));
        RenderTypeShardRegistry.addGenericShard(renderType -> "item_entity_target".equals(VeilClient.getOutputName(renderType)), new DynamicBufferShard("item_entity", () -> class_310.method_1551().field_1769.method_29361()));
        PostPipelineStageRegistry.bootstrap();
        LightTypeRegistry.bootstrap();
        RenderTypeLayerRegistry.bootstrap();
        VeilShaderBufferRegistry.bootstrap();
        VeilResourceEditorRegistry.bootstrap();
        EmitterShapeRegistry.bootstrap();
        RenderStyleRegistry.bootstrap();
        ParticleModuleTypeRegistry.bootstrap();
    }

    private static String getOutputName(class_1921.class_4687 renderType) {
        return VeilRenderType.getName((class_4668)VeilRenderType.getShards((class_1921)renderType).outputState());
    }

    public static VeilClientPlatform clientPlatform() {
        return PLATFORM;
    }

    public static VeilResourceManagerImpl resourceManager() {
        return RESOURCE_MANAGER;
    }
}

