/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.editor;

import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.editor.ImGuiFontManager;
import foundry.veil.api.client.editor.Inspector;
import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.editor.ResourceFileEditor;
import foundry.veil.api.util.CompositeReloadListener;
import imgui.ImFont;
import imgui.ImGui;
import imgui.type.ImBoolean;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EditorManager
implements VeilEditorEnvironment,
class_3302 {
    public static final class_2960 DEFAULT_FONT = Veil.veilPath("jetbrains_mono");
    private final Map<Inspector, ImBoolean> editors = new TreeMap<Inspector, ImBoolean>(Comparator.comparing(inspector -> inspector.getClass().getSimpleName()));
    private final Map<class_2960, ResourceFileEditor<?>> resourceFileEditors = new Object2ObjectArrayMap();
    private final ImGuiFontManager fonts = new ImGuiFontManager();
    private boolean enabled = false;

    @ApiStatus.Internal
    public EditorManager(class_3304 resourceManager) {
        resourceManager.method_14477((class_3302)this);
    }

    @ApiStatus.Internal
    public void rebuildFonts() {
        this.fonts.rebuildFonts();
    }

    public ImFont getFont(class_2960 name, boolean bold, boolean italic) {
        return this.fonts.getFont(name, bold, italic);
    }

    public ImFont getFont(boolean bold, boolean italic) {
        return this.getFont(DEFAULT_FONT, bold, italic);
    }

    @ApiStatus.Internal
    public void render() {
        if (!this.enabled) {
            return;
        }
        if (ImGui.beginMainMenuBar()) {
            Inspector inspector;
            ImFont font = ImGui.getFont();
            float f = font.calcTextSizeAX((float)ImGui.getFontSize(), Float.MAX_VALUE, 0.0f, " Veil ") + 1.0f;
            float dingleHeight = ImGui.getTextLineHeightWithSpacing() + 6.0f;
            ImGui.getWindowDrawList().addRectFilled(0.0f, 0.0f, f, dingleHeight, ImGui.getColorU32((int)8));
            ImGui.text((String)"Veil ");
            for (Map.Entry<Inspector, ImBoolean> entry : this.editors.entrySet()) {
                inspector = entry.getKey();
                class_2561 group = inspector.getGroup();
                if (group == null) {
                    if (Veil.platform().isDevelopmentEnvironment()) {
                        Veil.LOGGER.error("Editor '{}' should return Editor#DEFAULT_GROUP instead of null", inspector.getClass());
                    }
                    group = Inspector.DEFAULT_GROUP;
                }
                if (!ImGui.beginMenu((String)group.getString())) continue;
                ImBoolean enabled = entry.getValue();
                ImGui.beginDisabled((!inspector.isEnabled() ? 1 : 0) != 0);
                if (ImGui.menuItem((String)inspector.getDisplayName().getString(), null, (boolean)enabled.get())) {
                    if (!enabled.get()) {
                        this.show(inspector);
                    } else {
                        this.hide(inspector);
                    }
                }
                ImGui.endDisabled();
                ImGui.endMenu();
            }
            for (Map.Entry<Inspector, ImBoolean> entry : this.editors.entrySet()) {
                inspector = entry.getKey();
                if (!entry.getValue().get() || !inspector.isMenuBarEnabled()) continue;
                ImGui.separator();
                ImGui.textColored((int)-5592406, (String)inspector.getDisplayName().getString());
                inspector.renderMenuBar();
            }
            ImGui.endMainMenuBar();
        }
        for (Map.Entry entry : this.editors.entrySet()) {
            Inspector inspector = (Inspector)entry.getKey();
            ImBoolean enabled = (ImBoolean)entry.getValue();
            if (!inspector.isEnabled()) {
                enabled.set(false);
            }
            if (!enabled.get()) continue;
            inspector.render();
        }
        Iterator<ResourceFileEditor<?>> iterator = this.resourceFileEditors.values().iterator();
        while (iterator.hasNext()) {
            ResourceFileEditor<?> resourceFileEditor = iterator.next();
            if (resourceFileEditor.isClosed()) {
                resourceFileEditor.close();
                iterator.remove();
                continue;
            }
            resourceFileEditor.render();
        }
    }

    @ApiStatus.Internal
    public void renderLast() {
        if (!this.enabled) {
            return;
        }
        for (Map.Entry<Inspector, ImBoolean> entry : this.editors.entrySet()) {
            Inspector inspector = entry.getKey();
            ImBoolean enabled = entry.getValue();
            if (!enabled.get()) continue;
            inspector.renderLast();
        }
    }

    @ApiStatus.Internal
    public void onFileChange(VeilResource<?> resource) {
        ResourceFileEditor<?> editor = this.resourceFileEditors.get(resource.resourceInfo().location());
        if (editor != null) {
            editor.loadFromDisk();
        }
    }

    public void show(Inspector inspector) {
        ImBoolean enabled = this.editors.get(inspector);
        if (enabled != null && !enabled.get()) {
            inspector.onShow();
            enabled.set(true);
        }
    }

    public void hide(Inspector inspector) {
        ImBoolean enabled = this.editors.get(inspector);
        if (enabled != null && enabled.get()) {
            inspector.onHide();
            enabled.set(false);
        }
    }

    public boolean isVisible(Inspector inspector) {
        ImBoolean visible = this.editors.get(inspector);
        return visible != null && visible.get();
    }

    public boolean isVisible(Predicate<Inspector> filter) {
        if (!this.enabled) {
            return false;
        }
        for (Map.Entry<Inspector, ImBoolean> entry : this.editors.entrySet()) {
            if (!entry.getValue().get() || !filter.test(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    public synchronized void add(Inspector inspector) {
        this.editors.computeIfAbsent(inspector, unused -> new ImBoolean());
    }

    public synchronized void remove(Inspector inspector) {
        this.hide(inspector);
        this.editors.remove(inspector);
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @NotNull
    public CompletableFuture<Void> method_25931(@NotNull class_3302.class_4045 preparationBarrier, @NotNull class_3300 resourceManager, @NotNull class_3695 prepareProfiler, @NotNull class_3695 applyProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        class_3302 listener;
        ArrayList<class_3302> listeners = new ArrayList<class_3302>(this.editors.size());
        listeners.add(this.fonts);
        for (Inspector inspector : this.editors.keySet()) {
            if (!(inspector instanceof class_3302)) continue;
            listener = (class_3302)inspector;
            listeners.add(listener);
        }
        for (ResourceFileEditor resourceFileEditor : this.resourceFileEditors.values()) {
            if (!(resourceFileEditor instanceof class_3302)) continue;
            listener = (class_3302)resourceFileEditor;
            listeners.add(listener);
        }
        class_3302 listener2 = CompositeReloadListener.of((class_3302[])listeners.toArray(class_3302[]::new));
        return listener2.method_25931(preparationBarrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor);
    }

    @Override
    public <T extends VeilResource<?>> void open(T resource, ResourceFileEditor.Factory<T> editor) {
        try {
            ResourceFileEditor<T> open = editor.open(this, resource);
            if (open != null) {
                this.resourceFileEditors.put(resource.resourceInfo().location(), open);
            }
        }
        catch (Throwable t) {
            Veil.LOGGER.error("Failed to open editor for resource: {}", (Object)resource.resourceInfo().location(), (Object)t);
        }
    }

    @Override
    public VeilResourceManager getResourceManager() {
        return VeilClient.resourceManager();
    }
}

