/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4x3f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class Bone {
    public Vector3f position;
    public Vector3f previousPosition;
    public Vector3f basePosition;
    public Vector3f rotationPoint;
    public Vector3f previousRotationPoint;
    public Vector3f baseRotationPoint;
    public Quaternionf rotation;
    public Quaternionf previousRotation;
    public Quaternionf baseRotation;
    public Vector3f size;
    public Vector3f previousSize;
    public Vector3f baseSize;
    public Vector4f color;
    public Vector4f previousColor;
    public Vector4f baseColor;
    @Nullable
    public Bone parent;
    public List<Bone> children;
    public final String identifier;
    private int index;
    public List<Bone> parentChain;

    public Bone(String identifier) {
        this.identifier = identifier;
        this.position = new Vector3f(0.0f);
        this.previousPosition = new Vector3f(0.0f);
        this.basePosition = new Vector3f(0.0f);
        this.rotationPoint = new Vector3f(0.0f);
        this.previousRotationPoint = new Vector3f(0.0f);
        this.baseRotationPoint = new Vector3f(0.0f);
        this.rotation = new Quaternionf();
        this.previousRotation = new Quaternionf();
        this.baseRotation = new Quaternionf();
        this.size = new Vector3f(1.0f);
        this.previousSize = new Vector3f(1.0f);
        this.baseSize = new Vector3f(1.0f);
        this.color = new Vector4f(1.0f);
        this.previousColor = new Vector4f(1.0f);
        this.baseColor = new Vector4f(1.0f);
        this.children = new ArrayList<Bone>();
        this.parentChain = new ArrayList<Bone>();
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setBaseAttributes(Vector3fc pos, Quaternionfc rotation, Vector3f rotationPoint, Vector3fc scale, Vector4fc color) {
        this.basePosition.set(pos);
        this.position.set((Vector3fc)this.basePosition);
        this.previousPosition.set((Vector3fc)this.basePosition);
        this.baseSize.set(scale);
        this.size.set((Vector3fc)this.baseSize);
        this.previousSize.set((Vector3fc)this.baseSize);
        this.baseRotation.set(rotation);
        this.rotation.set((Quaternionfc)this.baseRotation);
        this.previousRotation.set((Quaternionfc)this.baseRotation);
        this.baseRotationPoint.set((Vector3fc)rotationPoint);
        this.rotationPoint.set((Vector3fc)this.baseRotationPoint);
        this.previousRotationPoint.set((Vector3fc)this.baseRotationPoint);
        this.baseColor.set(color);
        this.color.set((Vector4fc)this.baseColor);
        this.previousColor.set((Vector4fc)this.baseColor);
    }

    public void reset() {
        this.position.set((Vector3fc)this.basePosition);
        this.rotation.set((Quaternionfc)this.baseRotation);
        this.rotationPoint.set((Vector3fc)this.baseRotationPoint);
        this.size.set((Vector3fc)this.baseSize);
        this.color.set((Vector4fc)this.baseColor);
    }

    protected void updatePreviousAttributes() {
        this.previousPosition.set((Vector3fc)this.position);
        this.previousRotation.set((Quaternionfc)this.rotation);
        this.previousRotationPoint.set((Vector3fc)this.rotationPoint);
        this.previousSize.set((Vector3fc)this.size);
        this.previousColor.set((Vector4fc)this.color);
    }

    public Matrix4x3f getModelTransform(Matrix4x3f matrix, Quaternionf orientation, float partialTicks) {
        for (Bone bone : this.parentChain) {
            bone.getLocalTransform(matrix, orientation, partialTicks);
        }
        this.getLocalTransform(matrix, orientation, partialTicks);
        return matrix;
    }

    public Matrix4x3f getModelTransform(Matrix4x3f matrix, float partialTicks) {
        return this.getModelTransform(matrix, new Quaternionf(), partialTicks);
    }

    public void getLocalTransform(Matrix4x3f matrix, Quaternionf orientation, float partialTicks) {
        float x = class_3532.method_16439((float)partialTicks, (float)this.previousPosition.x, (float)this.position.x);
        float y = class_3532.method_16439((float)partialTicks, (float)this.previousPosition.y, (float)this.position.y);
        float z = class_3532.method_16439((float)partialTicks, (float)this.previousPosition.z, (float)this.position.z);
        matrix.translate(x, y, z);
        this.previousRotation.slerp((Quaternionfc)this.rotation, partialTicks, orientation);
        float rotationPointX = class_3532.method_16439((float)partialTicks, (float)this.previousRotationPoint.x, (float)this.rotationPoint.x);
        float rotationPointY = class_3532.method_16439((float)partialTicks, (float)this.previousRotationPoint.y, (float)this.rotationPoint.y);
        float rotationPointZ = class_3532.method_16439((float)partialTicks, (float)this.previousRotationPoint.z, (float)this.rotationPoint.z);
        matrix.translate(rotationPointX, rotationPointY, rotationPointZ);
        matrix.rotate((Quaternionfc)orientation.normalize());
        matrix.translate(-rotationPointX, -rotationPointY, -rotationPointZ);
        matrix.scale(class_3532.method_16439((float)partialTicks, (float)this.previousSize.x, (float)this.size.x), class_3532.method_16439((float)partialTicks, (float)this.previousSize.y, (float)this.size.y), class_3532.method_16439((float)partialTicks, (float)this.previousSize.z, (float)this.size.z));
    }

    public void getLocalTransform(Matrix4x3f matrix, float partialTicks) {
        this.getLocalTransform(matrix, new Quaternionf(), partialTicks);
    }

    public void getColor(Vector4f color, float partialTicks) {
        this.previousColor.lerp((Vector4fc)this.color, partialTicks, color);
    }

    protected void tick(float deltaTime) {
    }

    public void addChild(Bone child) {
        if (child.parent != null) {
            child.parent.children.remove(child);
        }
        this.children.add(child);
        child.parent = this;
    }

    public void setParent(Bone parent) {
        this.parent = parent;
        parent.children.add(this);
    }

    public Bone rotate(float angle, class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                this.rotation.rotateX(angle);
                break;
            }
            case field_11052: {
                this.rotation.rotateY(angle);
                break;
            }
            case field_11051: {
                this.rotation.rotateZ(angle);
            }
        }
        return this;
    }

    public Bone rotateDeg(float angle, class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                this.rotation.rotateX(angle * ((float)Math.PI / 180));
                break;
            }
            case field_11052: {
                this.rotation.rotateY(angle * ((float)Math.PI / 180));
                break;
            }
            case field_11051: {
                this.rotation.rotateZ(angle * ((float)Math.PI / 180));
            }
        }
        return this;
    }

    public Bone offset(float x, float y, float z) {
        this.position.add(x, y, z);
        return this;
    }

    public Bone offsetX(float x) {
        this.position.add(x, 0.0f, 0.0f);
        return this;
    }

    public Bone offsetY(float y) {
        this.position.add(0.0f, y, 0.0f);
        return this;
    }

    public Bone offsetZ(float z) {
        this.position.add(0.0f, 0.0f, z);
        return this;
    }
}

