/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer;

import foundry.veil.api.client.necromancer.Bone;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.joml.Matrix3f;
import org.joml.Matrix4x3f;
import org.joml.Matrix4x3fc;
import org.joml.Quaternionf;
import org.joml.Vector4f;

public abstract class Skeleton {
    public static final int MAX_BONES = 256;
    public static final int UNIFORM_STRIDE = 112;
    public List<Bone> roots = new ArrayList<Bone>();
    public Map<String, Bone> bones = new HashMap<String, Bone>();
    private int maxDepth = 1;

    public void tick() {
        for (Bone part : this.bones.values()) {
            part.updatePreviousAttributes();
        }
        for (Bone bone : this.bones.values()) {
            bone.tick(0.05f);
        }
    }

    public void addBone(Bone part) {
        part.setIndex(this.bones.size());
        this.bones.put(part.identifier, part);
    }

    public void buildRoots() {
        this.maxDepth = 0;
        for (Bone part : this.bones.values()) {
            if (part.parent == null) {
                this.roots.add(part);
                continue;
            }
            HashSet<Bone> closedSet = new HashSet<Bone>();
            Bone parentBone = part.parent;
            while (parentBone != null) {
                if (!closedSet.add(parentBone)) {
                    throw new IllegalStateException("Circular reference in bone: " + parentBone.identifier);
                }
                part.parentChain.add(parentBone);
                parentBone = parentBone.parent;
            }
            Collections.reverse(part.parentChain);
            this.maxDepth = Math.max(part.parentChain.size(), this.maxDepth);
        }
        ++this.maxDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void storeInstancedData(ByteBuffer buffer, Collection<Bone> bones, Object2IntMap<String> boneIds, int depth, Vector4f color, Matrix3f normalMatrix, Matrix4x3f baseTransform, Matrix4x3f[] matrixStack, Quaternionf[] orientationStack, float partialTicks) {
        for (Bone bone : bones) {
            int boneBufferIndex = boneIds.getInt((Object)bone.identifier);
            boolean hasBufferPosition = boneBufferIndex != -1;
            boolean hasChildren = !bone.children.isEmpty();
            Matrix4x3f matrix = matrixStack[depth].set((Matrix4x3fc)baseTransform);
            Quaternionf orientation = orientationStack[depth];
            if (hasBufferPosition || hasChildren) {
                bone.getLocalTransform(matrix, orientation, partialTicks);
                if (hasBufferPosition) {
                    matrix.getTransposed(buffer.position() + boneBufferIndex * 112, buffer);
                    bone.getColor(color, partialTicks);
                    color.get(buffer.position() + boneBufferIndex * 112 + 48, buffer);
                    matrix.normal(normalMatrix).get3x4(boneBufferIndex * 112 + 64, buffer);
                }
            }
            if (!hasChildren) continue;
            this.storeInstancedData(buffer, bone.children, boneIds, depth + 1, color, normalMatrix, matrix, matrixStack, orientationStack, partialTicks);
        }
    }
}

