/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.necromancer.render.NecromancerRenderer;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.VeilShaderBufferLayout;
import foundry.veil.api.client.render.VeilShaderLimits;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.ext.VeilDebug;
import foundry.veil.api.client.render.ext.VeilMultiBind;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.framebuffer.FramebufferStack;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.post.PostProcessingManager;
import foundry.veil.api.client.render.profiler.RenderProfilerCounter;
import foundry.veil.api.client.render.profiler.VeilRenderProfiler;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.compat.SodiumCompat;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.ext.LevelRendererExtension;
import foundry.veil.ext.TextureManagerExtension;
import foundry.veil.ext.VertexBufferExtension;
import foundry.veil.impl.client.imgui.VeilImGui;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import foundry.veil.impl.client.necromancer.render.NecromancerRenderDispatcher;
import foundry.veil.impl.client.render.dynamicbuffer.VanillaShaderCompiler;
import foundry.veil.impl.client.render.pipeline.VeilBloomRenderer;
import foundry.veil.impl.client.render.pipeline.VeilShaderBlockState;
import foundry.veil.impl.client.render.pipeline.VeilShaderBufferCache;
import foundry.veil.impl.client.render.profiler.VeilRenderProfilerImpl;
import foundry.veil.impl.client.render.shader.program.ShaderProgramImpl;
import foundry.veil.mixin.pipeline.accessor.PipelineBufferSourceAccessor;
import foundry.veil.platform.VeilEventPlatform;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1041;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_291;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5944;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;

public final class VeilRenderSystem {
    public static final class_4668.class_4678 BLOOM_SHARD = new class_4668.class_4678("veil:bloom", VeilBloomRenderer::setupRenderState, VeilBloomRenderer::clearRenderState);
    private static final Executor RENDER_THREAD_EXECUTOR = task -> {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(task::run);
        } else {
            task.run();
        }
    };
    private static final Set<class_2960> ERRORED_SHADERS = new HashSet<class_2960>();
    private static final VeilShaderBlockState UNIFORM_BLOCK_STATE = new VeilShaderBlockState();
    private static final VeilShaderBufferCache SHADER_BUFFER_CACHE = new VeilShaderBufferCache();
    private static final BooleanSupplier COMPUTE_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL43 || caps.GL_ARB_compute_shader);
    private static final BooleanSupplier ATOMIC_COUNTER_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL42 || caps.GL_ARB_shader_atomic_counters);
    private static final BooleanSupplier TRANSFORM_FEEDBACK_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL40 || caps.GL_ARB_transform_feedback3);
    private static final BooleanSupplier MULTIBIND_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL44 || caps.GL_ARB_multi_bind);
    private static final BooleanSupplier SPARSE_BUFFERS_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL44 || caps.GL_ARB_sparse_buffer);
    private static final BooleanSupplier DIRECT_STATE_ACCESS_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL45 || caps.GL_ARB_direct_state_access);
    private static final BooleanSupplier SEPARATE_SHADER_OBJECTS_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL41 || caps.GL_ARB_separate_shader_objects);
    private static final BooleanSupplier CLEAR_TEXTURE_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL44 || caps.GL_ARB_clear_texture);
    private static final BooleanSupplier COPY_IMAGE_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL43 || caps.GL_ARB_copy_image);
    private static final BooleanSupplier SHADER_STORAGE_BLOCK_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL43 || caps.GL_ARB_shader_storage_buffer_object);
    private static final BooleanSupplier PROGRAM_INTERFACE_QUERY_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL43 || caps.GL_ARB_program_interface_query);
    private static final BooleanSupplier TEXTURE_ANISOTROPY_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL46 || caps.GL_ARB_texture_filter_anisotropic || caps.GL_EXT_texture_filter_anisotropic);
    private static final BooleanSupplier TEXTURE_MIRROR_CLAMP_TO_EDGE_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL44 || caps.GL_ARB_texture_mirror_clamp_to_edge);
    private static final BooleanSupplier TEXTURE_CUBE_MAP_SEAMLESS_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.GL_ARB_seamless_cubemap_per_texture);
    private static final BooleanSupplier TEXTURE_CUBE_MAP_ARRAY_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL40 || caps.GL_ARB_texture_cube_map_array);
    private static final BooleanSupplier NV_DRAW_TEXTURE_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.GL_NV_draw_texture);
    private static final BooleanSupplier DRAW_INDIRECT_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL40 || caps.GL_ARB_draw_indirect);
    private static final BooleanSupplier MULTI_DRAW_INDIRECT_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL43 || caps.GL_ARB_multi_draw_indirect);
    private static final BooleanSupplier GPU_SHADER_FLOAT_64BIT_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL40 || caps.GL_ARB_gpu_shader_fp64);
    private static final BooleanSupplier GPU_SHADER_INT_64BIT_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.GL_ARB_gpu_shader_int64);
    private static final BooleanSupplier VERTEX_ATTRIB_64BIT_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL41 || caps.GL_ARB_vertex_attrib_64bit);
    private static final BooleanSupplier BINDLESS_TEXTURE_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.GL_ARB_bindless_texture);
    private static final BooleanSupplier VERTEX_TYPE_10F_11F_11F_REV_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.OpenGL44 || caps.GL_ARB_vertex_type_10f_11f_11f_rev);
    private static final BooleanSupplier PIPELINE_STATISTICS_QUERY_SUPPORTED = VeilRenderSystem.glCapability(caps -> caps.GL_ARB_pipeline_statistics_query);
    private static final IntSupplier MAX_COMBINED_TEXTURE_IMAGE_UNITS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)35661));
    private static final IntSupplier MAX_COLOR_ATTACHMENTS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)36063));
    private static final IntSupplier MAX_SAMPLES = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)36183));
    private static final IntSupplier MAX_TRANSFORM_FEEDBACK_BUFFERS = VeilRenderSystem.glGetter(() -> TRANSFORM_FEEDBACK_SUPPORTED.getAsBoolean() ? GL11C.glGetInteger((int)36464) : 0);
    private static final IntSupplier MAX_UNIFORM_BUFFER_BINDINGS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)35375));
    private static final IntSupplier MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)37596));
    private static final IntSupplier MAX_SHADER_STORAGE_BUFFER_BINDINGS = VeilRenderSystem.glGetter(() -> SHADER_STORAGE_BLOCK_SUPPORTED.getAsBoolean() ? GL11C.glGetInteger((int)37085) : 0);
    private static final IntSupplier MAX_ARRAY_TEXTURE_LAYERS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)35071));
    private static final Supplier<Float> MAX_TEXTURE_ANISOTROPY = VeilRenderSystem.glGetter(() -> Float.valueOf(TEXTURE_ANISOTROPY_SUPPORTED.getAsBoolean() ? GL43C.glGetFloat((int)34047) : 1.0f));
    private static final IntSupplier MAX_VERTEX_ATTRIBS = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)34921));
    private static final IntSupplier MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = VeilRenderSystem.glGetter(() -> Math.max(2047, GL11C.glGetInteger((int)33497)));
    private static final Supplier<VeilShaderLimits> VERTEX_SHADER_LIMITS = VeilRenderSystem.glGetter(() -> {
        GLCapabilities caps = GL.getCapabilities();
        return new VeilShaderLimits(caps, GL11C.glGetInteger((int)35658), GL11C.glGetInteger((int)35371), GL11C.glGetInteger((int)34921) * 4, GL11C.glGetInteger((int)37154), GL11C.glGetInteger((int)35660), 37066, 37586, 37580, 37078);
    });
    private static final Supplier<VeilShaderLimits> GL_TESS_CONTROL_SHADER_LIMITS = VeilRenderSystem.glGetter(() -> {
        GLCapabilities caps = GL.getCapabilities();
        return new VeilShaderLimits(caps, GL11C.glGetInteger((int)36479), GL11C.glGetInteger((int)36489), GL11C.glGetInteger((int)34924), GL11C.glGetInteger((int)36483), GL11C.glGetInteger((int)36481), 37067, 37587, 37581, 37080);
    });
    private static final Supplier<VeilShaderLimits> GL_TESS_EVALUATION_SHADER_LIMITS = VeilRenderSystem.glGetter(() -> {
        GLCapabilities caps = GL.getCapabilities();
        return new VeilShaderLimits(caps, GL11C.glGetInteger((int)36480), GL11C.glGetInteger((int)36490), GL11C.glGetInteger((int)34925), GL11C.glGetInteger((int)36486), GL11C.glGetInteger((int)36482), 37068, 37588, 37582, 37081);
    });
    private static final Supplier<VeilShaderLimits> GL_GEOMETRY_SHADER_LIMITS = VeilRenderSystem.glGetter(() -> {
        GLCapabilities caps = GL.getCapabilities();
        return new VeilShaderLimits(caps, GL11C.glGetInteger((int)36319), GL11C.glGetInteger((int)35372), GL11C.glGetInteger((int)37155), GL11C.glGetInteger((int)37156), GL11C.glGetInteger((int)35881), 37069, 37589, 37583, 37079);
    });
    private static final Supplier<VeilShaderLimits> GL_FRAGMENT_SHADER_LIMITS = VeilRenderSystem.glGetter(() -> {
        GLCapabilities caps = GL.getCapabilities();
        return new VeilShaderLimits(caps, GL11C.glGetInteger((int)35657), GL11C.glGetInteger((int)35373), GL11C.glGetInteger((int)37157), GL11C.glGetInteger((int)34852) * 4, GL11C.glGetInteger((int)34930), 37070, 37590, 37584, 37082);
    });
    private static final Supplier<VeilShaderLimits> GL_COMPUTE_SHADER_LIMITS = VeilRenderSystem.glGetter(() -> {
        GLCapabilities caps = GL.getCapabilities();
        return new VeilShaderLimits(caps, GL11C.glGetInteger((int)33379), GL11C.glGetInteger((int)37307), 0, 0, GL11C.glGetInteger((int)37308), 37309, 33381, 33380, 37083);
    });
    private static final Supplier<Vector2ic> MAX_FRAMEBUFFER_SIZE = Suppliers.memoize(() -> {
        RenderSystem.assertOnRenderThreadOrInit();
        if (!GL.getCapabilities().OpenGL43) {
            int maxSupportedTextureSize = RenderSystem.maxSupportedTextureSize();
            return new Vector2i(maxSupportedTextureSize, maxSupportedTextureSize);
        }
        int width = GL11C.glGetInteger((int)37653);
        int height = GL11C.glGetInteger((int)37654);
        return new Vector2i(width, height);
    });
    private static final Supplier<Vector3ic> MAX_COMPUTE_WORK_GROUP_COUNT = Suppliers.memoize(() -> {
        RenderSystem.assertOnRenderThreadOrInit();
        if (!COMPUTE_SUPPORTED.getAsBoolean()) {
            return new Vector3i();
        }
        int width = GL43C.glGetIntegeri((int)37310, (int)0);
        int height = GL43C.glGetIntegeri((int)37310, (int)1);
        int depth = GL43C.glGetIntegeri((int)37310, (int)2);
        return new Vector3i(width, height, depth);
    });
    private static final Supplier<Vector3ic> MAX_COMPUTE_WORK_GROUP_SIZE = Suppliers.memoize(() -> {
        RenderSystem.assertOnRenderThreadOrInit();
        if (!COMPUTE_SUPPORTED.getAsBoolean()) {
            return new Vector3i();
        }
        int width = GL43C.glGetIntegeri((int)37311, (int)0);
        int height = GL43C.glGetIntegeri((int)37311, (int)1);
        int depth = GL43C.glGetIntegeri((int)37311, (int)2);
        return new Vector3i(width, height, depth);
    });
    private static final IntSupplier MAX_COMPUTE_WORK_GROUP_INVOCATIONS = VeilRenderSystem.glGetter(() -> COMPUTE_SUPPORTED.getAsBoolean() ? GL11C.glGetInteger((int)37099) : 0);
    private static final LongSupplier MAX_UNIFORM_BLOCK_SIZE = VeilRenderSystem.glGetter(() -> GL43C.glGetInteger64((int)35376));
    private static final IntSupplier UNIFORM_BUFFER_OFFSET_ALIGNMENT = VeilRenderSystem.glGetter(() -> GL11C.glGetInteger((int)35380));
    private static final LongSupplier MAX_SHADER_STORAGE_BLOCK_SIZE = VeilRenderSystem.glGetter(() -> SHADER_STORAGE_BLOCK_SUPPORTED.getAsBoolean() ? GL43C.glGetInteger64((int)37086) : 0L);
    private static final Vector3f LIGHT0_DIRECTION = new Vector3f();
    private static final Vector3f LIGHT1_DIRECTION = new Vector3f();
    private static final Vector3f CAMERA_BOB_OFFSET = new Vector3f();
    private static boolean pendingFontRebuild;
    private static VeilRenderer renderer;
    private static class_2960 shaderLocation;
    private static int screenQuadVao;
    private static IntBuffer emptySamplers;

    private VeilRenderSystem() {
    }

    private static BooleanSupplier glCapability(final Function<GLCapabilities, Boolean> delegate) {
        return new BooleanSupplier(){
            private boolean value;
            private boolean initialized;

            @Override
            public boolean getAsBoolean() {
                RenderSystem.assertOnRenderThreadOrInit();
                if (!this.initialized) {
                    this.initialized = true;
                    this.value = (Boolean)delegate.apply(GL.getCapabilities());
                    return this.value;
                }
                return this.value;
            }
        };
    }

    private static IntSupplier glGetter(final IntSupplier delegate) {
        return new IntSupplier(){
            private int value = Integer.MAX_VALUE;

            @Override
            public int getAsInt() {
                RenderSystem.assertOnRenderThreadOrInit();
                if (this.value == Integer.MAX_VALUE) {
                    this.value = delegate.getAsInt();
                    return this.value;
                }
                return this.value;
            }
        };
    }

    private static LongSupplier glGetter(final LongSupplier delegate) {
        return new LongSupplier(){
            private long value = Long.MAX_VALUE;

            @Override
            public long getAsLong() {
                RenderSystem.assertOnRenderThreadOrInit();
                if (this.value == Long.MAX_VALUE) {
                    this.value = delegate.getAsLong();
                    return this.value;
                }
                return this.value;
            }
        };
    }

    private static <T> Supplier<T> glGetter(final Supplier<T> delegate) {
        return new Supplier<T>(){
            private T value = null;

            @Override
            public T get() {
                RenderSystem.assertOnRenderThreadOrInit();
                if (this.value == null) {
                    this.value = delegate.get();
                    return this.value;
                }
                return this.value;
            }
        };
    }

    public static void bindTextures(int first, IntBuffer textures) {
        VeilMultiBind.get().bindTextures(first, textures);
    }

    public static void bindTextures(int first, int ... textures) {
        VeilMultiBind.get().bindTextures(first, textures);
    }

    public static void bindSamplers(int first, IntBuffer textures) {
        VeilMultiBind.get().bindSamplers(first, textures);
    }

    public static void bindSamplers(int first, int ... textures) {
        VeilMultiBind.get().bindSamplers(first, textures);
    }

    public static void unbindSamplers(int first, int count) {
        VeilMultiBind.get().bindSamplers(first, emptySamplers.limit(count));
    }

    public static <T extends class_1044> CompletableFuture<?> registerPreloadedTexture(class_2960 path, T texture) {
        return VeilRenderSystem.registerPreloadedTexture(path, texture, class_156.method_18349());
    }

    public static <T extends class_1044> CompletableFuture<?> registerPreloadedTexture(class_2960 path, T texture, Executor executor) {
        return ((TextureManagerExtension)class_310.method_1551().method_1531()).veil$registerPreloadedTexture(path, texture, executor);
    }

    public static void drawScreenQuad() {
        GlStateManager._glBindVertexArray((int)screenQuadVao);
        GL43C.glDrawArrays((int)5, (int)0, (int)3);
        class_291.method_1354();
    }

    @Nullable
    public static ShaderProgram setShader(class_2960 shader) {
        ShaderManager shaderManager = renderer.getShaderManager();
        shaderLocation = shader;
        return VeilRenderSystem.setShader(() -> shaderManager.getShader(shader));
    }

    @Nullable
    public static ShaderProgram setShader(@Nullable ShaderProgram shader) {
        shaderLocation = shader != null ? shader.getName() : null;
        return VeilRenderSystem.setShader(() -> shader);
    }

    @Nullable
    public static ShaderProgram setShader(Supplier<ShaderProgram> shader) {
        RenderSystem.setShader(() -> {
            ShaderProgram program = (ShaderProgram)shader.get();
            return program != null ? VeilRenderBridge.toShaderInstance(program) : null;
        });
        ShaderProgram value = VeilRenderSystem.getShader();
        if (value == null && shaderLocation != null && ERRORED_SHADERS.add(shaderLocation)) {
            Veil.LOGGER.error("Failed to apply shader: {}", (Object)shaderLocation);
        }
        return value;
    }

    public static void drawInstanced(class_291 vbo, int instances) {
        ((VertexBufferExtension)vbo).veil$drawInstanced(instances);
    }

    public static void drawIndirect(class_291 vbo, long indirect, int drawCount, int stride) {
        ((VertexBufferExtension)vbo).veil$drawIndirect(indirect, drawCount, stride);
    }

    public static void endLastBatch(class_4597.class_4598 source, String name) {
        PipelineBufferSourceAccessor accessor;
        class_1921 renderType;
        if (source instanceof PipelineBufferSourceAccessor && (renderType = (accessor = (PipelineBufferSourceAccessor)source).getLastSharedType()) != null && VeilRenderType.getName((class_4668)renderType).equals(name)) {
            source.method_37104();
        }
    }

    public static void endLastBatch(class_4597.class_4598 source, class_1921 renderType) {
        PipelineBufferSourceAccessor accessor;
        class_1921 lastSharedType;
        if (source instanceof PipelineBufferSourceAccessor && (lastSharedType = (accessor = (PipelineBufferSourceAccessor)source).getLastSharedType()) != null && lastSharedType.equals(renderType)) {
            source.method_37104();
        }
    }

    public static void rebuildChunks() {
        ((LevelRendererExtension)class_310.method_1551().field_1769).veil$markChunksDirty();
    }

    public static void printGlErrors(@Nullable String glCall) {
        int error;
        while ((error = GlStateManager._getError()) != 0) {
            if (glCall != null) {
                Veil.LOGGER.error("[OpenGL Error] '{}' 0x{}", (Object)glCall, (Object)Integer.toHexString(error).toUpperCase(Locale.ROOT));
                continue;
            }
            Veil.LOGGER.error("[OpenGL Error] 0x{}", (Object)Integer.toHexString(error).toUpperCase(Locale.ROOT));
        }
    }

    public static int getIndexCount(class_291 vbo) {
        return ((VertexBufferExtension)vbo).veil$getIndexCount();
    }

    public static boolean computeSupported() {
        return COMPUTE_SUPPORTED.getAsBoolean();
    }

    public static boolean atomicCounterSupported() {
        return ATOMIC_COUNTER_SUPPORTED.getAsBoolean();
    }

    public static boolean transformFeedbackSupported() {
        return TRANSFORM_FEEDBACK_SUPPORTED.getAsBoolean();
    }

    public static boolean multibindSupported() {
        return MULTIBIND_SUPPORTED.getAsBoolean();
    }

    public static boolean sparseBuffersSupported() {
        return SPARSE_BUFFERS_SUPPORTED.getAsBoolean();
    }

    public static boolean directStateAccessSupported() {
        return DIRECT_STATE_ACCESS_SUPPORTED.getAsBoolean();
    }

    public static boolean separateShaderObjectsSupported() {
        return SEPARATE_SHADER_OBJECTS_SUPPORTED.getAsBoolean();
    }

    public static boolean clearTextureSupported() {
        return CLEAR_TEXTURE_SUPPORTED.getAsBoolean();
    }

    public static boolean copyImageSupported() {
        return COPY_IMAGE_SUPPORTED.getAsBoolean();
    }

    public static boolean shaderStorageBufferSupported() {
        return SHADER_STORAGE_BLOCK_SUPPORTED.getAsBoolean();
    }

    public static boolean programInterfaceQuerySupported() {
        return PROGRAM_INTERFACE_QUERY_SUPPORTED.getAsBoolean();
    }

    public static boolean textureAnisotropySupported() {
        return TEXTURE_ANISOTROPY_SUPPORTED.getAsBoolean();
    }

    public static boolean textureMirrorClampToEdgeSupported() {
        return TEXTURE_MIRROR_CLAMP_TO_EDGE_SUPPORTED.getAsBoolean();
    }

    public static boolean textureCubeMapSeamlessSupported() {
        return TEXTURE_CUBE_MAP_SEAMLESS_SUPPORTED.getAsBoolean();
    }

    public static boolean textureCubeMapArraySupported() {
        return TEXTURE_CUBE_MAP_ARRAY_SUPPORTED.getAsBoolean();
    }

    public static boolean nvDrawTextureSupported() {
        return NV_DRAW_TEXTURE_SUPPORTED.getAsBoolean();
    }

    public static boolean drawIndirectSupported() {
        return DRAW_INDIRECT_SUPPORTED.getAsBoolean();
    }

    public static boolean multiDrawIndirectSupported() {
        return MULTI_DRAW_INDIRECT_SUPPORTED.getAsBoolean();
    }

    public static boolean gpuShaderFloat64BitSupported() {
        return GPU_SHADER_FLOAT_64BIT_SUPPORTED.getAsBoolean();
    }

    public static boolean gpuShaderInt64BitSupported() {
        return GPU_SHADER_INT_64BIT_SUPPORTED.getAsBoolean();
    }

    public static boolean vertexAttribute64BitSupported() {
        return VERTEX_ATTRIB_64BIT_SUPPORTED.getAsBoolean();
    }

    public static boolean bindlessTextureSupported() {
        return BINDLESS_TEXTURE_SUPPORTED.getAsBoolean();
    }

    public static boolean vertexType10F11F11FRevSupported() {
        return VERTEX_TYPE_10F_11F_11F_REV_SUPPORTED.getAsBoolean();
    }

    public static boolean pipelineStatisticsQuerySupported() {
        return PIPELINE_STATISTICS_QUERY_SUPPORTED.getAsBoolean();
    }

    public static int maxCombinedTextureUnits() {
        return MAX_COMBINED_TEXTURE_IMAGE_UNITS.getAsInt();
    }

    public static int maxColorAttachments() {
        return MAX_COLOR_ATTACHMENTS.getAsInt();
    }

    public static int maxSamples() {
        return MAX_SAMPLES.getAsInt();
    }

    public static int maxTargetBindings(int target) {
        return switch (target) {
            case 35982 -> VeilRenderSystem.maxTransformFeedbackBindings();
            case 35345 -> VeilRenderSystem.maxUniformBuffersBindings();
            case 37568 -> VeilRenderSystem.maxAtomicCounterBufferBindings();
            case 37074 -> VeilRenderSystem.maxShaderStorageBufferBindings();
            default -> throw new IllegalArgumentException("Invalid Target: 0x" + Integer.toHexString(target).toUpperCase(Locale.ROOT));
        };
    }

    public static VeilShaderLimits shaderLimits(int shader) {
        return switch (shader) {
            case 35633 -> VERTEX_SHADER_LIMITS.get();
            case 36488 -> GL_TESS_CONTROL_SHADER_LIMITS.get();
            case 36487 -> GL_TESS_EVALUATION_SHADER_LIMITS.get();
            case 36313 -> GL_GEOMETRY_SHADER_LIMITS.get();
            case 35632 -> GL_FRAGMENT_SHADER_LIMITS.get();
            case 37305 -> GL_COMPUTE_SHADER_LIMITS.get();
            default -> throw new IllegalArgumentException("Invalid Shader Type: 0x" + Integer.toHexString(shader).toUpperCase(Locale.ROOT));
        };
    }

    public static int maxTransformFeedbackBindings() {
        return MAX_TRANSFORM_FEEDBACK_BUFFERS.getAsInt();
    }

    public static int maxUniformBuffersBindings() {
        return MAX_UNIFORM_BUFFER_BINDINGS.getAsInt();
    }

    public static int maxAtomicCounterBufferBindings() {
        return MAX_ATOMIC_COUNTER_BUFFER_BINDINGS.getAsInt();
    }

    public static int maxShaderStorageBufferBindings() {
        return MAX_SHADER_STORAGE_BUFFER_BINDINGS.getAsInt();
    }

    public static int maxArrayTextureLayers() {
        return MAX_ARRAY_TEXTURE_LAYERS.getAsInt();
    }

    public static float maxTextureAnisotropy() {
        return MAX_TEXTURE_ANISOTROPY.get().floatValue();
    }

    public static int maxVertexAttributes() {
        return MAX_VERTEX_ATTRIBS.getAsInt();
    }

    public static int maxVertexAttributeRelativeOffset() {
        return MAX_VERTEX_ATTRIB_RELATIVE_OFFSET.getAsInt();
    }

    public static int maxFramebufferWidth() {
        return MAX_FRAMEBUFFER_SIZE.get().x();
    }

    public static int maxFramebufferHeight() {
        return MAX_FRAMEBUFFER_SIZE.get().y();
    }

    public static int maxComputeWorkGroupCountX() {
        return MAX_COMPUTE_WORK_GROUP_COUNT.get().y();
    }

    public static int maxComputeWorkGroupCountY() {
        return MAX_COMPUTE_WORK_GROUP_COUNT.get().y();
    }

    public static int maxComputeWorkGroupCountZ() {
        return MAX_COMPUTE_WORK_GROUP_COUNT.get().y();
    }

    public static int maxComputeWorkGroupSizeX() {
        return MAX_COMPUTE_WORK_GROUP_SIZE.get().y();
    }

    public static int maxComputeWorkGroupSizeY() {
        return MAX_COMPUTE_WORK_GROUP_SIZE.get().y();
    }

    public static int maxComputeWorkGroupSizeZ() {
        return MAX_COMPUTE_WORK_GROUP_SIZE.get().y();
    }

    public static int maxComputeWorkGroupInvocations() {
        return MAX_COMPUTE_WORK_GROUP_INVOCATIONS.getAsInt();
    }

    public static long maxUniformBufferSize() {
        return MAX_UNIFORM_BLOCK_SIZE.getAsLong();
    }

    public static int uniformBufferAlignment() {
        return UNIFORM_BUFFER_OFFSET_ALIGNMENT.getAsInt();
    }

    public static long maxShaderStorageBufferSize() {
        return MAX_SHADER_STORAGE_BLOCK_SIZE.getAsLong();
    }

    public static void bind(CharSequence name, ShaderBlock<?> block) {
        RenderSystem.assertOnRenderThreadOrInit();
        UNIFORM_BLOCK_STATE.bind(name, block);
    }

    public static void bind(VeilShaderBufferLayout<?> layout) throws IllegalArgumentException {
        RenderSystem.assertOnRenderThreadOrInit();
        SHADER_BUFFER_CACHE.bind(layout);
    }

    public static void unbind(ShaderBlock<?> block) {
        RenderSystem.assertOnRenderThreadOrInit();
        UNIFORM_BLOCK_STATE.unbind(block);
    }

    public static void unbind(VeilShaderBufferLayout<?> layout) throws IllegalArgumentException {
        RenderSystem.assertOnRenderThreadOrInit();
        SHADER_BUFFER_CACHE.unbind(layout);
    }

    @Nullable
    public static <T> ShaderBlock<T> getBlock(VeilShaderBufferLayout<T> layout) throws IllegalArgumentException {
        RenderSystem.assertOnRenderThreadOrInit();
        return SHADER_BUFFER_CACHE.getBlock(layout);
    }

    public static void bindVertexArray(int vao) {
        class_286.method_43436();
        GlStateManager._glBindVertexArray((int)vao);
    }

    public static int getBoundTexture(int target) {
        return switch (target) {
            case 3552 -> GL11C.glGetInteger((int)32872);
            case 3553 -> GL11C.glGetInteger((int)32873);
            case 35864 -> GL11C.glGetInteger((int)35868);
            case 34037 -> GL11C.glGetInteger((int)34038);
            case 34067 -> GL11C.glGetInteger((int)34068);
            case 32879 -> GL11C.glGetInteger((int)32874);
            case 35866 -> GL11C.glGetInteger((int)35869);
            case 36873 -> GL11C.glGetInteger((int)36874);
            case 35882 -> GL11C.glGetInteger((int)35884);
            case 37120 -> GL11C.glGetInteger((int)37124);
            case 37122 -> GL11C.glGetInteger((int)37125);
            default -> throw new IllegalStateException("Not a texture target: " + target);
        };
    }

    public static int createTextures(int target) {
        if (VeilRenderSystem.directStateAccessSupported()) {
            return ARBDirectStateAccess.glCreateTextures((int)target);
        }
        return GL43C.glGenTextures();
    }

    public static void createTextures(int target, int[] textures) {
        if (VeilRenderSystem.directStateAccessSupported()) {
            ARBDirectStateAccess.glCreateTextures((int)target, (int[])textures);
            return;
        }
        GL43C.glGenTextures((int[])textures);
    }

    public static void createTextures(int target, IntBuffer textures) {
        if (VeilRenderSystem.directStateAccessSupported()) {
            ARBDirectStateAccess.glCreateTextures((int)target, (IntBuffer)textures);
            return;
        }
        GL43C.glGenTextures((IntBuffer)textures);
    }

    public static VeilRenderer renderer() {
        return renderer;
    }

    public static Executor renderThreadExecutor() {
        return RENDER_THREAD_EXECUTOR;
    }

    @Nullable
    public static ShaderProgram getShader() {
        ShaderProgram shaderProgram;
        class_5944 shader = RenderSystem.getShader();
        if (shader instanceof ShaderProgramImpl.Wrapper) {
            ShaderProgramImpl.Wrapper wrapper = (ShaderProgramImpl.Wrapper)shader;
            shaderProgram = wrapper.program();
        } else {
            shaderProgram = null;
        }
        return shaderProgram;
    }

    public static Vector3fc getLight0Direction() {
        return LIGHT0_DIRECTION;
    }

    public static Vector3fc getLight1Direction() {
        return LIGHT1_DIRECTION;
    }

    public static Vector3fc getCameraBobOffset() {
        return CAMERA_BOB_OFFSET;
    }

    public static boolean hasImGui() {
        return VeilImGuiImpl.get() instanceof VeilImGuiImpl;
    }

    public static CullFrustum getCullingFrustum() {
        return ((LevelRendererExtension)class_310.method_1551().field_1769).veil$getCullFrustum();
    }

    public static NecromancerRenderer getNecromancerRenderer() {
        return NecromancerRenderDispatcher.getRenderer();
    }

    @ApiStatus.Internal
    public static void bootstrap() {
        VeilEventPlatform.INSTANCE.onVeilShaderCompile((shaderManager, updatedPrograms) -> {
            UNIFORM_BLOCK_STATE.onShaderCompile();
            SHADER_BUFFER_CACHE.onShaderCompile(updatedPrograms);
            ERRORED_SHADERS.clear();
        });
        VeilEventPlatform.INSTANCE.onVeilRenderLevelStage((stage, levelRenderer, bufferSource, matrixStack, frustumMatrix, projectionMatrix, renderTick, deltaTracker, camera, frustum) -> {
            if (stage == VeilRenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
                NecromancerRenderDispatcher.begin();
            } else if (stage == VeilRenderLevelStageEvent.Stage.AFTER_ENTITIES) {
                NecromancerRenderDispatcher.end();
            }
        });
        VeilEventPlatform.INSTANCE.onVeilDynamicBuffersChanged(change -> {
            if (SodiumCompat.INSTANCE != null) {
                SodiumCompat.INSTANCE.setActiveBuffers(change.getEnabledBuffersMask());
            }
            if (change.hasChanged(DynamicBufferType.NORMAL)) {
                VeilRenderSystem.rebuildChunks();
            }
            UNIFORM_BLOCK_STATE.onShaderCompile();
        });
    }

    @ApiStatus.Internal
    public static void init() {
        class_310 client = class_310.method_1551();
        class_3300 class_33002 = client.method_1478();
        if (!(class_33002 instanceof class_3304)) {
            throw new IllegalStateException("Client resource manager is " + String.valueOf(client.method_1478().getClass()));
        }
        class_3304 resourceManager = (class_3304)class_33002;
        class_1041 window = client.method_22683();
        renderer = new VeilRenderer(resourceManager, window);
        VeilImGuiImpl.init(window.method_4490());
        screenQuadVao = VeilRenderSystem.directStateAccessSupported() ? ARBDirectStateAccess.glCreateVertexArrays() : GL43C.glGenVertexArrays();
        VeilDebug.get().objectLabel(32884, screenQuadVao, "Screen Quad Vertex Array");
        emptySamplers = MemoryUtil.memCallocInt((int)VeilRenderSystem.maxCombinedTextureUnits());
    }

    @ApiStatus.Internal
    public static void beginFrame() {
        if (pendingFontRebuild) {
            pendingFontRebuild = false;
            renderer.getEditorManager().rebuildFonts();
        }
        VeilImGuiImpl.get().beginFrame();
        SHADER_BUFFER_CACHE.bind();
    }

    @ApiStatus.Internal
    public static void endFrame() {
        VeilImGuiImpl.get().endFrame();
        if (Veil.platform().hasErrors()) {
            return;
        }
        renderer.endFrame();
        if (!FramebufferStack.isEmpty()) {
            Veil.LOGGER.error("Did not pop all bound framebuffers");
            FramebufferStack.clear();
            AdvancedFbo.unbind();
        }
        VeilRenderProfilerImpl.endFrame();
        UNIFORM_BLOCK_STATE.clearUsedBindings();
        VanillaShaderCompiler.clear();
        VeilDebug.MESSAGE_ID.set(0);
    }

    @ApiStatus.Internal
    public static void rebuildFonts() {
        pendingFontRebuild = true;
    }

    @ApiStatus.Internal
    public static void clearShaderBlocks() {
        SHADER_BUFFER_CACHE.unbindPacked();
    }

    @ApiStatus.Internal
    public static void shaderUpdate() {
        shaderLocation = null;
    }

    @ApiStatus.Internal
    public static void resize(int width, int height) {
        if (renderer != null) {
            renderer.resize(width, height);
        }
    }

    @ApiStatus.Internal
    public static void close() {
        VeilImGui veilImGui = VeilImGuiImpl.get();
        if (veilImGui instanceof NativeResource) {
            NativeResource resource = (NativeResource)veilImGui;
            resource.free();
        }
        if (renderer != null) {
            renderer.free();
        }
        GL43C.glDeleteVertexArrays((int)screenQuadVao);
        MemoryUtil.memFree((Buffer)emptySamplers);
        SHADER_BUFFER_CACHE.free();
    }

    @ApiStatus.Internal
    public static void renderPost(@Nullable VeilRenderLevelStageEvent.Stage stage) {
        if (stage == VeilRenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES || stage == VeilRenderLevelStageEvent.Stage.AFTER_LEVEL) {
            VeilDebug debug = VeilDebug.get();
            debug.pushDebugGroup("Veil Draw Bloom");
            VeilBloomRenderer.flush();
            debug.popDebugGroup();
        }
        renderer.getPostProcessingManager().runDefaultPipeline(stage);
    }

    @ApiStatus.Internal
    public static void setShaderLights(Vector3fc light0, Vector3fc light1) {
        LIGHT0_DIRECTION.set(light0);
        LIGHT1_DIRECTION.set(light1);
    }

    @ApiStatus.Internal
    public static void setCameraBobOffset(Vector3fc offset) {
        CAMERA_BOB_OFFSET.set(offset);
    }

    @ApiStatus.Internal
    public static boolean drawLights(class_3695 profiler, CullFrustum cullFrustum) {
        FramebufferManager framebufferManager = renderer.getFramebufferManager();
        AdvancedFbo lightFbo = framebufferManager.getFramebuffer(VeilFramebuffers.LIGHT);
        if (lightFbo == null) {
            AdvancedFbo.unbind();
            return false;
        }
        VeilDebug debug = VeilDebug.get();
        debug.pushDebugGroup("Veil Draw Lights");
        VeilRenderProfiler renderProfiler = VeilRenderProfiler.get();
        renderProfiler.push("veil_lights", RenderProfilerCounter.VERTICES_SUBMITTED, RenderProfilerCounter.PRIMITIVES_SUBMITTED, RenderProfilerCounter.VERTEX_SHADER_INVOCATIONS, RenderProfilerCounter.FRAGMENT_SHADER_INVOCATIONS, RenderProfilerCounter.COMPUTE_SHADER_INVOCATIONS, RenderProfilerCounter.CLIPPING_INPUT_PRIMITIVES, RenderProfilerCounter.CLIPPING_OUTPUT_PRIMITIVES);
        LightRenderer lightRenderer = renderer.getLightRenderer();
        profiler.method_15396("draw_lights");
        boolean rendered = lightRenderer.render(cullFrustum, lightFbo);
        profiler.method_15407();
        renderProfiler.pop();
        debug.popDebugGroup();
        return rendered;
    }

    @ApiStatus.Internal
    public static void compositeLights(class_3695 profiler) {
        VeilDebug debug = VeilDebug.get();
        debug.pushDebugGroup("Veil Composite Lights");
        PostProcessingManager postProcessingManager = renderer.getPostProcessingManager();
        PostPipeline compositePipeline = postProcessingManager.getPipeline(VeilRenderer.COMPOSITE);
        if (compositePipeline != null) {
            profiler.method_15396("composite_lights");
            postProcessingManager.runPipeline(compositePipeline);
            profiler.method_15407();
        }
        debug.popDebugGroup();
    }

    @ApiStatus.Internal
    public static void clearLevel() {
        NecromancerRenderDispatcher.delete();
    }
}

