/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.editor.EditorManager;
import foundry.veil.api.client.render.CameraMatrices;
import foundry.veil.api.client.render.GuiInfo;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import foundry.veil.api.client.render.post.PostProcessingManager;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.ShaderModificationManager;
import foundry.veil.api.client.render.shader.ShaderPreDefinitions;
import foundry.veil.api.quasar.particle.ParticleSystemManager;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManager;
import foundry.veil.impl.client.render.dynamicbuffer.VanillaShaderCompiler;
import foundry.veil.impl.client.render.pipeline.VeilBloomRenderer;
import foundry.veil.impl.client.render.pipeline.VeilFirstPersonRenderer;
import foundry.veil.impl.client.render.rendertype.DynamicRenderTypeManager;
import foundry.veil.mixin.pipeline.accessor.PipelineReloadableResourceManagerAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_4013;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class VeilRenderer
implements class_4013 {
    public static final class_2960 ALBEDO_BUFFER_TEXTURE = Veil.veilPath("dynamic_buffer/albedo");
    public static final class_2960 NORMAL_BUFFER_TEXTURE = Veil.veilPath("dynamic_buffer/normal");
    public static final class_2960 LIGHT_UV_BUFFER_TEXTURE = Veil.veilPath("dynamic_buffer/light_uv");
    public static final class_2960 LIGHT_COLOR_BUFFER_TEXTURE = Veil.veilPath("dynamic_buffer/light_color");
    public static final class_2960 DEBUG_BUFFER_TEXTURE = Veil.veilPath("dynamic_buffer/debug");
    public static final class_2960 COMPOSITE = Veil.veilPath("core/composite");
    private final VanillaShaderCompiler vanillaShaderCompiler = new VanillaShaderCompiler();
    private final DynamicBufferManager dynamicBufferManager;
    private final ShaderModificationManager shaderModificationManager;
    private final ShaderPreDefinitions shaderPreDefinitions;
    private final ShaderManager shaderManager;
    private final FramebufferManager framebufferManager;
    private final PostProcessingManager postProcessingManager;
    private final DynamicRenderTypeManager dynamicRenderTypeManager;
    private final ParticleSystemManager quasarParticleManager;
    private final EditorManager editorManager;
    private final CameraMatrices cameraMatrices;
    private final LightRenderer lightRenderer;
    private final GuiInfo guiInfo;

    @ApiStatus.Internal
    public VeilRenderer(class_3304 resourceManager, class_1041 window) {
        this.dynamicBufferManager = new DynamicBufferManager(window.method_4489(), window.method_4506());
        this.shaderPreDefinitions = new ShaderPreDefinitions();
        this.shaderModificationManager = new ShaderModificationManager();
        this.shaderManager = new ShaderManager(ShaderManager.PROGRAM_SET, this.shaderPreDefinitions, this.dynamicBufferManager);
        this.framebufferManager = new FramebufferManager();
        this.postProcessingManager = new PostProcessingManager();
        this.dynamicRenderTypeManager = new DynamicRenderTypeManager();
        this.quasarParticleManager = new ParticleSystemManager();
        this.editorManager = new EditorManager(resourceManager);
        this.cameraMatrices = new CameraMatrices();
        this.lightRenderer = new LightRenderer();
        this.guiInfo = new GuiInfo();
        List<class_3302> listeners = ((PipelineReloadableResourceManagerAccessor)resourceManager).getListeners();
        listeners.add(0, (class_3302)this.shaderModificationManager);
        listeners.add(1, this.shaderManager);
        resourceManager.method_14477((class_3302)this.framebufferManager);
        resourceManager.method_14477((class_3302)this.postProcessingManager);
        resourceManager.method_14477((class_3302)this.dynamicRenderTypeManager);
        resourceManager.method_14477((class_3302)this);
    }

    @ApiStatus.Internal
    public void addDebugInfo(Consumer<String> consumer) {
        consumer.accept("");
        consumer.accept(String.valueOf(class_124.field_1073) + "Veil");
        this.lightRenderer.addDebugInfo(consumer);
        int mask = this.dynamicBufferManager.getActiveBuffers();
        if (mask != 0) {
            String buffers = Arrays.stream(DynamicBufferType.decode(mask)).map(DynamicBufferType::getName).collect(Collectors.joining(", "));
            consumer.accept("Active Buffers: " + buffers);
        }
    }

    public boolean enableBuffers(class_2960 name, DynamicBufferType ... buffers) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (buffers.length == 0) {
            return false;
        }
        return this.dynamicBufferManager.setActiveBuffers(name, DynamicBufferType.encode(buffers));
    }

    public boolean disableBuffers(class_2960 name, DynamicBufferType ... buffers) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (buffers.length == 0) {
            return false;
        }
        int active = this.dynamicBufferManager.getActiveBuffers(name) & ~DynamicBufferType.encode(buffers);
        return this.dynamicBufferManager.setActiveBuffers(name, active);
    }

    public boolean disableBuffers(class_2960 name) {
        RenderSystem.assertOnRenderThreadOrInit();
        return this.dynamicBufferManager.setActiveBuffers(name, 0);
    }

    public int getActiveBuffers() {
        return this.dynamicBufferManager.getActiveBuffers();
    }

    public VanillaShaderCompiler getVanillaShaderCompiler() {
        return this.vanillaShaderCompiler;
    }

    @ApiStatus.Internal
    public DynamicBufferManager getDynamicBufferManger() {
        return this.dynamicBufferManager;
    }

    public ShaderModificationManager getShaderModificationManager() {
        return this.shaderModificationManager;
    }

    public ShaderPreDefinitions getShaderDefinitions() {
        return this.shaderPreDefinitions;
    }

    public ShaderManager getShaderManager() {
        return this.shaderManager;
    }

    public FramebufferManager getFramebufferManager() {
        return this.framebufferManager;
    }

    public PostProcessingManager getPostProcessingManager() {
        return this.postProcessingManager;
    }

    @ApiStatus.Internal
    public DynamicRenderTypeManager getDynamicRenderTypeManager() {
        return this.dynamicRenderTypeManager;
    }

    public ParticleSystemManager getParticleManager() {
        return this.quasarParticleManager;
    }

    public EditorManager getEditorManager() {
        return this.editorManager;
    }

    public CameraMatrices getCameraMatrices() {
        return this.cameraMatrices;
    }

    public LightRenderer getLightRenderer() {
        return this.lightRenderer;
    }

    public GuiInfo getGuiInfo() {
        return this.guiInfo;
    }

    @ApiStatus.Internal
    public void resize(int width, int height) {
        this.framebufferManager.resizeFramebuffers(width, height);
        this.dynamicBufferManager.resizeFramebuffers(width, height);
        VeilFirstPersonRenderer.free();
        VeilBloomRenderer.free();
    }

    @ApiStatus.Internal
    public void endFrame() {
        this.framebufferManager.clear();
        this.dynamicBufferManager.clear();
        this.postProcessingManager.endFrame();
    }

    @ApiStatus.Internal
    public void free() {
        this.dynamicBufferManager.free();
        this.shaderManager.close();
        this.framebufferManager.free();
        this.postProcessingManager.free();
        this.quasarParticleManager.clear();
        this.lightRenderer.free();
    }

    public void method_14491(@NotNull class_3300 resourceManager) {
        VeilBloomRenderer.tryEnable();
    }
}

