/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.post;

import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.CodecReloadListener;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.ext.VeilDebug;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferStack;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.post.stage.CompositePostPipeline;
import foundry.veil.api.client.render.profiler.RenderProfilerCounter;
import foundry.veil.api.client.render.profiler.VeilRenderProfiler;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.impl.client.render.pipeline.PostPipelineContext;
import foundry.veil.platform.VeilClientPlatform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_7654;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public class PostProcessingManager
extends CodecReloadListener<CompositePostPipeline>
implements NativeResource {
    private static final Comparator<ProfileEntry> PIPELINE_SORTER = Comparator.comparingInt(ProfileEntry::getPriority).reversed();
    private static final class_2960 POST = Veil.veilPath("post");
    private final PostPipelineContext context = new PostPipelineContext();
    private final List<ProfileEntry> activePipelines = new LinkedList<ProfileEntry>();
    private final List<ProfileEntry> activePipelinesView = Collections.unmodifiableList(this.activePipelines);
    private final Map<class_2960, CompositePostPipeline> pipelines = new HashMap<class_2960, CompositePostPipeline>();
    private boolean pipelinesDirty = false;
    private int enabledBuffers = 0;

    public PostProcessingManager() {
        super(CompositePostPipeline.CODEC, class_7654.method_45114((String)"pinwheel/post"));
    }

    public boolean isActive(class_2960 pipeline) {
        for (ProfileEntry entry : this.activePipelines) {
            if (!entry.pipeline.equals((Object)pipeline)) continue;
            return true;
        }
        return false;
    }

    public boolean add(class_2960 pipeline) {
        return this.add(1000, pipeline);
    }

    public boolean add(int priority, class_2960 pipeline) {
        ListIterator<ProfileEntry> iterator = this.activePipelines.listIterator();
        while (iterator.hasNext()) {
            ProfileEntry entry = iterator.next();
            if (!entry.pipeline.equals((Object)pipeline)) continue;
            if (entry.priority == priority) {
                return false;
            }
            iterator.set(new ProfileEntry(pipeline, priority));
            this.pipelinesDirty = true;
            return true;
        }
        this.activePipelines.add(new ProfileEntry(pipeline, priority));
        this.pipelinesDirty = true;
        return true;
    }

    public boolean remove(class_2960 pipeline) {
        Iterator<ProfileEntry> iterator = this.activePipelines.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().pipeline.equals((Object)pipeline)) continue;
            iterator.remove();
            this.pipelinesDirty = true;
            return true;
        }
        return false;
    }

    @Nullable
    public PostPipeline getPipeline(class_2960 pipeline) {
        return this.pipelines.get(pipeline);
    }

    @ApiStatus.Internal
    public void endFrame() {
        VeilRenderSystem.renderer().getDynamicBufferManger().setActiveBuffers(POST, this.enabledBuffers);
    }

    private void setup() {
        VeilRenderProfiler.get().push("veil_post", RenderProfilerCounter.FRAGMENT_SHADER_INVOCATIONS);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        FramebufferStack.push(POST);
    }

    private void clear() {
        ShaderProgram.unbind();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        FramebufferStack.pop(POST);
        VeilRenderProfiler.get().pop();
    }

    private void clearPipeline() {
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthFunc((int)519);
        RenderSystem.depthMask((boolean)false);
    }

    @ApiStatus.Internal
    public void runDefaultPipeline(@Nullable VeilRenderLevelStageEvent.Stage stage) {
        if (this.activePipelines.isEmpty()) {
            return;
        }
        VeilDebug debug = VeilDebug.get();
        if (stage != null) {
            debug.pushDebugGroup("Veil Post Processing (" + stage.getName() + ")");
        } else {
            debug.pushDebugGroup("Veil Post Processing");
        }
        VeilRenderer renderer = VeilRenderSystem.renderer();
        AdvancedFbo postFramebuffer = renderer.getFramebufferManager().getFramebuffer(VeilFramebuffers.POST);
        VeilClientPlatform platform = VeilClient.clientPlatform();
        this.context.begin();
        this.setup();
        int activeTexture = GlStateManager._getActiveTexture();
        if (this.pipelinesDirty) {
            this.pipelinesDirty = false;
            this.activePipelines.sort(PIPELINE_SORTER);
        }
        for (ProfileEntry entry : this.activePipelines) {
            class_2960 id = entry.getPipeline();
            CompositePostPipeline pipeline = this.pipelines.get(id);
            if (pipeline == null) continue;
            this.enabledBuffers |= pipeline.getDynamicBuffersMask();
            if ((renderer.getDynamicBufferManger().getActiveBuffers() & this.enabledBuffers) != this.enabledBuffers || pipeline.getRenderStage() != stage) continue;
            platform.preVeilPostProcessing(id, pipeline, this.context);
            try {
                pipeline.apply(this.context);
                this.clearPipeline();
                if (postFramebuffer != null) {
                    postFramebuffer.resolveToRenderTarget(class_310.method_1551().method_1522(), 16384, 9728);
                }
            }
            catch (Exception e) {
                Veil.LOGGER.error("Error running pipeline {}", (Object)id, (Object)e);
            }
            platform.postVeilPostProcessing(id, pipeline, this.context);
        }
        RenderSystem.activeTexture((int)activeTexture);
        this.clear();
        this.context.end();
        debug.popDebugGroup();
    }

    public void runPipeline(PostPipeline pipeline) {
        this.runPipeline(pipeline, true);
    }

    public void runPipeline(PostPipeline pipeline, boolean resolvePost) {
        AdvancedFbo postFramebuffer;
        VeilRenderer renderer = VeilRenderSystem.renderer();
        if (pipeline instanceof CompositePostPipeline) {
            CompositePostPipeline compositePostPipeline = (CompositePostPipeline)pipeline;
            this.enabledBuffers |= compositePostPipeline.getDynamicBuffersMask();
            if ((renderer.getDynamicBufferManger().getActiveBuffers() & this.enabledBuffers) != this.enabledBuffers) {
                return;
            }
        }
        this.context.begin();
        this.setup();
        int activeTexture = GlStateManager._getActiveTexture();
        try {
            pipeline.apply(this.context);
            this.clearPipeline();
        }
        catch (Exception e) {
            Veil.LOGGER.error("Error running pipeline {}", (Object)pipeline, (Object)e);
        }
        RenderSystem.activeTexture((int)activeTexture);
        this.clear();
        this.context.end();
        AdvancedFbo advancedFbo = postFramebuffer = resolvePost ? renderer.getFramebufferManager().getFramebuffer(VeilFramebuffers.POST) : null;
        if (postFramebuffer != null) {
            postFramebuffer.resolveToRenderTarget(class_310.method_1551().method_1522(), 16384, 9728);
        }
    }

    public static void resolvePost(@Nullable AdvancedFbo framebuffer) {
        PostProcessingManager.resolvePost(framebuffer, 16384);
    }

    public static void resolvePost(@Nullable AdvancedFbo framebuffer, int mask) {
        AdvancedFbo postFramebuffer;
        if (framebuffer != null && (postFramebuffer = VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(VeilFramebuffers.POST)) != null) {
            postFramebuffer.resolveToAdvancedFbo(framebuffer, mask, 9728);
        }
    }

    private CompositePostPipeline loadPipeline(class_3298 resource) throws IOException {
        try (BufferedReader reader = resource.method_43039();){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            DataResult result = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (result.error().isPresent()) {
                throw new JsonSyntaxException(((DataResult.Error)result.error().get()).message());
            }
            CompositePostPipeline compositePostPipeline = (CompositePostPipeline)result.result().orElseThrow();
            return compositePostPipeline;
        }
    }

    @Override
    @NotNull
    protected Map<class_2960, CompositePostPipeline> prepare(@NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        HashMap<class_2960, CompositePostPipeline> data = new HashMap<class_2960, CompositePostPipeline>();
        Map resources = this.converter.method_45116(resourceManager);
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            class_2960 id = this.converter.method_45115(location);
            if (((List)entry.getValue()).size() == 1) {
                try {
                    data.put(id, this.loadPipeline((class_3298)Iterables.getOnlyElement((Iterable)((Iterable)entry.getValue()))));
                }
                catch (Exception e) {
                    Veil.LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, location, e});
                }
                continue;
            }
            List<CompositePostPipeline> pipelines = new ArrayList<CompositePostPipeline>(((List)entry.getValue()).size());
            for (class_3298 resource : (List)entry.getValue()) {
                try {
                    pipelines.add(this.loadPipeline(resource));
                }
                catch (Exception e) {
                    Veil.LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, location, e});
                }
            }
            if (pipelines.isEmpty()) continue;
            if (pipelines.size() == 1) {
                data.put(id, (CompositePostPipeline)Iterables.getOnlyElement(pipelines));
                continue;
            }
            int dynamicBuffers = 0;
            pipelines.sort(Comparator.comparingInt(CompositePostPipeline::getPriority));
            for (int i = 0; i < pipelines.size(); ++i) {
                CompositePostPipeline pipeline = (CompositePostPipeline)pipelines.get(i);
                dynamicBuffers |= pipeline.getDynamicBuffersMask();
                if (!pipeline.isReplace()) continue;
                pipelines = pipelines.subList(0, i + 1);
                break;
            }
            data.put(id, new CompositePostPipeline((PostPipeline[])pipelines.toArray(CompositePostPipeline[]::new), Collections.emptyMap(), Collections.emptyMap(), ((CompositePostPipeline)pipelines.getFirst()).getRenderStage(), dynamicBuffers));
        }
        return data;
    }

    protected void apply(@NotNull Map<class_2960, CompositePostPipeline> data, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        this.free();
        this.pipelines.putAll(data);
        Veil.LOGGER.info("Loaded {} post pipelines", (Object)this.pipelines.size());
    }

    public void free() {
        this.pipelines.values().forEach(PostPipeline::free);
        this.pipelines.clear();
    }

    public PostPipeline.Context getPostPipelineContext() {
        return this.context;
    }

    @NotNull
    public Set<class_2960> getPipelines() {
        return this.pipelines.keySet();
    }

    public List<ProfileEntry> getActivePipelines() {
        if (this.pipelinesDirty) {
            this.pipelinesDirty = false;
            this.activePipelines.sort(PIPELINE_SORTER);
        }
        return this.activePipelinesView;
    }

    public static class ProfileEntry {
        private final class_2960 pipeline;
        private int priority;

        public ProfileEntry(class_2960 pipeline, int priority) {
            this.pipeline = pipeline;
            this.priority = priority;
        }

        public class_2960 getPipeline() {
            return this.pipeline;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProfileEntry that = (ProfileEntry)o;
            return this.priority == that.priority && Objects.equals(this.pipeline, that.pipeline);
        }

        public int hashCode() {
            int result = this.pipeline.hashCode();
            result = 31 * result + this.priority;
            return result;
        }
    }
}

