/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.post.stage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.client.registry.PostPipelineStageRegistry;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferDefinition;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import foundry.veil.api.client.render.shader.uniform.ShaderUniformAccess;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.impl.client.render.shader.program.ShaderProgramImpl;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public final class CompositePostPipeline
implements PostPipeline {
    private static final Codec<Map<class_2960, FramebufferDefinition>> FRAMEBUFFER_CODEC = Codec.unboundedMap((Codec)Codec.STRING.xmap(name -> class_2960.method_60655((String)"temp", (String)name), class_2960::method_12832), FramebufferDefinition.CODEC);
    public static final Codec<CompositePostPipeline> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PostPipeline.CODEC.listOf().fieldOf("stages").forGetter(pipeline -> Arrays.asList(pipeline.getStages())), (App)Codec.unboundedMap((Codec)Codec.STRING, ShaderTextureSource.CODEC).optionalFieldOf("textures", Collections.emptyMap()).forGetter(CompositePostPipeline::getTextureSources), (App)FRAMEBUFFER_CODEC.optionalFieldOf("framebuffers", Collections.emptyMap()).forGetter(CompositePostPipeline::getFramebuffers), (App)VeilRenderLevelStageEvent.Stage.CODEC.optionalFieldOf("renderStage").forGetter(pipeline -> Optional.ofNullable(pipeline.getRenderStage())), (App)DynamicBufferType.PACKED_LIST_CODEC.optionalFieldOf("dynamicBuffers", (Object)0).forGetter(CompositePostPipeline::getDynamicBuffersMask), (App)Codec.INT.optionalFieldOf("priority", (Object)1000).forGetter(CompositePostPipeline::getPriority), (App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(CompositePostPipeline::isReplace)).apply((Applicative)instance, (pipelines, textures, framebuffers, renderStage, dynamicBuffers, priority, replace) -> new CompositePostPipeline((PostPipeline[])pipelines.toArray(PostPipeline[]::new), (Map<String, ShaderTextureSource>)textures, (Map<class_2960, FramebufferDefinition>)framebuffers, renderStage.orElse(null), (int)dynamicBuffers, (int)priority, (boolean)replace)));
    private final PostPipeline[] stages;
    private final Map<String, ShaderTextureSource> textureSources;
    private final Map<String, ShaderProgramImpl.ShaderTexture> samplers;
    private final Map<class_2960, FramebufferDefinition> framebufferDefinitions;
    private final VeilRenderLevelStageEvent.Stage renderStage;
    private final Map<class_2960, AdvancedFbo> framebuffers;
    private final Map<String, ShaderUniformAccess> uniforms;
    private final DynamicBufferType[] dynamicBuffers;
    private final int dynamicBuffersMask;
    private final int priority;
    private final boolean replace;
    private int screenWidth = -1;
    private int screenHeight = -1;

    private CompositePostPipeline(PostPipeline[] stages, Map<String, ShaderTextureSource> samplers, Map<class_2960, FramebufferDefinition> framebufferDefinitions, @Nullable VeilRenderLevelStageEvent.Stage renderStage, int dynamicBuffers, int priority, boolean replace) {
        this.stages = stages;
        this.textureSources = Collections.unmodifiableMap(samplers);
        this.samplers = new Object2ObjectArrayMap(samplers.size());
        class_310.method_1551().execute(() -> {
            for (Map.Entry entry : samplers.entrySet()) {
                this.samplers.put((String)entry.getKey(), ShaderProgramImpl.ShaderTexture.create((ShaderTextureSource)entry.getValue()));
            }
        });
        this.framebufferDefinitions = Collections.unmodifiableMap(framebufferDefinitions);
        this.renderStage = renderStage;
        this.framebuffers = new Object2ObjectArrayMap();
        this.uniforms = new Object2ObjectArrayMap();
        this.dynamicBuffers = DynamicBufferType.decode(dynamicBuffers);
        this.dynamicBuffersMask = dynamicBuffers;
        this.priority = priority;
        this.replace = replace;
    }

    public CompositePostPipeline(PostPipeline[] stages, Map<String, ShaderTextureSource> samplers, Map<class_2960, FramebufferDefinition> framebufferDefinitions, @Nullable VeilRenderLevelStageEvent.Stage renderStage, int dynamicBuffers) {
        this(stages, samplers, framebufferDefinitions, renderStage, dynamicBuffers, 1000, false);
    }

    @Override
    public void apply(PostPipeline.Context context) {
        AdvancedFbo main = context.getDrawFramebuffer();
        if (this.screenWidth != main.getWidth() || this.screenHeight != main.getHeight()) {
            this.screenWidth = main.getWidth();
            this.screenHeight = main.getHeight();
            this.framebuffers.values().forEach(NativeResource::free);
            this.framebuffers.clear();
            MolangRuntime runtime = (MolangRuntime)MolangRuntime.runtime().setQuery("screen_width", (float)this.screenWidth).setQuery("screen_height", (float)this.screenHeight).create();
            this.framebufferDefinitions.forEach((name, definition) -> this.framebuffers.put((class_2960)name, definition.createBuilder((MolangEnvironment)runtime).setDebugLabel("Temp " + String.valueOf(name)).build(true)));
        }
        this.framebuffers.forEach(context::setFramebuffer);
        for (DynamicBufferType buffer : this.dynamicBuffers) {
            context.setSampler(buffer.getSourceName(), VeilRenderSystem.renderer().getDynamicBufferManger().getBufferTexture(buffer), 0);
        }
        for (Map.Entry entry : this.samplers.entrySet()) {
            ShaderProgramImpl.ShaderTexture texture = (ShaderProgramImpl.ShaderTexture)entry.getValue();
            context.setSampler((CharSequence)entry.getKey(), texture.textureSource().getId(context), texture.samplerId());
        }
        for (PostPipeline pipeline : this.stages) {
            pipeline.apply(context);
        }
    }

    @Override
    public void free() {
        for (PostPipeline pipeline : this.stages) {
            pipeline.free();
        }
        this.framebuffers.values().forEach(NativeResource::free);
        this.framebuffers.clear();
    }

    @Override
    public PostPipelineStageRegistry.PipelineType<? extends PostPipeline> getType() {
        throw new UnsupportedOperationException("Composite pipelines cannot be encoded");
    }

    @Override
    public boolean hasUniform(CharSequence name) {
        for (PostPipeline pipeline : this.stages) {
            if (!pipeline.hasUniform(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ShaderUniformAccess getUniform(CharSequence name) {
        ShaderUniformAccess uniform = this.getOrCreateUniform(name);
        return uniform == ShaderUniformAccess.EMPTY ? null : uniform;
    }

    @Override
    public ShaderUniformAccess getUniformSafe(CharSequence name) {
        return this.getOrCreateUniform(name);
    }

    @Override
    public ShaderUniformAccess getOrCreateUniform(CharSequence name) {
        return this.uniforms.computeIfAbsent(name.toString(), key -> ShaderUniformAccess.of((ShaderUniformAccess[])Arrays.stream(this.stages).map(pipeline -> pipeline.getOrCreateUniform((CharSequence)key)).toArray(ShaderUniformAccess[]::new)));
    }

    @Override
    public boolean hasUniformBlock(CharSequence name) {
        for (PostPipeline pipeline : this.stages) {
            if (!pipeline.hasUniformBlock(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasStorageBlock(CharSequence name) {
        for (PostPipeline pipeline : this.stages) {
            if (!pipeline.hasStorageBlock(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setUniformBlock(CharSequence name, int binding) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setUniformBlock(name, binding);
        }
    }

    @Override
    public void setStorageBlock(CharSequence name, int binding) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setStorageBlock(name, binding);
        }
    }

    public PostPipeline[] getStages() {
        return this.stages;
    }

    public Map<String, ShaderTextureSource> getTextureSources() {
        return this.textureSources;
    }

    public Map<class_2960, FramebufferDefinition> getFramebuffers() {
        return this.framebufferDefinitions;
    }

    public DynamicBufferType[] getDynamicBuffers() {
        return this.dynamicBuffers;
    }

    @Nullable
    public VeilRenderLevelStageEvent.Stage getRenderStage() {
        return this.renderStage;
    }

    public int getDynamicBuffersMask() {
        return this.dynamicBuffersMask;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isReplace() {
        return this.replace;
    }
}

