/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.rendertype.layer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.class_151;
import net.minecraft.class_2960;

public sealed interface LayerTemplateValue<T> {
    public static final Codec<LayerTemplateValue<String>> STRING_CODEC = Codec.STRING.xmap(name -> {
        if (name.contains("%")) {
            return new FormattedValue<String>((String)name, formatted -> formatted);
        }
        return new RawValue<String>((String)name, (String)name);
    }, LayerTemplateValue::rawValue);
    public static final Codec<LayerTemplateValue<class_2960>> LOCATION_CODEC = Codec.STRING.flatXmap(name -> {
        if (name.contains("%")) {
            return DataResult.success(new FormattedValue<class_2960>((String)name, class_2960::method_60654));
        }
        return class_2960.method_29186((String)name).map(loc -> new RawValue<class_2960>(loc.toString(), (class_2960)loc));
    }, value -> DataResult.success((Object)value.rawValue()));

    public String rawValue();

    public T parse(Object ... var1) throws IllegalFormatException, class_151;

    public static <T extends Enum<T>> Codec<LayerTemplateValue<T>> enumCodec(Class<T> clazz) {
        Enum[] values = (Enum[])clazz.getEnumConstants();
        CharSequence[] names = (String[])Arrays.stream(values).map(value -> value.name().toLowerCase()).toArray(String[]::new);
        String name = clazz.getSimpleName();
        String options = ". Valid options: " + String.join((CharSequence)", ", names);
        return Codec.STRING.xmap(arg_0 -> LayerTemplateValue.lambda$enumCodec$8((String[])names, values, name, options, arg_0), LayerTemplateValue::rawValue);
    }

    public static <T extends Enum<T>> RawValue<T> raw(T value) {
        return new RawValue<T>(value.name().toLowerCase(Locale.ROOT), value);
    }

    private static /* synthetic */ LayerTemplateValue lambda$enumCodec$8(String[] names, Enum[] values, String name, String options, String value) {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equalsIgnoreCase(value)) continue;
            return new RawValue<Enum>(value, values[i]);
        }
        return new FormattedValue<Enum>(value, formattedValue -> {
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equalsIgnoreCase((String)formattedValue)) continue;
                return values[i];
            }
            throw new IllegalStateException("Unknown " + name + ": " + value + options);
        });
    }

    public record RawValue<T>(String rawValue, T value) implements LayerTemplateValue<T>
    {
        @Override
        public T parse(Object ... params) {
            return this.value;
        }
    }

    public record FormattedValue<T>(String rawValue, Function<String, T> decoder) implements LayerTemplateValue<T>
    {
        @Override
        public T parse(Object ... params) {
            return this.decoder.apply(String.format(this.rawValue, params));
        }
    }
}

