/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.processor;

import foundry.veil.api.client.registry.VeilShaderBufferRegistry;
import foundry.veil.api.client.render.VeilShaderBufferLayout;
import foundry.veil.api.client.render.shader.ShaderFeature;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import io.github.ocelot.glslprocessor.api.GlslSyntaxException;
import io.github.ocelot.glslprocessor.api.node.GlslTree;
import io.github.ocelot.glslprocessor.lib.anarres.cpp.LexerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_151;
import net.minecraft.class_2960;

public class ShaderBufferProcessor
implements ShaderPreProcessor {
    private static final String BUFFER_KEY = "#veil:buffer ";

    @Override
    public void modify(ShaderPreProcessor.Context ctx, GlslTree tree) throws IOException, GlslSyntaxException, LexerException {
        ArrayList<String> buffers = new ArrayList<String>();
        List directives = tree.getDirectives();
        for (String directive : directives) {
            if (!directive.startsWith(BUFFER_KEY)) continue;
            buffers.add(directive);
        }
        for (String directive : buffers) {
            String[] parts = directive.substring(BUFFER_KEY.length()).split(" +", 2);
            String bufferId = parts[0].trim();
            String interfaceName = parts.length > 1 ? parts[1].trim() : null;
            try {
                class_2960 name = class_2960.method_60654((String)bufferId);
                VeilShaderBufferLayout layout = (VeilShaderBufferLayout)VeilShaderBufferRegistry.REGISTRY.method_10223(name);
                if (layout == null) {
                    throw new IOException("Unknown buffer: " + String.valueOf(name));
                }
                GlslTree loadedImport = new GlslTree();
                loadedImport.getBody().add(layout.createNode(ctx.hasFeatures(ShaderFeature.SHADER_STORAGE), interfaceName));
                ctx.include(tree, "#buffer " + String.valueOf(name), loadedImport, ShaderPreProcessor.IncludeOverloadStrategy.INCLUDE);
            }
            catch (class_151 e) {
                throw new IOException("Invalid buffer: " + bufferId, e);
            }
        }
        directives.removeAll(buffers);
    }
}

