/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.processor;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.ShaderFeature;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.processor.ShaderImporter;
import foundry.veil.api.client.render.shader.processor.ShaderMultiProcessor;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import io.github.ocelot.glslprocessor.api.GlslSyntaxException;
import io.github.ocelot.glslprocessor.api.node.GlslNode;
import io.github.ocelot.glslprocessor.api.node.GlslRootNode;
import io.github.ocelot.glslprocessor.api.node.GlslTree;
import io.github.ocelot.glslprocessor.api.node.function.GlslFunctionNode;
import io.github.ocelot.glslprocessor.api.node.variable.GlslNewFieldNode;
import io.github.ocelot.glslprocessor.lib.anarres.cpp.LexerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public interface ShaderPreProcessor {
    public static final ShaderPreProcessor NOOP = (ctx, source) -> {};

    default public void prepare() {
    }

    public void modify(Context var1, GlslTree var2) throws IOException, GlslSyntaxException, LexerException;

    public static ShaderPreProcessor allOf(ShaderPreProcessor ... processors) {
        return ShaderPreProcessor.allOf(Arrays.asList(processors));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ShaderPreProcessor allOf(Collection<ShaderPreProcessor> processors) {
        ArrayList<ShaderPreProcessor> list = new ArrayList<ShaderPreProcessor>(processors.size());
        for (ShaderPreProcessor processor : processors) {
            if (processor instanceof ShaderMultiProcessor) {
                ShaderMultiProcessor shaderMultiProcessor = (ShaderMultiProcessor)processor;
                try {
                    ShaderPreProcessor[] shaderPreProcessorArray;
                    ShaderPreProcessor[] values = shaderPreProcessorArray = shaderMultiProcessor.processors();
                    list.addAll(Arrays.asList(values));
                    continue;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            if (processor == NOOP) continue;
            list.add(processor);
        }
        if (list.isEmpty()) {
            return NOOP;
        }
        if (list.size() == 1) {
            return (ShaderPreProcessor)list.getFirst();
        }
        return new ShaderMultiProcessor((ShaderPreProcessor[])list.toArray(ShaderPreProcessor[]::new));
    }

    public static enum IncludeOverloadStrategy {
        FAIL,
        SOURCE,
        INCLUDE;

    }

    public static non-sealed interface SodiumContext
    extends Context {
    }

    public static non-sealed interface VeilContext
    extends Context {
        public void addUniformBinding(String var1, int var2);

        public void addDefinitionDependency(String var1);

        public boolean isDynamic();

        @Nullable
        public ProgramDefinition definition();
    }

    public static non-sealed interface MinecraftContext
    extends Context {
        public String shaderInstance();

        public class_293 vertexFormat();
    }

    public static sealed interface Context
    permits MinecraftContext, VeilContext, SodiumContext {
        public GlslTree modifyInclude(@Nullable class_2960 var1, String var2) throws IOException, GlslSyntaxException, LexerException;

        public Map<String, Object> customProgramData();

        @Nullable
        public class_2960 name();

        public boolean isSourceFile();

        public int activeBuffers();

        public int type();

        default public String typeName() {
            return ShaderManager.getTypeName(this.type());
        }

        default public boolean isVertex() {
            return this.type() == 35633;
        }

        default public boolean isFragment() {
            return this.type() == 35632;
        }

        default public boolean isGeometry() {
            return this.type() == 36313;
        }

        default public boolean isTessellationControl() {
            return this.type() == 36488;
        }

        default public boolean isTessellationEvaluation() {
            return this.type() == 36487;
        }

        default public boolean hasFeatures(ShaderFeature ... features) {
            return VeilRenderSystem.renderer().getShaderManager().hasFeatures(features);
        }

        default public void include(GlslTree tree, class_2960 name, IncludeOverloadStrategy strategy) throws IOException, GlslSyntaxException, LexerException {
            this.include(tree, name.toString(), this.shaderImporter().loadImport(this, name, false), strategy);
        }

        default public void include(GlslTree tree, String name, GlslTree loadedImport, IncludeOverloadStrategy strategy) throws IOException, GlslSyntaxException, LexerException {
            tree.getDirectives().addAll(loadedImport.getDirectives());
            Set fieldNames = loadedImport.fields().map(GlslNewFieldNode::getName).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
            Set functionNames = loadedImport.functions().filter(function -> function.getBody() != null).map(GlslFunctionNode::getName).collect(Collectors.toUnmodifiableSet());
            switch (strategy.ordinal()) {
                case 0: {
                    for (GlslNode sourceNode : tree.getBody()) {
                        GlslFunctionNode function2;
                        String functionName;
                        if (!(sourceNode instanceof GlslRootNode)) continue;
                        GlslRootNode rootNode = (GlslRootNode)sourceNode;
                        if (rootNode.isField()) {
                            GlslNewFieldNode field = rootNode.asField();
                            String fieldName = field.getName();
                            if (fieldName == null || !fieldNames.contains(fieldName)) continue;
                            throw new IOException("Field is part of include '" + name + "': " + fieldName);
                        }
                        if (!rootNode.isFunction() || !functionNames.contains(functionName = (function2 = rootNode.asFunction()).getName())) continue;
                        throw new IOException("Function is part of include '" + name + "': " + functionName);
                    }
                    break;
                }
                case 1: {
                    for (GlslNode sourceNode : tree.getBody()) {
                        GlslFunctionNode function3;
                        String functionName;
                        Set remove;
                        if (!(sourceNode instanceof GlslRootNode)) continue;
                        GlslRootNode rootNode = (GlslRootNode)sourceNode;
                        if (rootNode.isField()) {
                            GlslNewFieldNode field = rootNode.asField();
                            String fieldName = field.getName();
                            if (fieldName == null || !fieldNames.contains(fieldName)) continue;
                            remove = loadedImport.fields().filter(node -> fieldName.equals(node.getName())).collect(Collectors.toUnmodifiableSet());
                            loadedImport.getBody().removeAll(remove);
                            continue;
                        }
                        if (!rootNode.isFunction() || !functionNames.contains(functionName = (function3 = rootNode.asFunction()).getName())) continue;
                        remove = loadedImport.functions().filter(node -> node.getName().equals(functionName) && node.getBody() != null && node.getHeader().equals((Object)function3.getHeader())).collect(Collectors.toUnmodifiableSet());
                        loadedImport.getBody().removeAll(remove);
                    }
                    break;
                }
                case 2: {
                    Iterator iterator = tree.getBody().iterator();
                    while (iterator.hasNext()) {
                        GlslFunctionNode function4;
                        String functionName;
                        GlslNode sourceNode = (GlslNode)iterator.next();
                        if (!(sourceNode instanceof GlslRootNode)) continue;
                        GlslRootNode rootNode = (GlslRootNode)sourceNode;
                        if (rootNode.isField()) {
                            GlslNewFieldNode field = rootNode.asField();
                            if (!fieldNames.contains(field.getName())) continue;
                            iterator.remove();
                            continue;
                        }
                        if (!rootNode.isFunction() || !functionNames.contains(functionName = (function4 = rootNode.asFunction()).getName()) || !loadedImport.functions().anyMatch(node -> node.getName().equals(functionName) && node.getBody() != null && node.getHeader().equals((Object)function4.getHeader()))) continue;
                        iterator.remove();
                    }
                    break;
                }
            }
            tree.getBody().addAll(0, (Collection)loadedImport.getBody());
        }

        public ShaderImporter shaderImporter();

        default public ShaderPreDefinitions preDefinitions() {
            return VeilRenderSystem.renderer().getShaderDefinitions();
        }

        public Map<String, String> macros();
    }
}

