/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.program;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.util.EnumCodec;
import org.lwjgl.opengl.GL20C;

public record ShaderBlendMode(BlendEquation colorEquation, BlendEquation alphaEquation, GlStateManager.class_4535 srcColorFactor, GlStateManager.class_4534 dstColorFactor, GlStateManager.class_4535 srcAlphaFactor, GlStateManager.class_4534 dstAlphaFactor) {
    public static final Codec<GlStateManager.class_4535> SOURCE_FACTOR_CODEC = EnumCodec.builder("Source Factor").values(GlStateManager.class_4535.class).build();
    public static final Codec<GlStateManager.class_4534> DESTINATION_FACTOR_CODEC = EnumCodec.builder("Destination Factor").values(GlStateManager.class_4534.class).build();
    public static final Codec<ShaderBlendMode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlendEquation.CODEC.optionalFieldOf("func", (Object)BlendEquation.ADD).forGetter(ShaderBlendMode::colorEquation), (App)BlendEquation.CODEC.optionalFieldOf("alphafunc", (Object)BlendEquation.ADD).forGetter(ShaderBlendMode::alphaEquation), (App)SOURCE_FACTOR_CODEC.optionalFieldOf("srcrgb", (Object)GlStateManager.class_4535.ONE).forGetter(ShaderBlendMode::srcColorFactor), (App)DESTINATION_FACTOR_CODEC.optionalFieldOf("dstrgb", (Object)GlStateManager.class_4534.ZERO).forGetter(ShaderBlendMode::dstColorFactor), (App)SOURCE_FACTOR_CODEC.optionalFieldOf("srcalpha", (Object)GlStateManager.class_4535.ONE).forGetter(ShaderBlendMode::srcAlphaFactor), (App)DESTINATION_FACTOR_CODEC.optionalFieldOf("dstalpha", (Object)GlStateManager.class_4534.ZERO).forGetter(ShaderBlendMode::dstAlphaFactor)).apply((Applicative)instance, ShaderBlendMode::new));

    public void apply() {
        if (this.colorEquation != BlendEquation.ADD || this.alphaEquation != BlendEquation.ADD) {
            GL20C.glBlendEquationSeparate((int)this.colorEquation.getGlType(), (int)this.alphaEquation.getGlType());
        }
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)this.srcColorFactor, (GlStateManager.class_4534)this.dstColorFactor, (GlStateManager.class_4535)this.srcAlphaFactor, (GlStateManager.class_4534)this.dstAlphaFactor);
    }

    public boolean hasEquation() {
        return this.colorEquation != BlendEquation.ADD || this.alphaEquation != BlendEquation.ADD;
    }

    public static enum BlendEquation {
        ADD(32774),
        SUBTRACT(32778),
        REVERSE_SUBTRACT(32779),
        MIN(32775),
        MAX(32776);

        public static final Codec<BlendEquation> CODEC;
        private final int glType;

        private BlendEquation(int glType) {
            this.glType = glType;
        }

        public int getGlType() {
            return this.glType;
        }

        static {
            CODEC = EnumCodec.builder("Blend Equation").values(BlendEquation.class).build();
        }
    }
}

