/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.program;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.ShaderFeature;
import foundry.veil.api.client.render.shader.compiler.CompiledShader;
import foundry.veil.api.client.render.shader.program.MutableUniformAccess;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.api.client.render.shader.program.TextureUniformAccess;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import foundry.veil.impl.client.render.shader.program.ShaderProgramImpl;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Set;
import net.minecraft.class_280;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_5944;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.system.NativeResource;

@ApiStatus.NonExtendable
public interface ShaderProgram
extends NativeResource,
MutableUniformAccess,
TextureUniformAccess {
    default public void bind() {
        int program = this.getProgram();
        if (class_5944.field_29486 != program) {
            class_5944.field_29486 = program;
            GlStateManager._glUseProgram((int)program);
        }
        class_280.field_1505 = -1;
    }

    public static void unbind() {
        VeilRenderSystem.clearShaderBlocks();
        GlStateManager._glUseProgram((int)0);
        class_5944.field_29486 = -1;
        class_280.field_1505 = -1;
        VeilRenderSystem.unbindSamplers(0, VeilRenderSystem.maxCombinedTextureUnits());
        ShaderProgramImpl.restoreBlendState();
    }

    default public void setDefaultUniforms(class_293.class_5596 mode) {
        this.setDefaultUniforms(mode, (Matrix4fc)RenderSystem.getModelViewMatrix(), (Matrix4fc)RenderSystem.getProjectionMatrix());
    }

    public void setDefaultUniforms(class_293.class_5596 var1, Matrix4fc var2, Matrix4fc var3);

    public int getProgram();

    public int getActiveDynamicBuffers();

    @Override
    public ShaderUniform getUniform(CharSequence var1);

    @Override
    public ShaderUniform getOrCreateUniform(CharSequence var1);

    @Override
    default public void setUniformBlock(CharSequence name, int binding) {
        int index = this.getUniformBlock(name);
        if (index != -1) {
            GL31C.glUniformBlockBinding((int)this.getProgram(), (int)index, (int)binding);
        }
    }

    @Override
    default public void setStorageBlock(CharSequence name, int binding) {
        int index = this.getStorageBlock(name);
        if (index != -1) {
            GL43C.glShaderStorageBlockBinding((int)this.getProgram(), (int)index, (int)binding);
        }
    }

    @Nullable
    public ProgramDefinition getDefinition();

    public Int2ObjectMap<CompiledShader> getShaders();

    public boolean isValid();

    default public boolean hasVertex() {
        return this.getShaders().containsKey(35633);
    }

    default public boolean hasGeometry() {
        return this.getShaders().containsKey(36313);
    }

    default public boolean hasFragment() {
        return this.getShaders().containsKey(35633);
    }

    default public boolean hasTesselation() {
        Int2ObjectMap<CompiledShader> shaders = this.getShaders();
        return shaders.containsKey(36488) && shaders.containsKey(36487);
    }

    default public boolean isCompute() {
        return this.getShaders().containsKey(37305);
    }

    public Set<ShaderFeature> getRequiredFeatures();

    @Nullable
    public class_293 getFormat();

    public Set<String> getDefinitionDependencies();

    public class_2960 getName();

    @Deprecated
    public class_5944 toShaderInstance();
}

