/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.uniform;

import foundry.veil.impl.client.render.shader.uniform.CompositeShaderUniformAccess;
import foundry.veil.impl.client.render.shader.uniform.EmptyShaderUniformAccess;
import org.joml.Matrix2dc;
import org.joml.Matrix2fc;
import org.joml.Matrix3dc;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2dc;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4dc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3fc;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4dc;
import org.joml.Vector4fc;
import org.joml.Vector4ic;

public interface ShaderUniformAccess {
    public static final ShaderUniformAccess EMPTY = EmptyShaderUniformAccess.INSTANCE;

    public static ShaderUniformAccess of(ShaderUniformAccess ... accesses) {
        if (accesses.length == 0) {
            return EMPTY;
        }
        if (accesses.length == 1) {
            return accesses[0];
        }
        return new CompositeShaderUniformAccess(accesses);
    }

    public boolean isValid();

    public void setFloat(float var1);

    public void setVector(float var1, float var2);

    public void setVector(float var1, float var2, float var3);

    public void setVector(float var1, float var2, float var3, float var4);

    default public void setVector(Vector2fc value) {
        this.setVector(value.x(), value.y());
    }

    default public void setVector(Vector3fc value) {
        this.setVector(value.x(), value.y(), value.z());
    }

    default public void setVector(Vector4fc value) {
        this.setVector(value.x(), value.y(), value.z(), value.w());
    }

    default public void setVector(float[] values) {
        switch (Math.min(4, values.length)) {
            case 1: {
                this.setFloat(values[0]);
                break;
            }
            case 2: {
                this.setVector(values[0], values[1]);
                break;
            }
            case 3: {
                this.setVector(values[0], values[1], values[2]);
                break;
            }
            case 4: {
                this.setVector(values[0], values[1], values[2], values[3]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("At least 1 value must be specified");
            }
        }
    }

    public void setInt(int var1);

    public void setVectorI(int var1, int var2);

    public void setVectorI(int var1, int var2, int var3);

    public void setVectorI(int var1, int var2, int var3, int var4);

    default public void setVectorI(Vector2ic value) {
        this.setVectorI(value.x(), value.y());
    }

    default public void setVectorI(Vector3ic value) {
        this.setVectorI(value.x(), value.y(), value.z());
    }

    default public void setVectorI(Vector4ic value) {
        this.setVectorI(value.x(), value.y(), value.z(), value.w());
    }

    default public void setVectorI(int[] values) {
        switch (Math.min(4, values.length)) {
            case 1: {
                this.setInt(values[0]);
                break;
            }
            case 2: {
                this.setVectorI(values[0], values[1]);
                break;
            }
            case 3: {
                this.setVectorI(values[0], values[1], values[2]);
                break;
            }
            case 4: {
                this.setVectorI(values[0], values[1], values[2], values[3]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("At least 1 value must be specified");
            }
        }
    }

    public void setDouble(double var1);

    public void setVector64(double var1, double var3);

    public void setVector64(double var1, double var3, double var5);

    public void setVector64(double var1, double var3, double var5, double var7);

    default public void setVector64(Vector2dc value) {
        this.setVector64(value.x(), value.y());
    }

    default public void setVector64(Vector3dc value) {
        this.setVector64(value.x(), value.y(), value.z());
    }

    default public void setVector64(Vector4dc value) {
        this.setVector64(value.x(), value.y(), value.z(), value.w());
    }

    default public void setVector64(double[] values) {
        switch (Math.min(4, values.length)) {
            case 1: {
                this.setDouble(values[0]);
                break;
            }
            case 2: {
                this.setVector64(values[0], values[1]);
                break;
            }
            case 3: {
                this.setVector64(values[0], values[1], values[2]);
                break;
            }
            case 4: {
                this.setVector64(values[0], values[1], values[2], values[3]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("At least 1 value must be specified");
            }
        }
    }

    public void setLong(long var1);

    public void setVectorI64(long var1, long var3);

    public void setVectorI64(long var1, long var3, long var5);

    public void setVectorI64(long var1, long var3, long var5, long var7);

    default public void setVectorI64(long[] values) {
        switch (Math.min(4, values.length)) {
            case 1: {
                this.setLong(values[0]);
                break;
            }
            case 2: {
                this.setVectorI64(values[0], values[1]);
                break;
            }
            case 3: {
                this.setVectorI64(values[0], values[1], values[2]);
                break;
            }
            case 4: {
                this.setVectorI64(values[0], values[1], values[2], values[3]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("At least 1 value must be specified");
            }
        }
    }

    public void setFloats(float ... var1);

    public void setVectors(Vector2fc ... var1);

    public void setVectors(Vector3fc ... var1);

    public void setVectors(Vector4fc ... var1);

    public void setInts(int ... var1);

    public void setIVectors(Vector2ic ... var1);

    public void setIVectors(Vector3ic ... var1);

    public void setIVectors(Vector4ic ... var1);

    public void setDoubles(double ... var1);

    public void set64Vectors(Vector2dc ... var1);

    public void set64Vectors(Vector3dc ... var1);

    public void set64Vectors(Vector4dc ... var1);

    public void setLongs(long ... var1);

    public void setHandle(long var1);

    public void setHandles(long ... var1);

    default public void setMatrix(Matrix2fc value) {
        this.setMatrix(value, false);
    }

    default public void setMatrix(Matrix3fc value) {
        this.setMatrix(value, false);
    }

    default public void setMatrix(Matrix4fc value) {
        this.setMatrix(value, false);
    }

    default public void setMatrix2x3(Matrix3x2fc value) {
        this.setMatrix2x3(value, false);
    }

    default public void setMatrix3x2(Matrix3x2fc value) {
        this.setMatrix3x2(value, false);
    }

    default public void setMatrix3x4(Matrix4x3fc value) {
        this.setMatrix3x4(value, false);
    }

    default public void setMatrix4x3(Matrix4x3fc value) {
        this.setMatrix4x3(value, false);
    }

    public void setMatrix(Matrix2fc var1, boolean var2);

    public void setMatrix(Matrix3fc var1, boolean var2);

    public void setMatrix(Matrix4fc var1, boolean var2);

    public void setMatrix2x3(Matrix3x2fc var1, boolean var2);

    public void setMatrix3x2(Matrix3x2fc var1, boolean var2);

    public void setMatrix3x4(Matrix4x3fc var1, boolean var2);

    public void setMatrix4x3(Matrix4x3fc var1, boolean var2);

    default public void setMatrix(Matrix2dc value) {
        this.setMatrix(value, false);
    }

    default public void setMatrix(Matrix3dc value) {
        this.setMatrix(value, false);
    }

    default public void setMatrix(Matrix4dc value) {
        this.setMatrix(value, false);
    }

    default public void setMatrix2x3(Matrix3x2dc value) {
        this.setMatrix2x3(value, false);
    }

    default public void setMatrix3x2(Matrix3x2dc value) {
        this.setMatrix3x2(value, false);
    }

    default public void setMatrix3x4(Matrix4x3dc value) {
        this.setMatrix3x4(value, false);
    }

    default public void setMatrix4x3(Matrix4x3dc value) {
        this.setMatrix4x3(value, false);
    }

    public void setMatrix(Matrix2dc var1, boolean var2);

    public void setMatrix(Matrix3dc var1, boolean var2);

    public void setMatrix(Matrix4dc var1, boolean var2);

    public void setMatrix2x3(Matrix3x2dc var1, boolean var2);

    public void setMatrix3x2(Matrix3x2dc var1, boolean var2);

    public void setMatrix3x4(Matrix4x3dc var1, boolean var2);

    public void setMatrix4x3(Matrix4x3dc var1, boolean var2);
}

