/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import foundry.veil.api.client.render.texture.CubemapTexture;
import foundry.veil.api.client.render.texture.VeilPreloadedTexture;
import foundry.veil.mixin.pipeline.accessor.PipelineNativeImageAccessor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1084;
import net.minecraft.class_156;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL12C;
import org.slf4j.Logger;

public class SimpleCubemapTexture
extends CubemapTexture
implements VeilPreloadedTexture {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final class_2960 location;
    private CompletableFuture<TextureImage> imageFuture;

    public SimpleCubemapTexture(class_2960 location) {
        this.location = location;
        this.imageFuture = null;
    }

    @Override
    public CompletableFuture<?> preload(class_3300 resourceManager, Executor backgroundExecutor) {
        if (this.imageFuture == null || this.imageFuture.isDone()) {
            this.imageFuture = CompletableFuture.supplyAsync(() -> TextureImage.load(resourceManager, this.location), backgroundExecutor);
        }
        return this.imageFuture;
    }

    public void method_4625(@NotNull class_3300 resourceManager) throws IOException {
        TextureImage textureImages = this.getTextureImage(resourceManager);
        try (class_1011 image = textureImages.getImage();){
            boolean clamp;
            boolean blur;
            int width = image.method_4307();
            int height = image.method_4323();
            if (height != width * 3 / 4) {
                throw new IOException("Expected cubemap image to be " + width + "x" + width * 3 / 4 + ". Was " + width + "x" + height);
            }
            class_1084 texturemetadatasection = textureImages.getTextureMetadata();
            if (texturemetadatasection != null) {
                blur = texturemetadatasection.method_4696();
                clamp = texturemetadatasection.method_4697();
            } else {
                blur = false;
                clamp = false;
            }
            this.method_4527(blur, clamp);
            if (!RenderSystem.isOnRenderThreadOrInit()) {
                RenderSystem.recordRenderCall(() -> this.loadImages(image));
            } else {
                this.loadImages(image);
            }
        }
    }

    private void loadImages(class_1011 image) {
        try (class_1011 class_10112 = image;){
            this.method_23207();
            GlStateManager._texParameter((int)34067, (int)33085, (int)0);
            GlStateManager._texParameter((int)34067, (int)33082, (int)0);
            GlStateManager._texParameter((int)34067, (int)33083, (int)0);
            GlStateManager._texParameter((int)34067, (int)34049, (float)0.0f);
            int tileSize = image.method_4307() / 4;
            PipelineNativeImageAccessor accessor = (PipelineNativeImageAccessor)image;
            accessor.invokeCheckAllocated();
            class_1011.class_1012 format = image.method_4318();
            format.method_4340();
            long pixels = accessor.getPixels();
            GlStateManager._pixelStore((int)3314, (int)image.method_4307());
            GlStateManager._pixelStore((int)3316, (int)tileSize);
            GlStateManager._pixelStore((int)3315, (int)0);
            GL12C.glTexImage2D((int)SimpleCubemapTexture.getGlFace(class_2350.field_11036), (int)0, (int)32856, (int)tileSize, (int)tileSize, (int)0, (int)format.method_4333(), (int)5121, (long)pixels);
            GlStateManager._pixelStore((int)3316, (int)0);
            GlStateManager._pixelStore((int)3315, (int)tileSize);
            GL12C.glTexImage2D((int)SimpleCubemapTexture.getGlFace(class_2350.field_11039), (int)0, (int)32856, (int)tileSize, (int)tileSize, (int)0, (int)format.method_4333(), (int)5121, (long)pixels);
            GlStateManager._pixelStore((int)3316, (int)tileSize);
            GlStateManager._pixelStore((int)3315, (int)tileSize);
            GL12C.glTexImage2D((int)SimpleCubemapTexture.getGlFace(class_2350.field_11035), (int)0, (int)32856, (int)tileSize, (int)tileSize, (int)0, (int)format.method_4333(), (int)5121, (long)pixels);
            GlStateManager._pixelStore((int)3316, (int)(tileSize * 2));
            GlStateManager._pixelStore((int)3315, (int)tileSize);
            GL12C.glTexImage2D((int)SimpleCubemapTexture.getGlFace(class_2350.field_11034), (int)0, (int)32856, (int)tileSize, (int)tileSize, (int)0, (int)format.method_4333(), (int)5121, (long)pixels);
            GlStateManager._pixelStore((int)3316, (int)(tileSize * 3));
            GlStateManager._pixelStore((int)3315, (int)tileSize);
            GL12C.glTexImage2D((int)SimpleCubemapTexture.getGlFace(class_2350.field_11043), (int)0, (int)32856, (int)tileSize, (int)tileSize, (int)0, (int)format.method_4333(), (int)5121, (long)pixels);
            GlStateManager._pixelStore((int)3316, (int)tileSize);
            GlStateManager._pixelStore((int)3315, (int)(tileSize * 2));
            GL12C.glTexImage2D((int)SimpleCubemapTexture.getGlFace(class_2350.field_11033), (int)0, (int)32856, (int)tileSize, (int)tileSize, (int)0, (int)format.method_4333(), (int)5121, (long)pixels);
        }
    }

    public void method_18169(@NotNull class_1060 textureManager, @NotNull class_3300 resourceManager, @NotNull class_2960 location, @NotNull Executor gameExecutor) {
        this.preload(resourceManager, class_156.method_18349()).thenRunAsync(() -> textureManager.method_4616(location, (class_1044)this), gameExecutor);
    }

    protected TextureImage getTextureImage(class_3300 resourceManager) {
        if (this.imageFuture != null) {
            TextureImage image = this.imageFuture.join();
            this.imageFuture = null;
            return image;
        }
        return TextureImage.load(resourceManager, this.location);
    }

    protected static class TextureImage
    implements Closeable {
        @Nullable
        private final class_1084 metadata;
        @Nullable
        private final class_1011 image;
        @Nullable
        private final IOException exception;

        public TextureImage(IOException exception) {
            this.exception = exception;
            this.metadata = null;
            this.image = null;
        }

        public TextureImage(@Nullable class_1084 metadata, class_1011 image) {
            this.exception = null;
            this.metadata = metadata;
            this.image = image;
        }

        public static TextureImage load(class_3300 resourceManager, class_2960 location) {
            try {
                class_1011 nativeimage;
                class_3298 resource = resourceManager.getResourceOrThrow(location);
                try (InputStream inputstream = resource.method_14482();){
                    nativeimage = class_1011.method_4309((InputStream)inputstream);
                }
                class_1084 texturemetadatasection = null;
                try {
                    texturemetadatasection = resource.method_14481().method_43041((class_3270)class_1084.field_5344).orElse(null);
                }
                catch (RuntimeException runtimeexception) {
                    LOGGER.warn("Failed reading metadata of: {}", (Object)location, (Object)runtimeexception);
                }
                return new TextureImage(texturemetadatasection, nativeimage);
            }
            catch (IOException ioexception) {
                return new TextureImage(ioexception);
            }
        }

        @Nullable
        public class_1084 getTextureMetadata() {
            return this.metadata;
        }

        public class_1011 getImage() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.image;
        }

        @Override
        public void close() {
            if (this.image != null) {
                this.image.close();
            }
        }

        public void throwIfError() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

