/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.network;

import foundry.veil.api.network.handler.ClientPacketContext;
import foundry.veil.api.network.handler.PacketContext;
import foundry.veil.api.network.handler.ServerPacketContext;
import foundry.veil.impl.network.ClientPacketSink;
import java.util.ArrayList;
import java.util.ServiceLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2802;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8042;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface VeilPacketManager {
    public static final Factory FACTORY = ServiceLoader.load(Factory.class).findFirst().orElseThrow(() -> new RuntimeException("Failed to load packet provider"));

    public static VeilPacketManager create(String modId, String version) {
        return FACTORY.create(modId, version);
    }

    public <T extends class_8710> void registerClientbound(class_8710.class_9154<T> var1, class_9139<? super class_9129, T> var2, PacketHandler<ClientPacketContext, T> var3);

    public <T extends class_8710> void registerServerbound(class_8710.class_9154<T> var1, class_9139<? super class_9129, T> var2, PacketHandler<ServerPacketContext, T> var3);

    public static PacketSink server() {
        return ClientPacketSink.INSTANCE;
    }

    public static PacketSink player(class_3222 player) {
        return packet -> player.field_13987.method_14364(packet);
    }

    public static PacketSink level(class_3218 level) {
        return packet -> level.method_8503().method_3760().method_14589(packet, level.method_27983());
    }

    public static PacketSink around(@Nullable class_3222 excluded, class_3218 level, double x, double y, double z, double radius) {
        return packet -> level.method_8503().method_3760().method_14605((class_1657)excluded, x, y, z, radius, level.method_27983(), packet);
    }

    public static PacketSink all(MinecraftServer server) {
        return packet -> server.method_3760().method_14581(packet);
    }

    public static PacketSink tracking(class_1297 entity) {
        return packet -> {
            class_2802 patt0$temp = entity.method_37908().method_8398();
            if (!(patt0$temp instanceof class_3215)) {
                throw new IllegalStateException("Cannot send clientbound payloads on the client");
            }
            class_3215 chunkCache = (class_3215)patt0$temp;
            chunkCache.method_18754(entity, packet);
        };
    }

    public static PacketSink trackingAndSelf(class_1297 entity) {
        return packet -> {
            class_2802 patt0$temp = entity.method_37908().method_8398();
            if (!(patt0$temp instanceof class_3215)) {
                throw new IllegalStateException("Cannot send clientbound payloads on the client");
            }
            class_3215 chunkCache = (class_3215)patt0$temp;
            chunkCache.method_18751(entity, packet);
        };
    }

    public static PacketSink tracking(class_3218 level, class_1923 pos) {
        return packet -> {
            for (class_3222 player : level.method_14178().field_17254.method_17210(pos, false)) {
                player.field_13987.method_14364(packet);
            }
        };
    }

    public static PacketSink tracking(class_3218 level, class_2338 pos) {
        return VeilPacketManager.tracking(level, new class_1923(pos));
    }

    public static PacketSink tracking(class_3218 level, class_2338 min, class_2338 max) {
        return packet -> class_1923.method_19281((class_1923)new class_1923(min), (class_1923)new class_1923(max)).flatMap(pos -> level.method_14178().field_17254.method_17210(pos, false).stream()).distinct().forEach(player -> player.field_13987.method_14364(packet));
    }

    public static PacketSink tracking(class_2586 blockEntity) {
        class_1937 class_19372 = blockEntity.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            throw new IllegalArgumentException("Only supported on server levels!");
        }
        class_3218 serverLevel = (class_3218)class_19372;
        return VeilPacketManager.tracking(serverLevel, blockEntity.method_11016());
    }

    @ApiStatus.Internal
    public static interface Factory {
        public VeilPacketManager create(String var1, String var2);
    }

    @FunctionalInterface
    public static interface PacketSink {
        default public void sendPacket(class_8710 ... payloads) {
            if (payloads.length == 0) {
                return;
            }
            if (payloads.length == 1) {
                this.sendPacket((class_2596<?>)new class_2658(payloads[0]));
                return;
            }
            ArrayList<class_2658> packets = new ArrayList<class_2658>();
            for (class_8710 payload : payloads) {
                packets.add(new class_2658(payload));
            }
            this.sendPacket((class_2596<?>)new class_8042(packets));
        }

        public void sendPacket(class_2596<?> var1);
    }

    @FunctionalInterface
    public static interface PacketHandler<T extends PacketContext, P extends class_8710> {
        public void handlePacket(P var1, T var2);
    }
}

