/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric.network;

import foundry.veil.api.network.VeilPacketManager;
import foundry.veil.api.network.handler.ClientPacketContext;
import foundry.veil.api.network.handler.ServerPacketContext;
import foundry.veil.fabric.network.FabricClientPacketContext;
import foundry.veil.fabric.network.FabricServerPacketContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FabricVeilPacketManager
implements VeilPacketManager {
    @Override
    public <T extends class_8710> void registerClientbound(class_8710.class_9154<T> id, class_9139<? super class_9129, T> codec, VeilPacketManager.PacketHandler<ClientPacketContext, T> handler) {
        PayloadTypeRegistry.playS2C().register(id, codec);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver(id, (payload, context) -> handler.handlePacket(payload, new FabricClientPacketContext(context)));
        }
    }

    @Override
    public <T extends class_8710> void registerServerbound(class_8710.class_9154<T> id, class_9139<? super class_9129, T> codec, VeilPacketManager.PacketHandler<ServerPacketContext, T> handler) {
        PayloadTypeRegistry.playC2S().register(id, codec);
        ServerPlayNetworking.registerGlobalReceiver(id, (payload, context) -> handler.handlePacket(payload, new FabricServerPacketContext(context)));
    }
}

