/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.editor.SingleWindowInspector;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilShaderLimits;
import imgui.ImGui;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;

@ApiStatus.Internal
public class DeviceInfoViewer
extends SingleWindowInspector {
    public static final class_2561 TITLE = class_2561.method_43471((String)"inspector.veil.device_info.title");
    private static final class_2561 UNSUPPORTED = class_2561.method_43471((String)"inspector.veil.device_info.unsupported");
    private static final class_2561 YES = class_5244.field_24336.method_27661().method_27694(style -> style.method_36139(-16711936));
    private static final class_2561 NO = class_5244.field_24337.method_27661().method_27694(style -> style.method_36139(-65536));
    private static final class_2561 GL_FEATURE_FLAG = class_2561.method_43471((String)"inspector.veil.device_info.opengl.feature_flag");
    private static final class_2561 GL_VERTEX_ARRAY = class_2561.method_43471((String)"inspector.veil.device_info.opengl.vertex_array");
    private static final class_2561 GL_UNIFORM = class_2561.method_43471((String)"inspector.veil.device_info.opengl.uniform");
    private static final class_2561 GL_TRANSFORM_FEEDBACK = class_2561.method_43471((String)"inspector.veil.device_info.opengl.transform_feedback");
    private static final class_2561 GL_ATOMIC_COUNTER = class_2561.method_43471((String)"inspector.veil.device_info.opengl.atomic_counter");
    private static final class_2561 GL_SHADER_STORAGE = class_2561.method_43471((String)"inspector.veil.device_info.opengl.shader_storage");
    private static final class_2561 GL_TEXTURE = class_2561.method_43471((String)"inspector.veil.device_info.opengl.texture");
    private static final class_2561 GL_FRAMEBUFFER = class_2561.method_43471((String)"inspector.veil.device_info.opengl.framebuffer");
    private static final Map<Integer, class_2561> SHADER_TYPES;
    private static final int TEXT_COLOR = -5592406;

    private static void text(String key, @Nullable String tooltip, Object ... values) {
        if (values != null) {
            Object[] valueComponents = Arrays.stream(values).filter(Objects::nonNull).map(value -> {
                class_5250 class_52502;
                if (value instanceof class_5250) {
                    class_5250 c = (class_5250)value;
                    class_52502 = c.method_27694(style -> style.method_36139(-1));
                } else {
                    class_52502 = class_2561.method_43470((String)value.toString()).method_27694(style -> style.method_36139(-1));
                }
                return class_52502;
            }).toArray();
            if (valueComponents.length == 0) {
                VeilImGuiUtil.component((class_5348)class_2561.method_43469((String)key, (Object[])new Object[]{UNSUPPORTED}).method_27694(style -> style.method_36139(VeilImGuiUtil.getColor(1))));
            } else {
                VeilImGuiUtil.component((class_5348)class_2561.method_43469((String)key, (Object[])valueComponents));
            }
        } else {
            VeilImGuiUtil.component((class_5348)class_2561.method_43469((String)key, (Object[])new Object[]{UNSUPPORTED}).method_27694(style -> style.method_36139(VeilImGuiUtil.getColor(1))));
        }
        if (tooltip != null) {
            ImGui.sameLine();
            VeilImGuiUtil.tooltip(tooltip);
        }
    }

    private static void flagText(String key, boolean supported, @Nullable String tooltip) {
        VeilImGuiUtil.component((class_5348)class_2561.method_43469((String)key, (Object[])new Object[]{supported ? YES : NO}));
        if (tooltip != null) {
            ImGui.sameLine();
            VeilImGuiUtil.tooltip(tooltip);
        }
    }

    private static void title(class_2561 component) {
        ImGui.pushStyleColor((int)0, (int)-1);
        VeilImGuiUtil.component((class_5348)component);
        ImGui.popStyleColor();
    }

    private void renderOpenGL() {
        ImGui.pushStyleColor((int)0, (int)-1);
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.vendor", null, GL43C.glGetString((int)7936));
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.renderer", null, GL43C.glGetString((int)7937));
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.version", null, GL43C.glGetString((int)7938));
        ImGui.popStyleColor();
        ImGui.separator();
        DeviceInfoViewer.title(GL_FEATURE_FLAG);
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.compute", VeilRenderSystem.computeSupported(), "Whether compute shaders can be used");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.atomic_counter", VeilRenderSystem.atomicCounterSupported(), "Whether atomic counters can be used in shaders");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.transform_feedback", VeilRenderSystem.transformFeedbackSupported(), "Whether transform feedback can be used");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.multi_bind", VeilRenderSystem.multibindSupported(), "Whether glBindTextures can be used instead of glBindTexture");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.sparse_buffers", VeilRenderSystem.sparseBuffersSupported(), "Whether sparse buffers can be used");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.direct_state_access", VeilRenderSystem.directStateAccessSupported(), "Whether direct state accesss can be used");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.separate_shader_objects", VeilRenderSystem.separateShaderObjectsSupported(), "Whether program pipelines can be used");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.clear_texture", VeilRenderSystem.clearTextureSupported(), "Whether glClearTexImage can be used");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.copy_image", VeilRenderSystem.copyImageSupported(), "Whether glCopyImageSubData can be used");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.shader_storage_buffers", VeilRenderSystem.shaderStorageBufferSupported(), "Whether shader storage buffers can be used");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.program_interface_query", VeilRenderSystem.programInterfaceQuerySupported(), "Whether the new style program interface query can be used");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.texture_anisotropy", VeilRenderSystem.textureAnisotropySupported(), "Whether GL_TEXTURE_MAX_ANISOTROPY can be set as a texture parameter");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.texture_mirror_clamp_to_edge", VeilRenderSystem.textureMirrorClampToEdgeSupported(), "Whether GL_MIRROR_CLAMP_TO_EDGE can be set as a texture edge value option");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.texture_cube_map_seamless", VeilRenderSystem.textureCubeMapSeamlessSupported(), "Whether GL_TEXTURE_CUBE_MAP_SEAMLESS can be set as a texture parameter");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.texture_cube_map_array", VeilRenderSystem.textureCubeMapArraySupported(), "Whether GL_TEXTURE_CUBE_MAP_ARRAY can be used as a texture type");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.nv_draw_texture", VeilRenderSystem.nvDrawTextureSupported(), "Whether glDrawTextureNV can be used");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.draw_indirect", VeilRenderSystem.drawIndirectSupported(), "Whether glDrawArraysInstanced and glDrawElementsInstancedBaseVertex can be used");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.multi_draw_indirect", VeilRenderSystem.multiDrawIndirectSupported(), "Whether multiple indirect commands can be natively drawn in one command");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.shader_float64", VeilRenderSystem.gpuShaderFloat64BitSupported(), "Whether 64-bit floats can be used in shader files");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.shader_int64", VeilRenderSystem.gpuShaderInt64BitSupported(), "Whether 64-bit integers can be used in shader files");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.vertex_attribute_64", VeilRenderSystem.vertexAttribute64BitSupported(), "Whether 64-bit values can be used as vertex attributes");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.bindless_texture", VeilRenderSystem.bindlessTextureSupported(), "Whether shaders can reference textures by handle instead of by unit");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.vertex_type_10f_11f_11f_rev", VeilRenderSystem.vertexType10F11F11FRevSupported(), "Whether Vertex Arrays can use GL_UNSIGNED_INT_10F_11F_11F_REV");
        DeviceInfoViewer.flagText("inspector.veil.device_info.opengl.feature_flag.pipeline_statistics_query", VeilRenderSystem.pipelineStatisticsQuerySupported(), "Whether pipeline statistics be queried");
        ImGui.separator();
        GLCapabilities caps = GL.getCapabilities();
        ImGui.popStyleColor();
        for (Map.Entry<Integer, class_2561> entry : SHADER_TYPES.entrySet()) {
            if (!ImGui.collapsingHeader((String)entry.getValue().getString())) continue;
            ImGui.pushID((int)entry.getKey());
            ImGui.indent();
            ImGui.pushStyleColor((int)0, (int)-5592406);
            VeilShaderLimits limits = VeilRenderSystem.shaderLimits(entry.getKey());
            DeviceInfoViewer.text("inspector.veil.device_info.opengl.shader.max_uniform_components", "This is the number of active components of uniform variables that can be defined outside of a uniform block. The term \"component\" is meant as the basic component of a vector/matrix. So a vec3 takes up 3 components. The minimum value here is 1024, enough room for 256 vec4s.", limits.maxUniformComponents());
            DeviceInfoViewer.text("inspector.veil.device_info.opengl.shader.max_uniform_blocks", "The maximum number of uniform blocks that this shader stage can access. The OpenGL-required minimum is 12 in GL 3.3, and 14 in GL 4.3.", limits.maxUniformBlocks());
            if (entry.getKey() != 37305) {
                DeviceInfoViewer.text("inspector.veil.device_info.opengl.shader.max_input_components", "The maximum number of components that this stage can take as input. The required minimum value differs from shader stage to shader stage.", limits.maxInputComponents());
                DeviceInfoViewer.text("inspector.veil.device_info.opengl.shader.max_output_components", "The maximum number of components that this stage can output. The required minimum value differs from shader stage to shader stage.", limits.maxOutputComponents());
            }
            DeviceInfoViewer.text("inspector.veil.device_info.opengl.shader.max_texture_image_units", "The maximum number of texture image units that the sampler in this shader can access. The OpenGL-required minimum value is 16 for each stage.", limits.maxTextureImageUnits());
            DeviceInfoViewer.text("inspector.veil.device_info.opengl.shader.max_image_uniforms", "The maximum number of image variables for this shader stage. The OpenGL-required minimum is 8 for fragment and compute shaders, and 0 for the rest. This means implementations may not allow you to use image variables in non-fragment or compute stages.", limits.maxImageUniforms() > 0 ? Integer.valueOf(limits.maxImageUniforms()) : null);
            boolean atomicCounters = caps.OpenGL42 || caps.GL_ARB_shader_atomic_counters;
            DeviceInfoViewer.text("inspector.veil.device_info.opengl.shader.max_atomic_counters", "The maximum number of Atomic Counter variables that this stage can define. The OpenGL-required minimum is 8 for fragment and compute shaders, and 0 for the rest.", atomicCounters ? Integer.valueOf(limits.maxAtomicCounters()) : null);
            DeviceInfoViewer.text("inspector.veil.device_info.opengl.shader.max_atomic_counter_buffers", "The maximum number of different buffers that the atomic counter variables can come from. The OpenGL-required minimum is 1 for fragment shaders, 8 for compute shaders (note: possible spec typo), and again 0 for the rest.", atomicCounters ? Integer.valueOf(limits.maxAtomicCountBuffers()) : null);
            DeviceInfoViewer.text("inspector.veil.device_info.opengl.shader.max_shader_storage_blocks", "The maximum number of different shader storage blocks that a stage can use. For fragment and compute shaders, the OpenGL-required minimum is 8; for the rest, it is 0.", caps.OpenGL43 || caps.GL_ARB_shader_storage_buffer_object ? Integer.valueOf(limits.maxShaderStorageBlocks()) : null);
            ImGui.popStyleColor();
            ImGui.unindent();
            ImGui.popID();
        }
        ImGui.pushStyleColor((int)0, (int)-5592406);
        DeviceInfoViewer.title(GL_VERTEX_ARRAY);
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.vertex_array.max_vertex_attributes", null, VeilRenderSystem.maxVertexAttributes());
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.vertex_array.max_vertex_attribute_relative_offset", null, VeilRenderSystem.maxVertexAttributeRelativeOffset());
        ImGui.separator();
        DeviceInfoViewer.title(GL_UNIFORM);
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.uniform.max_uniform_buffer_bindings", "The limit on the number of uniform buffer binding points. This is the limit for glBindBufferRange when using GL_UNIFORM_BUFFER.", VeilRenderSystem.maxUniformBuffersBindings());
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.uniform.max_uniform_buffer_size", null, VeilRenderSystem.maxUniformBufferSize());
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.uniform.uniform_buffer_alignment", "If you bind a uniform buffer with glBindBufferRange, the offset field of that parameter must be a multiple of GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT (this is a global value, not a per-program or per-block one). Thus, if you want to put the data for multiple uniform blocks in a single buffer object, you must make sure that the data for each within that block matches this alignment.", VeilRenderSystem.uniformBufferAlignment());
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.uniform.max_combined_uniform_blocks", "The maximum number of uniform blocks that all of the active programs can use. If two (or more) shader stages use the same block, they count separately towards this limit.", GL43C.glGetInteger((int)35374));
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.uniform.max_combined_texture_image_units", "The total number of texture units that can be used from all active programs. This is the limit on glActiveTexture(GL_TEXTURE0 + i) and glBindSampler.", VeilRenderSystem.maxCombinedTextureUnits());
        ImGui.separator();
        DeviceInfoViewer.title(GL_TRANSFORM_FEEDBACK);
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.transform_feedback.max_separate_attributes", "When doing separate mode Transform Feedback, this is the maximum number of varying variables that can be captured.", GL43C.glGetInteger((int)35979));
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.transform_feedback.max_separate_components", "When doing separate mode Transform Feedback, this is the maximum number of components for a single varying variable (note that varyings can be arrays or structs) that can be captured.", GL43C.glGetInteger((int)35968));
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.transform_feedback.max_interleaved_components", "When doing interleaved Transform Feedback, this is the total number of components that can be captured within a single buffer.", GL43C.glGetInteger((int)35978));
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.transform_feedback.max_buffers", "The maximum number of buffers that can be written to in transform feedback operations.", VeilRenderSystem.transformFeedbackSupported() ? Integer.valueOf(VeilRenderSystem.maxTransformFeedbackBindings()) : null);
        ImGui.separator();
        boolean atomicCounters = VeilRenderSystem.atomicCounterSupported();
        DeviceInfoViewer.title(GL_ATOMIC_COUNTER);
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.atomic_counter.max_buffer_bindings", "The total number of atomic counter buffer binding points. This is the limit for glBindBufferRange when using GL_ATOMIC_COUNTER_BUFFER.", atomicCounters ? Integer.valueOf(VeilRenderSystem.maxAtomicCounterBufferBindings()) : null);
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.atomic_counter.max_combined_buffers", "The maximum number of atomic counter buffers variables across all active programs.", atomicCounters ? Integer.valueOf(GL43C.glGetInteger((int)37585)) : null);
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.atomic_counter.max_combined_counters", "The maximum number of atomic counter variables across all active programs.", atomicCounters ? Integer.valueOf(GL43C.glGetInteger((int)37591)) : null);
        ImGui.separator();
        boolean shaderStorageBuffers = VeilRenderSystem.shaderStorageBufferSupported();
        DeviceInfoViewer.title(GL_SHADER_STORAGE);
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.shader_storage.max_bindings", "The total number of shader storage buffer binding points. This is the limit for glBindBufferRange when using GL_SHADER_STORAGE_BUFFER.", shaderStorageBuffers ? Integer.valueOf(VeilRenderSystem.maxShaderStorageBufferBindings()) : null);
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.shader_storage.max_size", null, shaderStorageBuffers ? Long.valueOf(VeilRenderSystem.maxShaderStorageBufferSize()) : null);
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.shader_storage.max_combined_blocks", "The maximum number of shader storage blocks across all active programs. As with UBOs, blocks that are the same between stages are counted for each stage.", shaderStorageBuffers ? Integer.valueOf(GL43C.glGetInteger((int)37084)) : null);
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.shader_storage.max_output_resources", "The total number of shader storage blocks, image variables, and fragment shader outputs across all active programs cannot exceed this number. This is the \"amount of stuff\" that a sequence of shaders can write to (barring Transform Feedback).", shaderStorageBuffers ? Integer.valueOf(GL43C.glGetInteger((int)36665)) : null);
        ImGui.separator();
        DeviceInfoViewer.title(GL_TEXTURE);
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.texture.max_texture_size", null, RenderSystem.maxSupportedTextureSize());
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.texture.max_array_texture_layers", null, VeilRenderSystem.maxArrayTextureLayers());
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.texture.max_texture_anisotropy", "The maximum value GL_TEXTURE_MAX_ANISOTROPY can be set to", VeilRenderSystem.textureAnisotropySupported() ? Float.valueOf(VeilRenderSystem.maxTextureAnisotropy()) : null);
        DeviceInfoViewer.title(GL_FRAMEBUFFER);
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.framebuffer.max_size", null, VeilRenderSystem.maxFramebufferWidth(), VeilRenderSystem.maxFramebufferHeight());
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.framebuffer.max_color_attachments", null, VeilRenderSystem.maxColorAttachments());
        DeviceInfoViewer.text("inspector.veil.device_info.opengl.framebuffer.max_samples", null, VeilRenderSystem.maxSamples());
    }

    public static class_2561 getShaderName(int shader) {
        return SHADER_TYPES.get(shader);
    }

    @Override
    public class_2561 getDisplayName() {
        return TITLE;
    }

    @Override
    public class_2561 getGroup() {
        return INFO_GROUP;
    }

    @Override
    protected void renderComponents() {
        ImGui.pushStyleColor((int)0, (int)-5592406);
        this.renderOpenGL();
        ImGui.popStyleColor();
    }

    @Override
    public void render() {
        ImGui.setNextWindowSizeConstraints((float)400.0f, (float)460.0f, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE);
        super.render();
    }

    static {
        LinkedHashMap<Integer, class_5250> map = new LinkedHashMap<Integer, class_5250>();
        map.put(35633, class_2561.method_43471((String)"inspector.veil.shader.vertex_shader"));
        map.put(36488, class_2561.method_43471((String)"inspector.veil.shader.tess_control_shader"));
        map.put(36487, class_2561.method_43471((String)"inspector.veil.shader.tess_eval_shader"));
        map.put(36313, class_2561.method_43471((String)"inspector.veil.shader.geometry_shader"));
        map.put(35632, class_2561.method_43471((String)"inspector.veil.shader.fragment_shader"));
        map.put(37305, class_2561.method_43471((String)"inspector.veil.shader.compute_shader"));
        SHADER_TYPES = Collections.unmodifiableMap(map);
    }
}

