/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.color.Color;
import foundry.veil.api.client.editor.EditorAttributeProvider;
import foundry.veil.api.client.editor.SingleWindowInspector;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.LightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import imgui.ImGui;
import imgui.type.ImBoolean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4617;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class LightInspector
extends SingleWindowInspector {
    public static final class_2561 TITLE = class_2561.method_43471((String)"inspector.veil.light.title");
    private static final class_2561 ADD = class_2561.method_43471((String)"inspector.veil.light.button.add");
    private static final class_2561 REMOVE = class_2561.method_43471((String)"inspector.veil.light.button.remove");
    private static final class_2561 REMOVE_ALL = class_2561.method_43471((String)"inspector.veil.light.button.remove_all");
    private static final class_2561 REMOVE_ALL_DESC = class_2561.method_43471((String)"inspector.veil.light.button.remove_all.desc");
    private static final class_2561 SET_POSITION = class_2561.method_43471((String)"inspector.veil.light.button.set_position");
    private static final class_2561 ATTRIBUTES = class_2561.method_43471((String)"inspector.veil.light.attributes");
    private static final class_2561 ENABLE_AO = class_2561.method_43471((String)"inspector.veil.light.toggle.ao");
    private final List<class_5321<LightTypeRegistry.LightType<?>>> lightTypes = new ArrayList();
    private class_5321<LightTypeRegistry.LightType<?>> selectedTab;
    private final ImBoolean enableAmbientOcclusion = new ImBoolean();

    @Override
    public class_2561 getDisplayName() {
        return TITLE;
    }

    @Override
    @Nullable
    public class_2561 getGroup() {
        return RENDERER_GROUP;
    }

    @Override
    public boolean isEnabled() {
        return class_310.method_1551().field_1687 != null && LightTypeRegistry.REGISTRY.method_10204() > 0;
    }

    @Override
    protected void renderComponents() {
        LightTypeRegistry.LightType lightType;
        LightRenderer lightRenderer = VeilRenderSystem.renderer().getLightRenderer();
        if (this.selectedTab == null || !LightTypeRegistry.REGISTRY.method_35842(this.selectedTab)) {
            this.selectedTab = this.lightTypes.getFirst();
        }
        ImGui.beginDisabled(((lightType = (LightTypeRegistry.LightType)LightTypeRegistry.REGISTRY.method_29107(this.selectedTab)) == null || lightType.debugLightFactory() == null ? 1 : 0) != 0);
        if (ImGui.button((String)ADD.getString()) && lightType != null && lightType.debugLightFactory() != null) {
            LightTypeRegistry.DebugLightFactory factory = lightType.debugLightFactory();
            class_310 class_3102 = class_310.method_1551();
            class_4184 mainCamera = class_3102.field_1773.method_19418();
            lightRenderer.addLight(factory.createDebugLight(class_3102.field_1687, mainCamera));
        }
        ImGui.endDisabled();
        if (ImGui.isItemHovered((int)0)) {
            VeilImGuiUtil.setTooltip((class_5348)class_2561.method_43469((String)"inspector.veil.light.button.add.desc", (Object[])new Object[]{this.selectedTab.method_29177().toString()}));
        }
        ImGui.sameLine();
        ImGui.beginDisabled((lightType == null ? 1 : 0) != 0);
        if (ImGui.button((String)REMOVE.getString()) && lightType != null) {
            for (LightRenderHandle lightRenderHandle : lightRenderer.getLights(lightType)) {
                lightRenderHandle.free();
            }
        }
        ImGui.endDisabled();
        if (ImGui.isItemHovered((int)0)) {
            VeilImGuiUtil.setTooltip((class_5348)class_2561.method_43469((String)"inspector.veil.light.button.remove.desc", (Object[])new Object[]{this.selectedTab.method_29177().toString()}));
        }
        ImGui.sameLine();
        if (ImGui.button((String)REMOVE_ALL.getString())) {
            lightRenderer.free();
        }
        if (ImGui.isItemHovered((int)0)) {
            VeilImGuiUtil.setTooltip((class_5348)REMOVE_ALL_DESC);
        }
        ImGui.sameLine();
        this.enableAmbientOcclusion.set(lightRenderer.isAmbientOcclusionEnabled());
        if (ImGui.checkbox((String)ENABLE_AO.getString(), (ImBoolean)this.enableAmbientOcclusion)) {
            if (this.enableAmbientOcclusion.get()) {
                lightRenderer.enableAmbientOcclusion();
            } else {
                lightRenderer.disableAmbientOcclusion();
            }
        }
        if (ImGui.isItemHovered()) {
            ImGui.setTooltip((String)"Deprecated");
        }
        ImGui.beginTabBar((String)"##lights");
        for (class_5321 class_53212 : this.lightTypes) {
            class_2960 id = class_53212.method_29177();
            if (!ImGui.beginTabItem((String)id.toString())) continue;
            this.selectedTab = class_53212;
            int i = 0;
            Collection lightData = lightRenderer.getLights((LightTypeRegistry.LightType)LightTypeRegistry.REGISTRY.method_29107(class_53212));
            for (LightRenderHandle handle : lightData) {
                ImGui.pushID((String)("light" + i));
                LightInspector.renderLightComponents(handle);
                ImGui.popID();
                ++i;
            }
            ImGui.endTabItem();
        }
        ImGui.endTabBar();
    }

    @Override
    public void onShow() {
        super.onShow();
        this.lightTypes.clear();
        this.lightTypes.addAll(LightTypeRegistry.REGISTRY.method_42021().stream().sorted(Comparator.comparing(class_5321::method_29177)).toList());
    }

    private static void renderLightComponents(LightRenderHandle<?> handle) {
        Object data = handle.getLightData();
        ImBoolean visible = new ImBoolean(true);
        ImGui.pushID((int)data.hashCode());
        if (ImGui.collapsingHeader((String)class_4617.method_23267((UUID)new UUID(data.hashCode(), 0L)), (ImBoolean)visible)) {
            LightInspector.renderLightAttributeComponents(data);
            handle.markDirty();
        }
        ImGui.popID();
        if (!visible.get()) {
            handle.free();
        }
        ImGui.separator();
    }

    private static void renderLightAttributeComponents(LightData lightData) {
        Color lightColor = lightData.getColor();
        float[] editBrightness = new float[]{lightData.getBrightness()};
        float[] editLightColor = new float[]{lightColor.red(), lightColor.green(), lightColor.blue()};
        ImGui.indent();
        if (ImGui.dragScalar((String)"brightness", (float[])editBrightness, (float)0.02f)) {
            lightData.setBrightness(editBrightness[0]);
        }
        if (ImGui.colorEdit3((String)"color", (float[])editLightColor)) {
            lightData.setColor(editLightColor[0], editLightColor[1], editLightColor[2]);
        }
        if (ImGui.button((String)SET_POSITION.getString())) {
            lightData.setTo(class_310.method_1551().field_1773.method_19418());
        }
        ImGui.newLine();
        VeilImGuiUtil.component((class_5348)ATTRIBUTES);
        if (lightData instanceof EditorAttributeProvider) {
            EditorAttributeProvider editorAttributeProvider = (EditorAttributeProvider)((Object)lightData);
            editorAttributeProvider.renderImGuiAttributes();
        }
        ImGui.unindent();
    }
}

