/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.Inspector;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.profiler.RenderProfilerCounter;
import foundry.veil.impl.client.render.profiler.VeilRenderProfilerImpl;
import imgui.ImGui;
import imgui.extension.implot.ImPlot;
import imgui.type.ImBoolean;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PipelineStatisticsViewer
implements Inspector {
    public static final class_2561 TITLE = class_2561.method_43471((String)"inspector.veil.pipeline_statistics.title");
    public static final int HISTORY_LENGTH = 200;
    private final ImBoolean open = new ImBoolean();
    private final Set<String> enabledPaths = new HashSet<String>();
    private final ObjectList<Map<String, VeilRenderProfilerImpl.ResultField>> history = new ObjectArrayList(200);
    private int historyIndex = 0;

    @Override
    public class_2561 getDisplayName() {
        return TITLE;
    }

    @Override
    public class_2561 getGroup() {
        return INFO_GROUP;
    }

    @Override
    public boolean isEnabled() {
        return VeilRenderSystem.pipelineStatisticsQuerySupported();
    }

    private void renderComponents() {
        if (!VeilRenderSystem.pipelineStatisticsQuerySupported()) {
            return;
        }
        while (this.history.size() < 200) {
            this.history.add((Object)new Object2ObjectOpenHashMap());
        }
        VeilRenderProfilerImpl.setEnabled(this.enabledPaths, RenderProfilerCounter.ALL);
        this.enabledPaths.clear();
        this.renderCounters("", RenderProfilerCounter.FRAGMENT_SHADER_INVOCATIONS);
        ++this.historyIndex;
        this.historyIndex %= 200;
        this.getHistory(0).clear();
    }

    private Map<String, VeilRenderProfilerImpl.ResultField> getHistory(int past) {
        return (Map)this.history.get(Math.floorMod(this.historyIndex - past, 200));
    }

    private void renderCounters(String path, RenderProfilerCounter sortedStatistic) {
        List<VeilRenderProfilerImpl.ResultField> fields = VeilRenderProfilerImpl.getCounters(path, sortedStatistic);
        Map map = (Map)this.history.get(this.historyIndex);
        for (VeilRenderProfilerImpl.ResultField field : fields) {
            String label;
            String string = label = path.isBlank() ? field.name() : path.replaceAll("\u001e", ".") + "." + field.name();
            if (!ImGui.collapsingHeader((String)field.name())) continue;
            ImGui.pushID((String)label);
            ImGui.indent();
            map.put(label, field);
            if (ImGui.collapsingHeader((String)"Plot")) {
                this.enabledPaths.add((String)(path.isBlank() ? field.name() : path + "\u001e" + field.name()));
                RenderProfilerCounter[] statistics = field.statistics();
                long[] values = new long[200];
                for (RenderProfilerCounter statistic : statistics) {
                    if (!ImPlot.beginPlot((String)statistic.name(), (float)ImGui.getContentRegionAvailX(), (float)150.0f, (int)198)) continue;
                    long max = 0L;
                    for (int j = 0; j < 200; ++j) {
                        long value;
                        VeilRenderProfilerImpl.ResultField past = this.getHistory(200 - j - 1).get(label);
                        if (past == null) continue;
                        values[j] = value = past.count()[statistic.ordinal()];
                        if (value <= max) continue;
                        max = value;
                    }
                    ImPlot.setupAxis((int)0, (int)12);
                    ImPlot.setupAxis((int)3, (int)4);
                    ImPlot.setupAxesLimits((double)0.0, (double)200.0, (double)0.0, (double)Math.max((double)max * 1.1, 10.0), (int)1);
                    ImPlot.setupAxisFormat((int)3, (String)"%3.0f");
                    ImPlot.pushStyleColor((int)0, (int)VeilImGuiUtil.colorOf(statistic.name()));
                    ImPlot.pushStyleVar((int)17, (float)0.0f, (float)0.0f);
                    ImPlot.pushStyleVar((int)18, (float)0.0f, (float)0.0f);
                    ImPlot.plotLine((String)statistic.name(), (long[])values);
                    ImPlot.popStyleVar();
                    ImPlot.popStyleColor();
                    ImPlot.endPlot();
                }
                ImGui.newLine();
            }
            this.renderCounters(label, sortedStatistic);
            ImGui.unindent();
            ImGui.popID();
        }
    }

    @Override
    public void render() {
    }

    @Override
    public void renderLast() {
        ImGui.setNextWindowSizeConstraints((float)400.0f, (float)460.0f, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE);
        if (ImGui.begin((String)this.getDisplayName().getString(), (ImBoolean)this.open)) {
            this.renderComponents();
        }
        ImGui.end();
        if (!this.open.get()) {
            VeilRenderSystem.renderer().getEditorManager().hide(this);
        }
    }

    @Override
    public void onShow() {
        this.open.set(true);
    }

    @Override
    public void onHide() {
        Inspector.super.onHide();
        this.history.clear();
        this.historyIndex = 0;
    }
}

