/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.imgui;

import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.ImVec2;
import imgui.callback.ImStrConsumer;
import imgui.callback.ImStrSupplier;
import imgui.glfw.ImGuiImplGlfw;
import java.nio.IntBuffer;
import net.minecraft.class_310;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCursorEnterCallback;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWMonitorCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.system.MemoryStack;

public class VeilImGuiImplGlfw
extends ImGuiImplGlfw {
    private final VeilImGuiImpl impl;

    public VeilImGuiImplGlfw(VeilImGuiImpl impl) {
        this.impl = impl;
    }

    private VeilData getData() {
        return (VeilData)this.data;
    }

    protected ImStrSupplier getClipboardTextFn() {
        return new ImStrSupplier(){

            public String get() {
                long window = VeilImGuiImplGlfw.this.getData().getWindow();
                if (class_310.method_1551().method_22683().method_4490() == window) {
                    return class_310.method_1551().field_1774.method_1460();
                }
                String clipboardString = GLFW.glfwGetClipboardString((long)window);
                return clipboardString != null ? clipboardString : "";
            }
        };
    }

    protected ImStrConsumer setClipboardTextFn() {
        return new ImStrConsumer(){

            public void accept(String text) {
                long window = VeilImGuiImplGlfw.this.getData().getWindow();
                if (class_310.method_1551().method_22683().method_4490() == window) {
                    class_310.method_1551().field_1774.method_1455(text);
                } else {
                    GLFW.glfwSetClipboardString((long)window, (CharSequence)text);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseButtonCallback(long window, int button, int action, int mods) {
        VeilData data = this.getData();
        if (data.getPrevUserCallbackMousebutton() != null && window == data.getWindow()) {
            data.getPrevUserCallbackMousebutton().invoke(window, button, action, mods);
        }
        try {
            this.impl.start();
            this.updateKeyModifiers(mods);
            ImGuiIO io = ImGui.getIO();
            if (button >= 0 && button < 5) {
                io.addMouseButtonEvent(button, action == 1);
            }
        }
        finally {
            this.impl.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollCallback(long window, double xOffset, double yOffset) {
        VeilData data = this.getData();
        if (data.getPrevUserCallbackScroll() != null && window == data.getWindow()) {
            data.getPrevUserCallbackScroll().invoke(window, xOffset, yOffset);
        }
        try {
            this.impl.start();
            ImGuiIO io = ImGui.getIO();
            io.addMouseWheelEvent((float)xOffset, (float)yOffset);
        }
        finally {
            this.impl.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyCallback(long window, int keycode, int scancode, int action, int mods) {
        VeilData data = this.getData();
        if (data.getPrevUserCallbackKey() != null && window == data.getWindow()) {
            data.getPrevUserCallbackKey().invoke(window, keycode, scancode, action, mods);
        }
        try {
            this.impl.start();
            if (action != 1 && action != 0) {
                return;
            }
            int keyModifiers = mods;
            int keycodeToMod = this.keyToModifier(keycode);
            if (keycodeToMod != 0) {
                keyModifiers = action == 1 ? mods | keycodeToMod : mods & ~keycodeToMod;
            }
            this.updateKeyModifiers(keyModifiers);
            if (keycode >= 0 && keycode < data.getKeyOwnerWindows().length) {
                data.getKeyOwnerWindows()[keycode] = action == 1 ? window : -1L;
            }
            int key = this.translateUntranslatedKey(keycode, scancode);
            ImGuiIO io = ImGui.getIO();
            int imguiKey = this.glfwKeyToImGuiKey(key);
            io.addKeyEvent(imguiKey, action == 1);
            io.setKeyEventNativeData(imguiKey, key, scancode);
        }
        finally {
            this.impl.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowFocusCallback(long window, boolean focused) {
        VeilData data = this.getData();
        if (data.getPrevUserCallbackWindowFocus() != null && window == data.getWindow()) {
            data.getPrevUserCallbackWindowFocus().invoke(window, focused);
        }
        try {
            this.impl.start();
            ImGui.getIO().addFocusEvent(focused);
        }
        finally {
            this.impl.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cursorPosCallback(long window, double x, double y) {
        VeilData data = this.getData();
        if (data.getPrevUserCallbackCursorPos() != null && window == data.getWindow()) {
            data.getPrevUserCallbackCursorPos().invoke(window, x, y);
        }
        try {
            this.impl.start();
            float posX = (float)x;
            float posY = (float)y;
            ImGuiIO io = ImGui.getIO();
            if (io.hasConfigFlags(1024)) {
                try (MemoryStack stack = MemoryStack.stackPush();){
                    IntBuffer windowX = stack.mallocInt(1);
                    IntBuffer windowY = stack.mallocInt(1);
                    GLFW.glfwGetWindowPos((long)window, (IntBuffer)windowX, (IntBuffer)windowY);
                    posX += (float)windowX.get(0);
                    posY += (float)windowY.get(0);
                }
            }
            io.addMousePosEvent(posX, posY);
            data.getLastValidMousePos().set(posX, posY);
        }
        finally {
            this.impl.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cursorEnterCallback(long window, boolean entered) {
        VeilData data = this.getData();
        if (data.getPrevUserCallbackCursorEnter() != null && window == data.getWindow()) {
            data.getPrevUserCallbackCursorEnter().invoke(window, entered);
        }
        try {
            this.impl.start();
            ImGuiIO io = ImGui.getIO();
            if (entered) {
                data.setMouseWindow(window);
                io.addMousePosEvent(data.getLastValidMousePos().x, data.getLastValidMousePos().y);
            } else if (data.getMouseWindow() == window) {
                io.getMousePos(data.getLastValidMousePos());
                data.setMouseWindow(-1L);
                io.addMousePosEvent(Float.MIN_VALUE, Float.MIN_VALUE);
            }
        }
        finally {
            this.impl.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void charCallback(long window, int c) {
        VeilData data = this.getData();
        if (data.getPrevUserCallbackChar() != null && window == data.getWindow()) {
            data.getPrevUserCallbackChar().invoke(window, c);
        }
        try {
            this.impl.start();
            ImGui.getIO().addInputCharacter(c);
        }
        finally {
            this.impl.stop();
        }
    }

    public void monitorCallback(long window, int event) {
        VeilData data = this.getData();
        if (data.getPrevUserCallbackMonitor() != null && window == data.getWindow()) {
            data.getPrevUserCallbackMonitor().invoke(window, event);
        }
        super.monitorCallback(window, event);
    }

    protected ImGuiImplGlfw.Data newData() {
        return new VeilData();
    }

    protected static class VeilData
    extends ImGuiImplGlfw.Data {
        protected VeilData() {
        }

        public long getWindow() {
            return this.window;
        }

        public long getMouseWindow() {
            return this.mouseWindow;
        }

        public ImVec2 getLastValidMousePos() {
            return this.lastValidMousePos;
        }

        public long[] getKeyOwnerWindows() {
            return this.keyOwnerWindows;
        }

        public GLFWWindowFocusCallback getPrevUserCallbackWindowFocus() {
            return this.prevUserCallbackWindowFocus;
        }

        public GLFWCursorPosCallback getPrevUserCallbackCursorPos() {
            return this.prevUserCallbackCursorPos;
        }

        public GLFWCursorEnterCallback getPrevUserCallbackCursorEnter() {
            return this.prevUserCallbackCursorEnter;
        }

        public GLFWMouseButtonCallback getPrevUserCallbackMousebutton() {
            return this.prevUserCallbackMousebutton;
        }

        public GLFWScrollCallback getPrevUserCallbackScroll() {
            return this.prevUserCallbackScroll;
        }

        public GLFWKeyCallback getPrevUserCallbackKey() {
            return this.prevUserCallbackKey;
        }

        public GLFWCharCallback getPrevUserCallbackChar() {
            return this.prevUserCallbackChar;
        }

        public GLFWMonitorCallback getPrevUserCallbackMonitor() {
            return this.prevUserCallbackMonitor;
        }

        public void setMouseWindow(long mouseWindow) {
            this.mouseWindow = mouseWindow;
        }
    }
}

