/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.dynamicbuffer;

import com.google.common.base.Stopwatch;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.ext.ShaderInstanceExtension;
import foundry.veil.impl.ThreadTaskScheduler;
import foundry.veil.impl.client.render.shader.processor.VanillaShaderProcessor;
import foundry.veil.impl.client.render.shader.program.ShaderProgramImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4239;
import net.minecraft.class_5912;
import net.minecraft.class_5913;
import net.minecraft.class_5944;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class VanillaShaderCompiler {
    private static final Set<String> LAST_FRAME_SHADERS = ConcurrentHashMap.newKeySet();
    private ThreadTaskScheduler scheduler;

    private void compileShader(class_5944 shader, int activeBuffers) {
        ShaderInstanceExtension extension = (ShaderInstanceExtension)shader;
        Collection<class_2960> shaderSources = extension.veil$getShaderSources();
        class_293 vertexFormat = shader.method_35786();
        HashMap<String, Object> customProgramData = new HashMap<String, Object>();
        final class_3300 resourceManager = class_310.method_1551().method_1478();
        VanillaShaderProcessor.setup((class_5912)resourceManager);
        for (final class_2960 path : shaderSources) {
            try {
                BufferedReader reader = resourceManager.openAsReader(path);
                try {
                    String source = IOUtils.toString((Reader)reader);
                    class_5913 preprocessor = new class_5913(this){
                        private final Set<String> importedPaths = new HashSet<String>();

                        public String method_34233(boolean useFullPath, @NotNull String directory) {
                            String string;
                            block12: {
                                if (useFullPath) {
                                    directory = class_4239.method_34676((String)(path.method_12832() + directory));
                                } else if ((directory = class_4239.method_34676((String)("shaders/include/" + directory))).indexOf(58) != -1) {
                                    class_2960 contained = class_2960.method_60654((String)directory);
                                    String finalDirectory = directory;
                                    directory = contained.method_45134(path -> path.replace(finalDirectory, (CharSequence)path)).toString();
                                }
                                if (!this.importedPaths.add(directory)) {
                                    return null;
                                }
                                class_2960 resourcelocation = class_2960.method_60654((String)directory);
                                BufferedReader reader = resourceManager.openAsReader(resourcelocation);
                                try {
                                    string = IOUtils.toString((Reader)reader);
                                    if (reader == null) break block12;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (reader != null) {
                                            try {
                                                ((Reader)reader).close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (IOException e) {
                                        Veil.LOGGER.error("Could not open GLSL import {}: {}", (Object)directory, (Object)e.getMessage());
                                        return "#error " + e.getMessage();
                                    }
                                }
                                ((Reader)reader).close();
                            }
                            return string;
                        }
                    };
                    source = String.join((CharSequence)"", preprocessor.method_34229(source));
                    boolean vertex = path.method_12832().endsWith(".vsh");
                    String processed = VanillaShaderProcessor.modify(customProgramData, shader.method_35787(), path, vertexFormat, activeBuffers, vertex ? 35633 : 35632, source);
                    class_310.method_1551().execute(() -> extension.veil$recompile(vertex, processed, activeBuffers));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Throwable t) {
                Veil.LOGGER.error("Couldn't load vanilla shader from {}", (Object)path, (Object)t);
            }
        }
        VanillaShaderProcessor.free();
    }

    public CompletableFuture<?> reload(Collection<class_5944> shaders) {
        ThreadTaskScheduler scheduler;
        if (this.scheduler != null) {
            this.scheduler.cancel();
        }
        int shaderCount = shaders.size();
        ConcurrentHashMap<String, class_5944> shaderMap = new ConcurrentHashMap<String, class_5944>(shaderCount);
        for (class_5944 shader : shaders) {
            shaderMap.put(shader.method_35787(), shader);
        }
        int activeBuffers = VeilRenderSystem.renderer().getDynamicBufferManger().getActiveBuffers();
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.scheduler = scheduler = new ThreadTaskScheduler("VeilVanillaShaderCompile", Math.max(1, Runtime.getRuntime().availableProcessors() / 6), () -> {
            for (String lastFrameShader : LAST_FRAME_SHADERS) {
                class_5944 shader = (class_5944)shaderMap.remove(lastFrameShader);
                if (shader == null) continue;
                return () -> this.compileShader(shader, activeBuffers);
            }
            Iterator iterator = shaderMap.values().iterator();
            if (iterator.hasNext()) {
                class_5944 shader = (class_5944)iterator.next();
                iterator.remove();
                return () -> this.compileShader(shader, activeBuffers);
            }
            return null;
        });
        CompletableFuture<?> future = scheduler.getCompletedFuture();
        future.thenRunAsync(() -> {
            if (!scheduler.isCancelled()) {
                Veil.LOGGER.info("Compiled {} vanilla shaders in {}", (Object)shaderCount, (Object)stopwatch.stop());
            }
        }, (Executor)class_310.method_1551());
        return future.isDone() ? CompletableFuture.completedFuture(null) : future;
    }

    public boolean isCompilingShaders() {
        return this.scheduler != null && !this.scheduler.getCompletedFuture().isDone();
    }

    public static int getActiveDynamicBuffers(class_5944 shaderInstance) {
        if (shaderInstance instanceof ShaderProgramImpl.Wrapper) {
            ShaderProgramImpl.Wrapper wrapper = (ShaderProgramImpl.Wrapper)shaderInstance;
            return wrapper.program().getActiveDynamicBuffers();
        }
        return ((ShaderInstanceExtension)shaderInstance).veil$getActiveBuffers();
    }

    @ApiStatus.Internal
    public static void markRendered(String shaderInstace) {
        if (VeilRenderSystem.renderer().getVanillaShaderCompiler().isCompilingShaders()) {
            LAST_FRAME_SHADERS.add(shaderInstace);
        }
    }

    @ApiStatus.Internal
    public static void clear() {
        LAST_FRAME_SHADERS.clear();
    }
}

