/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.light;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.color.Color;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.light.data.DirectionalLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import foundry.veil.api.client.render.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.client.render.vertex.VertexArray;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_284;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_5944;
import net.minecraft.class_9801;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

@ApiStatus.Internal
public class DirectionalLightRenderer
implements LightTypeRenderer<DirectionalLightData> {
    private static final Vector3f DIRECTION = new Vector3f();
    private static final class_2960 RENDER_TYPE = Veil.veilPath("light/directional");
    private final List<LightHandle> lights = new LinkedList<LightHandle>();
    private final VertexArray vertexArray = VertexArray.create();
    private boolean freed;

    public DirectionalLightRenderer() {
        this.vertexArray.upload(DirectionalLightRenderer.createMesh(), VertexArray.DrawUsage.STATIC);
        VertexArray.unbind();
    }

    private static class_9801 createMesh() {
        class_289 tesselator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27380, class_290.field_1592);
        LightTypeRenderer.createQuad((class_4588)bufferBuilder);
        return bufferBuilder.method_60800();
    }

    @Override
    public LightRenderHandle<DirectionalLightData> addLight(DirectionalLightData light) {
        LightHandle handle = new LightHandle(light);
        this.lights.add(handle);
        return handle;
    }

    @Override
    public LightRenderHandle<DirectionalLightData> steal(LightRenderHandle<DirectionalLightData> handle) {
        if (!(handle instanceof LightHandle)) {
            handle.free();
            return this.addLight(handle.getLightData());
        }
        return handle;
    }

    @Override
    public void prepareLights(LightRenderer lightRenderer, CullFrustum frustum) {
    }

    @Override
    public void renderLights(LightRenderer lightRenderer) {
        if (this.lights.isEmpty()) {
            return;
        }
        class_1921 renderType = VeilRenderType.get(RENDER_TYPE, new Object[0]);
        if (renderType == null) {
            return;
        }
        this.vertexArray.bind();
        this.vertexArray.setup(renderType);
        this.render();
        this.vertexArray.clear(renderType);
        if (renderType instanceof VeilRenderType.LayeredRenderType) {
            VeilRenderType.LayeredRenderType layeredRenderType = (VeilRenderType.LayeredRenderType)renderType;
            for (class_1921 layer : layeredRenderType.getLayers()) {
                this.vertexArray.setup(layer);
                this.render();
                this.vertexArray.clear(layer);
            }
        }
    }

    private void render() {
        class_5944 shader = RenderSystem.getShader();
        if (shader == null) {
            return;
        }
        for (LightHandle handle : this.lights) {
            class_284 lightDirection;
            DirectionalLightData light = handle.getLightData();
            class_284 lightColorUniform = shader.method_34582("LightColor");
            if (lightColorUniform != null) {
                Color lightColor = light.getColor();
                float brightness = light.getBrightness();
                lightColorUniform.method_1249(lightColor.red() * brightness, lightColor.green() * brightness, lightColor.blue() * brightness);
                lightColorUniform.method_1300();
            }
            if ((lightDirection = shader.method_34582("LightDirection")) != null) {
                lightDirection.method_34413(light.getDirection().normalize(DIRECTION));
                lightDirection.method_1300();
            }
            this.vertexArray.draw();
        }
    }

    @Override
    public Collection<? extends LightRenderHandle<DirectionalLightData>> getLights() {
        return this.lights;
    }

    @Override
    public int getVisibleLights() {
        return this.lights.size();
    }

    public void free() {
        this.vertexArray.close();
        this.freed = true;
    }

    private class LightHandle
    implements LightRenderHandle<DirectionalLightData> {
        private final DirectionalLightData data;

        private LightHandle(DirectionalLightData data) {
            this.data = data;
        }

        @Override
        public DirectionalLightData getLightData() {
            return this.data;
        }

        @Override
        public void markDirty() {
        }

        @Override
        public boolean isValid() {
            return !DirectionalLightRenderer.this.freed;
        }

        public void free() {
            DirectionalLightRenderer.this.lights.remove(this);
        }
    }
}

