/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.pipeline;

import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferAttachmentDefinition;
import foundry.veil.api.client.render.framebuffer.FramebufferStack;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.compat.IrisCompat;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class VeilBloomRenderer {
    private static final class_2960 BLOOM_PIPELINE = Veil.veilPath("core/bloom");
    private static boolean enabled;
    private static boolean rendered;
    private static AdvancedFbo bloom;

    public static void tryEnable() {
        boolean wasEnabled = enabled;
        boolean bl = enabled = VeilBloomRenderer.getPipeline() != null;
        if (wasEnabled != enabled) {
            if (enabled) {
                Veil.LOGGER.info("Enabled bloom pipeline");
                rendered = false;
            } else {
                Veil.LOGGER.warn("Disabled bloom pipeline due to error");
                VeilBloomRenderer.free();
            }
        }
    }

    public static void setupRenderState() {
        if (!enabled) {
            return;
        }
        if (IrisCompat.INSTANCE != null && IrisCompat.INSTANCE.areShadersLoaded()) {
            return;
        }
        AdvancedFbo mainRenderTarget = AdvancedFbo.getMainFramebuffer();
        int w = mainRenderTarget.getWidth();
        int h = mainRenderTarget.getHeight();
        int framebufferTexture = mainRenderTarget.getDepthTextureAttachment().method_4624();
        if (bloom == null || bloom.getWidth() != w || bloom.getHeight() != h) {
            VeilBloomRenderer.free();
            bloom = AdvancedFbo.withSize(w, h).setFormat(FramebufferAttachmentDefinition.Format.RGBA16F).addColorTextureBuffer().setDepthTextureWrapper(framebufferTexture).setDebugLabel("Veil Bloom").build(true);
        }
        FramebufferStack.push(null);
        VeilRenderSystem.renderer().getFramebufferManager().setFramebuffer(VeilFramebuffers.BLOOM, bloom);
        bloom.bind(true);
        rendered = true;
    }

    public static void clearRenderState() {
        if (!enabled) {
            return;
        }
        FramebufferStack.pop(null);
    }

    @Nullable
    private static PostPipeline getPipeline() {
        PostPipeline pipeline = VeilRenderSystem.renderer().getPostProcessingManager().getPipeline(BLOOM_PIPELINE);
        if (pipeline == null) {
            Veil.LOGGER.error("Failed to apply bloom pipeline");
        }
        return pipeline;
    }

    public static void flush() {
        if (!rendered || !enabled) {
            return;
        }
        rendered = false;
        PostPipeline pipeline = VeilBloomRenderer.getPipeline();
        if (pipeline == null) {
            enabled = false;
            return;
        }
        class_3695 profiler = class_310.method_1551().method_16011();
        profiler.method_15396("bloom");
        FramebufferStack.push(null);
        VeilRenderSystem.renderer().getPostProcessingManager().runPipeline(pipeline);
        bloom.clear(16384);
        FramebufferStack.pop(null);
        profiler.method_15407();
    }

    public static void free() {
        if (bloom != null) {
            VeilRenderSystem.renderer().getFramebufferManager().removeFramebuffer(VeilFramebuffers.BLOOM);
            bloom.free();
            bloom = null;
        }
    }
}

