/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.rendertype;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.Veil;
import foundry.veil.api.client.render.rendertype.layer.CompositeRenderTypeData;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DynamicRenderTypeManager
extends class_4080<Map<class_2960, byte[]>> {
    private static final class_7654 CONVERTER = class_7654.method_45114((String)"pinwheel/rendertypes");
    private final Map<class_2960, RenderTypeCache> renderTypes = new Object2ObjectArrayMap();

    @Nullable
    public class_1921 get(class_2960 id, Object ... params) {
        RenderTypeCache cache = this.renderTypes.get(id);
        if (cache == null) {
            return null;
        }
        return cache.get(params);
    }

    @NotNull
    protected Map<class_2960, byte[]> prepare(@NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        HashMap<class_2960, byte[]> data = new HashMap<class_2960, byte[]>();
        Map resources = CONVERTER.method_45113(resourceManager);
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            class_2960 id = CONVERTER.method_45115(location);
            try {
                InputStream stream = ((class_3298)entry.getValue()).method_14482();
                try {
                    data.put(id, stream.readAllBytes());
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                Veil.LOGGER.error("Couldn't read data file {} from {}", new Object[]{id, location, e});
            }
        }
        return data;
    }

    protected void apply(Map<class_2960, byte[]> fileData, class_3300 resourceManager, class_3695 profilerFiller) {
        HashMap<class_2960, RenderTypeCache> renderTypes = new HashMap<class_2960, RenderTypeCache>();
        for (Map.Entry<class_2960, byte[]> entry : fileData.entrySet()) {
            class_2960 id = entry.getKey();
            try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(entry.getValue()));){
                JsonElement element = JsonParser.parseReader((Reader)reader);
                DataResult result = CompositeRenderTypeData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                if (result.error().isPresent()) {
                    throw new JsonSyntaxException(((DataResult.Error)result.error().get()).message());
                }
                CompositeRenderTypeData data = (CompositeRenderTypeData)result.result().orElseThrow();
                if (renderTypes.put(id, new RenderTypeCache(id.toString(), data)) == null) continue;
                throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(id));
            }
            catch (Exception e) {
                Veil.LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, CONVERTER.method_45112(id), e});
            }
        }
        this.renderTypes.clear();
        this.renderTypes.putAll(renderTypes);
        Veil.LOGGER.info("Loaded {} render types", (Object)renderTypes.size());
    }

    private static class RenderTypeCache {
        private final String name;
        private final CompositeRenderTypeData data;
        private final Cache<Integer, class_1921> objectCache;
        private class_1921 defaultCache;
        private boolean defaultError;

        public RenderTypeCache(String name, CompositeRenderTypeData data) {
            this.name = name;
            this.data = data;
            this.objectCache = CacheBuilder.newBuilder().initialCapacity(4).maximumSize(64L).expireAfterAccess(Duration.of(1000L, ChronoUnit.SECONDS)).build();
            this.defaultCache = null;
        }

        @Nullable
        public class_1921 get(Object ... params) {
            if (params.length == 0) {
                if (this.defaultError) {
                    return null;
                }
                if (this.defaultCache == null) {
                    try {
                        this.defaultCache = this.data.createRenderType(this.name, new Object[0]);
                    }
                    catch (Exception e) {
                        Veil.LOGGER.error("Failed to create rendertype {} with no parameters", (Object)this.name, (Object)e);
                        this.defaultError = true;
                    }
                }
                return this.defaultCache;
            }
            try {
                return (class_1921)this.objectCache.get((Object)Arrays.hashCode(params), () -> this.data.createRenderType(this.name, params));
            }
            catch (ExecutionException e) {
                Veil.LOGGER.error("Failed to create rendertype {} with parameters: [{}]", new Object[]{this.name, Arrays.stream(params).map(Objects::toString).collect(Collectors.joining(", ")), e});
                return null;
            }
        }
    }
}

