/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.block;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.block.DynamicShaderBlock;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import foundry.veil.impl.client.render.shader.block.ShaderBlockImpl;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryUtil;

@ApiStatus.Internal
public class DynamicShaderBlockImpl<T>
extends ShaderBlockImpl<T>
implements DynamicShaderBlock<T> {
    private final BiConsumer<T, ByteBuffer> serializer;
    private int size;
    private boolean resized;
    private ByteBuffer upload;

    public DynamicShaderBlockImpl(ShaderBlock.BufferBinding binding, int initialSize, BiConsumer<T, ByteBuffer> serializer) {
        super(binding);
        this.serializer = serializer;
        this.size = initialSize;
        this.resized = false;
        this.upload = MemoryUtil.memAlloc((int)initialSize);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
        this.resized = true;
        this.upload = MemoryUtil.memRealloc((ByteBuffer)this.upload, (int)size);
    }

    @Override
    public void bind(int index) {
        int binding = this.binding.getGlType();
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxTargetBindings(binding), (long)index);
        if (this.buffer == 0) {
            this.resized = true;
            this.buffer = DynamicShaderBlockImpl.getStorageType().createBuffer(binding);
        }
        if (this.resized) {
            this.resized = false;
            this.dirty = true;
            DynamicShaderBlockImpl.getStorageType().resize(binding, this.buffer, this.size);
        }
        if (this.dirty) {
            this.dirty = false;
            if (this.value != null) {
                this.serializer.accept(this.value, this.upload);
                this.upload.rewind();
            } else {
                MemoryUtil.memSet((ByteBuffer)this.upload, (int)0);
            }
            DynamicShaderBlockImpl.getStorageType().write(binding, this.buffer, this.upload);
        }
        GL30C.glBindBufferBase((int)binding, (int)index, (int)this.buffer);
    }

    @Override
    public void unbind(int index) {
        int binding = this.binding.getGlType();
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxTargetBindings(binding), (long)index);
        GL30C.glBindBufferBase((int)binding, (int)index, (int)0);
    }

    @Override
    public void free() {
        super.free();
        MemoryUtil.memFree((Buffer)this.upload);
    }
}

