/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.program;

import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.program.ShaderUniformCache;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Map;
import net.minecraft.class_1047;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.MemoryUtil;

@ApiStatus.Internal
public class ShaderTextureCache {
    private final ShaderProgram program;
    private final Object2IntMap<CharSequence> textures;
    private final Int2IntMap samplers;
    private final Object2IntMap<CharSequence> boundSamplers;
    private boolean textureDirty;
    private boolean samplerDirty;
    private IntBuffer textureBindings;
    private IntBuffer samplerBindings;

    public ShaderTextureCache(ShaderProgram program) {
        this.program = program;
        this.textures = new Object2IntArrayMap();
        this.samplers = new Int2IntArrayMap();
        this.boundSamplers = new Object2IntArrayMap();
        this.textureBindings = null;
        this.samplerBindings = null;
    }

    private void uploadTextures(ShaderUniformCache cache, int samplerStart) {
        this.boundSamplers.clear();
        int maxSampler = VeilRenderSystem.maxCombinedTextureUnits();
        int count = 0;
        int missingTexture = class_1047.method_4540().method_4624();
        boolean hasMissing = false;
        String last = null;
        for (Map.Entry<String, ShaderUniformCache.Uniform> entry : cache.getSamplers().entrySet()) {
            String name = entry.getKey();
            int textureId = this.textures.getInt((Object)name);
            ShaderUniform uniform = this.program.getOrCreateUniform(name);
            if (textureId == 0 || textureId == missingTexture) {
                if (!hasMissing) {
                    hasMissing = true;
                    int position = this.textureBindings.position();
                    for (int i2 = 0; i2 < position; ++i2) {
                        this.textureBindings.put(i2 + 1, this.textureBindings.get(i2));
                    }
                    this.textureBindings.position(position + 1);
                    this.textureBindings.put(0, class_1047.method_4540().method_4624());
                    for (CharSequence boundSampler : this.boundSamplers.keySet()) {
                        this.boundSamplers.computeInt((Object)boundSampler, (unused, i) -> i + 1);
                    }
                }
                uniform.setInt(0);
                this.textures.removeInt((Object)name);
                continue;
            }
            int sampler = samplerStart + count;
            if (sampler >= maxSampler) {
                if (!hasMissing) {
                    hasMissing = true;
                    int position = this.textureBindings.position();
                    for (int i3 = 0; i3 < position - 1; ++i3) {
                        this.textureBindings.put(i3 + 1, this.textureBindings.get(i3));
                    }
                    this.textureBindings.put(0, class_1047.method_4540().method_4624());
                    if (last != null) {
                        this.boundSamplers.removeInt((Object)last);
                    }
                    for (CharSequence boundSampler : this.boundSamplers.keySet()) {
                        this.boundSamplers.computeInt((Object)boundSampler, (unused, i) -> i + 1);
                    }
                }
                uniform.setInt(0);
            } else {
                this.textureBindings.put(textureId);
                this.boundSamplers.put((Object)name, sampler);
            }
            ++count;
            last = name;
        }
        for (Object2IntMap.Entry entry : this.boundSamplers.object2IntEntrySet()) {
            this.program.getOrCreateUniform((CharSequence)entry.getKey()).setInt(entry.getIntValue());
        }
        if (samplerStart + count >= maxSampler) {
            Veil.LOGGER.error("Too many samplers were bound for shader (max {}): {}", (Object)maxSampler, (Object)this.program.getName());
        }
    }

    public void bind(ShaderUniformCache cache, int samplerStart) {
        if (this.textures.isEmpty()) {
            return;
        }
        if (this.textureDirty) {
            this.textureDirty = false;
            this.samplerDirty = true;
            if (this.textureBindings == null || this.textureBindings.capacity() < 1 + this.textures.size()) {
                this.textureBindings = MemoryUtil.memRealloc((IntBuffer)this.textureBindings, (int)(1 + this.textures.size()));
            }
            this.textureBindings.clear();
            this.uploadTextures(cache, samplerStart);
            this.textureBindings.flip();
            if (this.textureBindings.limit() == 0) {
                MemoryUtil.memFree((Buffer)this.textureBindings);
                MemoryUtil.memFree((Buffer)this.samplerBindings);
                this.textureBindings = null;
                this.samplerBindings = null;
            }
        }
        if (this.textureBindings != null && this.textureBindings.limit() > 0) {
            VeilRenderSystem.bindTextures(samplerStart, this.textureBindings);
            if (this.samplerDirty) {
                this.samplerDirty = false;
                if (this.samplerBindings == null || this.samplerBindings.capacity() < this.textureBindings.limit()) {
                    this.samplerBindings = MemoryUtil.memRealloc((IntBuffer)this.samplerBindings, (int)this.textureBindings.limit());
                }
                this.samplerBindings.limit(this.textureBindings.limit());
                for (int i = 0; i < this.textureBindings.limit(); ++i) {
                    this.samplerBindings.put(i, this.samplers.get(this.textureBindings.get(i)));
                }
            }
            VeilRenderSystem.bindSamplers(samplerStart, this.samplerBindings);
        }
    }

    public void put(CharSequence name, int textureId, int samplerId) {
        this.textureDirty |= this.textures.put((Object)name, textureId) != textureId;
        this.samplerDirty = samplerId != 0 ? (this.samplerDirty |= this.samplers.put(textureId, samplerId) != samplerId) : (this.samplerDirty |= this.samplers.remove(textureId) != samplerId);
    }

    public void remove(CharSequence name) {
        int oldId = this.textures.removeInt((Object)name);
        if (oldId != 0) {
            this.textures.put((Object)name, 0);
            this.textureDirty = true;
            if (this.samplers.remove(oldId) != 0) {
                this.samplerDirty = true;
            }
        }
    }

    public void clear() {
        this.textures.clear();
        this.samplers.clear();
        this.boundSamplers.clear();
        if (this.textureBindings != null) {
            MemoryUtil.memFree((Buffer)this.textureBindings);
            this.textureBindings = null;
        }
        if (this.samplerBindings != null) {
            MemoryUtil.memFree((Buffer)this.samplerBindings);
            this.samplerBindings = null;
        }
        this.textureDirty = true;
        this.samplerDirty = true;
    }
}

