/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.pipeline.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilLevelPerspectiveRenderer;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.framebuffer.FramebufferStack;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.compat.SodiumCompat;
import foundry.veil.ext.LevelRendererExtension;
import foundry.veil.impl.client.render.shader.VeilVanillaShaders;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1041;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_284;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4604;
import net.minecraft.class_4668;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_846;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public abstract class PipelineLevelRendererMixin
implements LevelRendererExtension {
    @Shadow
    private class_4604 field_27740;
    @Shadow
    @Nullable
    private class_4604 field_4056;
    @Shadow
    @Nullable
    private class_279 field_25279;
    @Shadow
    @Nullable
    private class_276 field_25274;
    @Shadow
    @Nullable
    private class_276 field_25275;
    @Shadow
    @Nullable
    private class_276 field_25276;
    @Shadow
    @Nullable
    private class_276 field_25277;
    @Shadow
    @Nullable
    private class_276 field_25278;
    @Shadow
    @Final
    private ObjectArrayList<class_846.class_851> field_45616;
    @Shadow
    @Final
    private class_310 field_4088;
    @Unique
    private final Matrix4f veil$tempFrustum = new Matrix4f();
    @Unique
    private final Matrix4f veil$tempProjection = new Matrix4f();

    @Shadow
    protected abstract void method_3251(class_1921 var1, double var2, double var4, double var6, Matrix4f var8, Matrix4f var9);

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=entities"})})
    public void saveFramebuffer(CallbackInfo ci) {
        FramebufferStack.push(null);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;getModelViewStack()Lorg/joml/Matrix4fStack;")}, remap=false)
    public void loadFramebuffer(CallbackInfo ci) {
        FramebufferStack.pop(null);
    }

    @Inject(method={"prepareCullFrustum"}, at={@At(value="HEAD")})
    public void veil$setupLevelCamera(class_243 pos, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        VeilRenderSystem.renderer().getCameraMatrices().update((Matrix4fc)projectionMatrix, (Matrix4fc)frustumMatrix, pos.method_10216(), pos.method_10214(), pos.method_10215());
    }

    @Inject(method={"renderLevel"}, at={@At(value="TAIL")})
    public void blit(CallbackInfo ci, @Local class_3695 profiler) {
        if (!VeilLevelPerspectiveRenderer.isRenderingPerspective()) {
            if (VeilRenderSystem.drawLights(profiler, VeilRenderSystem.getCullingFrustum())) {
                VeilRenderSystem.compositeLights(profiler);
            } else {
                AdvancedFbo.unbind();
            }
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=weather"})})
    public void setRainBlend(CallbackInfo ci) {
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }

    @ModifyArg(method={"renderWorldBorder"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShader(Ljava/util/function/Supplier;)V", remap=false))
    public Supplier<class_5944> setWorldBorderShader(Supplier<class_5944> supplier) {
        return VeilVanillaShaders::getWorldborder;
    }

    @Inject(method={"deinitTransparency"}, at={@At(value="RETURN")})
    public void deinitTransparency(CallbackInfo ci) {
        FramebufferManager framebufferManager = VeilRenderSystem.renderer().getFramebufferManager();
        framebufferManager.removeFramebuffer(VeilFramebuffers.TRANSLUCENT_TARGET);
        framebufferManager.removeFramebuffer(VeilFramebuffers.ITEM_ENTITY_TARGET);
        framebufferManager.removeFramebuffer(VeilFramebuffers.PARTICLES_TARGET);
        framebufferManager.removeFramebuffer(VeilFramebuffers.WEATHER_TARGET);
        framebufferManager.removeFramebuffer(VeilFramebuffers.CLOUDS_TARGET);
    }

    @Inject(method={"initTransparency"}, at={@At(value="RETURN")})
    public void initTransparency(CallbackInfo ci) {
        if (this.field_25279 == null) {
            return;
        }
        FramebufferManager framebufferManager = VeilRenderSystem.renderer().getFramebufferManager();
        framebufferManager.setFramebuffer(VeilFramebuffers.TRANSLUCENT_TARGET, VeilRenderBridge.wrap(this.field_25274));
        framebufferManager.setFramebuffer(VeilFramebuffers.ITEM_ENTITY_TARGET, VeilRenderBridge.wrap(this.field_25275));
        framebufferManager.setFramebuffer(VeilFramebuffers.PARTICLES_TARGET, VeilRenderBridge.wrap(this.field_25276));
        framebufferManager.setFramebuffer(VeilFramebuffers.WEATHER_TARGET, VeilRenderBridge.wrap(this.field_25277));
        framebufferManager.setFramebuffer(VeilFramebuffers.CLOUDS_TARGET, VeilRenderBridge.wrap(this.field_25278));
    }

    @Inject(method={"setLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/SectionOcclusionGraph;waitAndReset(Lnet/minecraft/client/renderer/ViewArea;)V")})
    public void free(class_638 level, CallbackInfo ci) {
        VeilRenderSystem.clearLevel();
    }

    @Override
    public CullFrustum veil$getCullFrustum() {
        return VeilRenderBridge.create(this.field_4056 != null ? this.field_4056 : this.field_27740);
    }

    @Override
    public void veil$drawBlockLayer(class_1921 renderType, double x, double y, double z, Matrix4fc frustum, Matrix4fc projection) {
        RenderSystem.assertOnRenderThread();
        while (renderType instanceof VeilRenderType.RenderTypeWrapper) {
            VeilRenderType.RenderTypeWrapper wrapper = (VeilRenderType.RenderTypeWrapper)renderType;
            renderType = wrapper.get();
        }
        if (renderType == null) {
            return;
        }
        if (renderType instanceof VeilRenderType.LayeredRenderType) {
            VeilRenderType.LayeredRenderType layeredRenderType = (VeilRenderType.LayeredRenderType)renderType;
            class_3695 profiler = this.field_4088.method_16011();
            this.veil$tempFrustum.set(frustum);
            this.veil$tempProjection.set(projection);
            class_1041 window = this.field_4088.method_22683();
            List<class_1921> layers = layeredRenderType.getLayers();
            boolean rendered = false;
            profiler.method_15396("render_" + VeilRenderType.getName((class_4668)renderType));
            boolean forward = !renderType.method_60894();
            ObjectListIterator objectlistiterator = this.field_45616.listIterator(forward ? 0 : this.field_45616.size());
            class_5944 shaderInstance = null;
            class_284 chunkOffset = null;
            ObjectArrayList validSections = new ObjectArrayList(this.field_45616.size());
            ObjectArrayList buffers = new ObjectArrayList(this.field_45616.size());
            while (!(!forward ? !objectlistiterator.hasPrevious() : !objectlistiterator.hasNext())) {
                class_846.class_851 section = forward ? (class_846.class_851)objectlistiterator.next() : (class_846.class_851)objectlistiterator.previous();
                if (section.method_3677().method_3641(renderType)) continue;
                if (!rendered) {
                    renderType.method_23516();
                    shaderInstance = RenderSystem.getShader();
                    if (shaderInstance != null) {
                        shaderInstance.method_60897(class_293.class_5596.field_27382, this.veil$tempFrustum, this.veil$tempProjection, window);
                        shaderInstance.method_34586();
                        chunkOffset = shaderInstance.field_29482;
                    }
                    rendered = true;
                }
                if (chunkOffset != null) {
                    class_2338 origin = section.method_3670();
                    chunkOffset.method_1249((float)((double)origin.method_10263() - x), (float)((double)origin.method_10264() - y), (float)((double)origin.method_10260() - z));
                    chunkOffset.method_1300();
                }
                class_291 vertexbuffer = section.method_3656(renderType);
                vertexbuffer.method_1353();
                vertexbuffer.method_35665();
                validSections.add((Object)section);
                buffers.add((Object)vertexbuffer);
            }
            if (!rendered) {
                profiler.method_15407();
                return;
            }
            if (chunkOffset != null) {
                chunkOffset.method_1249(0.0f, 0.0f, 0.0f);
            }
            if (shaderInstance != null) {
                shaderInstance.method_34585();
            }
            renderType.method_23518();
            profiler.method_15407();
            if (!validSections.isEmpty()) {
                for (class_1921 layer : layers) {
                    layer.method_23516();
                    profiler.method_15396("render_" + VeilRenderType.getName((class_4668)layers.getFirst()));
                    shaderInstance = RenderSystem.getShader();
                    if (shaderInstance != null) {
                        shaderInstance.method_60897(class_293.class_5596.field_27382, this.veil$tempFrustum, this.veil$tempProjection, window);
                        shaderInstance.method_34586();
                        chunkOffset = shaderInstance.field_29482;
                    }
                    for (int j = 0; j < validSections.size(); ++j) {
                        class_846.class_851 section = (class_846.class_851)validSections.get(j);
                        class_291 vertexbuffer = (class_291)buffers.get(j);
                        if (chunkOffset != null) {
                            class_2338 origin = section.method_3670();
                            chunkOffset.method_1249((float)((double)origin.method_10263() - x), (float)((double)origin.method_10264() - y), (float)((double)origin.method_10260() - z));
                            chunkOffset.method_1300();
                        }
                        vertexbuffer.method_1353();
                        vertexbuffer.method_35665();
                    }
                    if (chunkOffset != null) {
                        chunkOffset.method_1249(0.0f, 0.0f, 0.0f);
                    }
                    if (shaderInstance != null) {
                        shaderInstance.method_34585();
                    }
                    profiler.method_15407();
                    layer.method_23518();
                }
            }
            class_291.method_1354();
        } else {
            this.method_3251(renderType, x, y, z, this.veil$tempFrustum.set(frustum), this.veil$tempProjection.set(projection));
        }
    }

    @Override
    public void veil$markChunksDirty() {
        SodiumCompat sodiumCompat = SodiumCompat.INSTANCE;
        if (sodiumCompat != null) {
            sodiumCompat.markChunksDirty();
        } else {
            for (class_846.class_851 section : this.field_45616) {
                section.method_3654(false);
            }
        }
    }
}

