/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.lists;

import foundry.veil.api.client.render.VeilLevelPerspectiveRenderer;
import foundry.veil.fabric.ext.RenderRegionExtension;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.OcclusionCuller;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.class_4076;

public class PerspectiveChunkCollector
implements OcclusionCuller.Visitor {
    private final ObjectArrayList<ChunkRenderList> sortedRenderLists = new ObjectArrayList();
    private static int[] sortItems = new int[256];

    public void visit(RenderSection section) {
        if (section.getFlags() != 0) {
            RenderRegion region = section.getRegion();
            RenderRegionExtension ext = (RenderRegionExtension)region;
            ChunkRenderList renderList = ext.veil$getPerspectiveRenderList();
            if (renderList.getLastVisibleFrame() != VeilLevelPerspectiveRenderer.getID()) {
                renderList.reset(VeilLevelPerspectiveRenderer.getID());
                this.sortedRenderLists.add((Object)renderList);
            }
            renderList.add(section);
        }
    }

    public SortedRenderLists createRenderLists(Viewport viewport) {
        class_4076 sectionPos = viewport.getChunkCoord();
        int cameraX = sectionPos.method_10263() >> RenderRegion.REGION_WIDTH_SH;
        int cameraY = sectionPos.method_10264() >> RenderRegion.REGION_HEIGHT_SH;
        int cameraZ = sectionPos.method_10260() >> RenderRegion.REGION_LENGTH_SH;
        int size = this.sortedRenderLists.size();
        if (sortItems.length < size) {
            sortItems = new int[size];
        }
        for (int i = 0; i < size; ++i) {
            RenderRegion region = ((ChunkRenderList)this.sortedRenderLists.get(i)).getRegion();
            int x = Math.abs(region.getX() - cameraX);
            int y = Math.abs(region.getY() - cameraY);
            int z = Math.abs(region.getZ() - cameraZ);
            PerspectiveChunkCollector.sortItems[i] = x + y + z << 16 | i;
        }
        IntArrays.unstableSort((int[])sortItems, (int)0, (int)size);
        ObjectArrayList sorted = new ObjectArrayList(size);
        for (int i = 0; i < size; ++i) {
            int key = sortItems[i];
            ChunkRenderList renderList = (ChunkRenderList)this.sortedRenderLists.get(key & 0xFFFF);
            sorted.add((Object)renderList);
        }
        for (ChunkRenderList list : sorted) {
            list.sortSections(sectionPos, sortItems);
        }
        return new SortedRenderLists(sorted);
    }
}

